/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.filestorage.JobStorage;
import org.daisy.pipeline.client.filestorage.JobValidator;
import org.daisy.pipeline.client.models.Argument;
import org.daisy.pipeline.client.models.Callback;
import org.daisy.pipeline.client.models.JobMessages;
import org.daisy.pipeline.client.models.Message;
import org.daisy.pipeline.client.models.Result;
import org.daisy.pipeline.client.models.Script;
import org.daisy.pipeline.client.utils.Files;
import org.daisy.pipeline.client.utils.XML;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Job
implements Comparable<Job> {
    private String id;
    private String href;
    private Status status;
    private Priority priority;
    private Integer queuePosition;
    private String nicename;
    private String description;
    private String batchId;
    private Script script;
    private List<Argument> argumentInputs;
    private List<Argument> argumentOutputs;
    private List<Callback> callback;
    private JobMessages messages;
    private Node messagesNode;
    private String logHref;
    private Result result;
    private SortedMap<Result, List<Result>> results;
    private Node resultsNode;
    private BigDecimal progress;
    private boolean lazyLoaded = false;
    private Node jobNode = null;
    private JobStorage storage;
    private static final Map<String, String> ns = new HashMap<String, String>();

    public Job() {
    }

    public Job(Node jobXml) throws Pipeline2Exception {
        this();
        this.setJobXml(jobXml);
    }

    public Job(Job oldJob, JobStorage newStorage) throws Pipeline2Exception {
        this(oldJob.toXml());
        JobStorage oldStorage = oldJob.getJobStorage();
        if (newStorage == null || newStorage == oldStorage || newStorage.getContextDir().equals(oldStorage.getContextDir())) {
            this.storage = oldStorage;
        } else {
            File oldContextDir = oldStorage.getContextDir();
            Map<String, File> oldFiles = null;
            try {
                oldFiles = Files.listFilesRecursively(oldContextDir, false);
                if (oldFiles.size() > 0) {
                    for (String href : oldFiles.keySet()) {
                        newStorage.addContextFile(oldFiles.get(href), href);
                    }
                }
            }
            catch (IOException e) {
                Pipeline2Logger.logger().error("Could not list files in old job context", e);
            }
            this.storage = newStorage;
        }
        this.setId(oldJob.getId());
        this.setHref(oldJob.getHref());
        this.setPriority(oldJob.getPriority());
        this.setNicename(oldJob.getNicename());
        this.setDescription(oldJob.getDescription());
        this.setScript(oldJob.getScript());
    }

    public static Result getResultFromHref(Node resultsXml, String href) {
        if (href == null) {
            href = "";
        }
        try {
            Node resultNode;
            if (resultsXml instanceof Document) {
                resultsXml = XPath.selectNode("/*", resultsXml, XPath.dp2ns);
            }
            if ((resultNode = "".equals(href) ? XPath.selectNode("./descendant-or-self::d:results", resultsXml, XPath.dp2ns) : XPath.selectNode("./descendant-or-self::*[@href='" + href.replaceAll("'", "''").replaceAll(" ", "%20") + "']", resultsXml, XPath.dp2ns)) != null) {
                return Result.parseResultXml(resultNode);
            }
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Could not parse job XML for finding the job result '" + href.replaceAll("'", "''").replaceAll(" ", "%20") + "'", e);
        }
        Pipeline2Logger.logger().debug("No result was found for href=" + href);
        return null;
    }

    private void lazyLoad() {
        if (this.storage != null) {
            this.storage.lazyLoad();
        }
        if (this.lazyLoaded || this.jobNode == null) {
            return;
        }
        try {
            String queuePosition;
            String id;
            if (this.jobNode instanceof Document) {
                this.jobNode = XPath.selectNode("/*", this.jobNode, XPath.dp2ns);
            }
            if ((id = XPath.selectText("@id", this.jobNode, XPath.dp2ns)) != null) {
                this.id = id;
            }
            this.href = XPath.selectText("@href", this.jobNode, XPath.dp2ns);
            String status = XPath.selectText("@status", this.jobNode, XPath.dp2ns);
            for (Status s : Status.values()) {
                if (!s.toString().equals(status)) continue;
                this.status = s;
                break;
            }
            String priority = XPath.selectText("@priority", this.jobNode, XPath.dp2ns);
            for (Priority p : Priority.values()) {
                if (!p.toString().equals(priority)) continue;
                this.priority = p;
                break;
            }
            if (this.priority == null) {
                priority = XPath.selectText("d:priority", this.jobNode, XPath.dp2ns);
                for (Priority p : Priority.values()) {
                    if (!p.toString().equals(priority)) continue;
                    this.priority = p;
                    break;
                }
            }
            if ((queuePosition = XPath.selectText("@queue-position", this.jobNode, XPath.dp2ns)) != null) {
                try {
                    this.queuePosition = Integer.parseInt(queuePosition);
                }
                catch (NumberFormatException e) {
                    Pipeline2Logger.logger().debug("Could not parse the queue position as an integer.", e);
                }
            }
            this.nicename = XPath.selectText("d:nicename", this.jobNode, XPath.dp2ns);
            this.description = XPath.selectText("d:description", this.jobNode, XPath.dp2ns);
            this.batchId = XPath.selectText("d:batchId", this.jobNode, XPath.dp2ns);
            Node scriptNode = XPath.selectNode("d:script", this.jobNode, XPath.dp2ns);
            if (scriptNode != null) {
                this.script = new Script(scriptNode);
            }
            this.logHref = XPath.selectText("d:log/@href", this.jobNode, XPath.dp2ns);
            this.callback = new ArrayList<Callback>();
            for (Node callbackNode : XPath.selectNodes("d:callback", this.jobNode, XPath.dp2ns)) {
                this.callback.add(new Callback(callbackNode));
            }
            this.messagesNode = XPath.selectNode("d:messages", this.jobNode, XPath.dp2ns);
            String progressString = XPath.selectText("d:messages/@progress", this.jobNode, XPath.dp2ns);
            if (progressString != null) {
                try {
                    this.progress = new BigDecimal(Double.parseDouble(progressString));
                }
                catch (NumberFormatException e) {
                    Pipeline2Logger.logger().debug("Could not parse the progress as a decimal number.", e);
                }
            }
            this.resultsNode = XPath.selectNode("d:results", this.jobNode, XPath.dp2ns);
            if (this.script == null) {
                this.argumentInputs = new ArrayList<Argument>();
                this.argumentOutputs = new ArrayList<Argument>();
                for (Node node : XPath.selectNodes("d:input | d:option", this.jobNode, XPath.dp2ns)) {
                    this.argumentInputs.add(new Argument(node));
                }
                for (Node node : XPath.selectNodes("d:output", this.jobNode, XPath.dp2ns)) {
                    this.argumentOutputs.add(new Argument(node));
                }
            }
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Unable to parse job XML", e);
        }
        this.lazyLoaded = true;
    }

    public List<Message> getMessages() {
        return this.getMessages(-1);
    }

    public List<Message> getMessages(int maxDepth) {
        return this.getMessages(maxDepth, new Date().getTime());
    }

    List<Message> getMessages(int maxDepth, long now) {
        this.lazyLoad();
        if (this.messages == null && this.messagesNode != null) {
            try {
                ArrayList<Message> messagesTree = new ArrayList<Message>();
                List<Node> messageNodes = XPath.selectNodes("d:message", this.messagesNode, XPath.dp2ns);
                for (Node messageNode : messageNodes) {
                    Message m = Job.parseMessage(messageNode, now);
                    messagesTree.add(m);
                }
                String msgSeq = XPath.selectText("@msgSeq", this.messagesNode, XPath.dp2ns);
                this.messages = new JobMessages(messagesTree, msgSeq != null ? Integer.parseInt(msgSeq) : -1);
            }
            catch (Exception e) {
                Pipeline2Logger.logger().error("Unable to parse messages XML", e);
            }
        }
        if (maxDepth >= 0) {
            ArrayList<Message> filteredMessages = new ArrayList<Message>();
            for (Message m : this.messages) {
                if (m.getDepth() > maxDepth) continue;
                filteredMessages.add(m);
            }
            return filteredMessages;
        }
        return this.messages;
    }

    private static Message parseMessage(Node messageNode, long now) throws Pipeline2Exception {
        String portion;
        Message m = new Message(now);
        m.text = XPath.selectText("@content", messageNode, XPath.dp2ns);
        if (XPath.selectText("@level", messageNode, XPath.dp2ns) != null) {
            m.level = Message.Level.valueOf(XPath.selectText("@level", messageNode, XPath.dp2ns));
        }
        if (XPath.selectText("@sequence", messageNode, XPath.dp2ns) != null) {
            m.sequence = Integer.valueOf(XPath.selectText("@sequence", messageNode, XPath.dp2ns));
        }
        if (XPath.selectText("@line", messageNode, XPath.dp2ns) != null) {
            m.line = Integer.valueOf(XPath.selectText("@line", messageNode, XPath.dp2ns));
        }
        if (XPath.selectText("@column", messageNode, XPath.dp2ns) != null) {
            m.column = Integer.valueOf(XPath.selectText("@column", messageNode, XPath.dp2ns));
        }
        if (XPath.selectText("@timeStamp", messageNode, XPath.dp2ns) != null) {
            m.setTimeStamp(XPath.selectText("@timeStamp", messageNode, XPath.dp2ns));
        }
        if (XPath.selectText("@file", messageNode, XPath.dp2ns) != null) {
            m.file = XPath.selectText("@file", messageNode, XPath.dp2ns);
        }
        if ((portion = XPath.selectText("@portion", messageNode, XPath.dp2ns)) != null) {
            Message.ProgressInfo progressInfo = new Message.ProgressInfo();
            progressInfo.portion = new BigDecimal(portion);
            String progress = XPath.selectText("@progress", messageNode, XPath.dp2ns);
            progressInfo.progress = progress != null ? new BigDecimal(progress) : BigDecimal.ZERO;
            m.progressInfo = progressInfo;
        }
        List<Node> childNodes = XPath.selectNodes("d:message", messageNode, XPath.dp2ns);
        m.children = new ArrayList<Message>();
        for (Node n : childNodes) {
            Message mm = Job.parseMessage(n, now);
            mm.parentSequence = m.sequence;
            mm.parent = m;
            m.children.add(mm);
        }
        return m;
    }

    private void lazyLoadResults() {
        this.lazyLoad();
        if (this.results == null && this.resultsNode != null) {
            try {
                this.result = Result.parseResultXml(this.resultsNode, this.href);
                this.results = new TreeMap<Result, List<Result>>();
                List<Node> resultNodes = XPath.selectNodes("d:result", this.resultsNode, XPath.dp2ns);
                for (Node resultPortOrOptionNode : resultNodes) {
                    Result resultPortOrOption = Result.parseResultXml(resultPortOrOptionNode, this.result.href);
                    ArrayList<Result> portOrOptionResults = new ArrayList<Result>();
                    List<Node> fileNodes = XPath.selectNodes("d:result", resultPortOrOptionNode, XPath.dp2ns);
                    for (Node fileNode : fileNodes) {
                        Result file = Result.parseResultXml(fileNode, resultPortOrOption.href);
                        portOrOptionResults.add(file);
                    }
                    Collections.sort(portOrOptionResults);
                    this.results.put(resultPortOrOption, portOrOptionResults);
                }
            }
            catch (Pipeline2Exception e) {
                Pipeline2Logger.logger().error("Unable to parse results XML", e);
            }
        }
    }

    public Result getResult() {
        this.lazyLoadResults();
        return this.result;
    }

    public Result getResult(String argumentName) {
        this.lazyLoadResults();
        if (argumentName == null) {
            return null;
        }
        for (Result result : this.getResults().keySet()) {
            if (!argumentName.equals(result.name)) continue;
            return result;
        }
        return null;
    }

    public Result getResult(String argumentName, String href) {
        this.lazyLoadResults();
        if (argumentName == null || href == null || this.results == null) {
            return null;
        }
        href = href.replaceAll(" ", "%20");
        Result argument = this.getResult(argumentName);
        if (!this.results.containsKey(argument)) {
            return null;
        }
        for (Result r : this.getResults(argumentName)) {
            if (!href.equals(r.href) && !href.equals(r.prettyRelativeHref)) continue;
            return r;
        }
        return null;
    }

    public List<Result> getResults(String argumentName) {
        if (argumentName == null) {
            return null;
        }
        for (Result result : this.getResults().keySet()) {
            if (!argumentName.equals(result.name)) continue;
            return (List)this.results.get(result);
        }
        return null;
    }

    public SortedMap<Result, List<Result>> getResults() {
        this.lazyLoad();
        this.lazyLoadResults();
        return this.results;
    }

    public static List<Job> parseJobsXml(Node jobsXml) throws Pipeline2Exception {
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (jobsXml instanceof Document) {
            jobsXml = XPath.selectNode("/d:jobs", jobsXml, XPath.dp2ns);
        }
        List<Node> jobNodes = XPath.selectNodes("d:job", jobsXml, XPath.dp2ns);
        for (Node jobNode : jobNodes) {
            jobs.add(new Job(jobNode));
        }
        return jobs;
    }

    public String validate() {
        for (Argument argument : this.getInputs()) {
            String error = JobValidator.validate(argument, this.storage);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public String validate(String name) {
        for (Argument argument : this.getInputs()) {
            if (!argument.getName().equals(name)) continue;
            return JobValidator.validate(argument, this.storage);
        }
        return null;
    }

    public String getId() {
        this.lazyLoad();
        return this.id;
    }

    public String getHref() {
        this.lazyLoad();
        return this.href;
    }

    public Status getStatus() {
        this.lazyLoad();
        return this.status;
    }

    public Priority getPriority() {
        this.lazyLoad();
        return this.priority;
    }

    public Integer getQueuePosition() {
        this.lazyLoad();
        return this.queuePosition;
    }

    public String getNicename() {
        this.lazyLoad();
        return this.nicename;
    }

    public String getDescription() {
        this.lazyLoad();
        return this.description;
    }

    public String getBatchId() {
        this.lazyLoad();
        return this.batchId;
    }

    public Script getScript() {
        this.lazyLoad();
        return this.script;
    }

    public String getScriptHref() {
        this.lazyLoad();
        if (this.script != null) {
            return this.script.getHref();
        }
        return null;
    }

    public List<Callback> getCallback() {
        this.lazyLoad();
        return this.callback;
    }

    public BigDecimal getProgress() {
        this.lazyLoad();
        return this.progress;
    }

    public String getLogHref() {
        this.lazyLoad();
        return this.logHref;
    }

    public JobStorage getJobStorage() {
        this.lazyLoad();
        return this.storage;
    }

    public void setId(String id) {
        this.lazyLoad();
        this.id = id;
    }

    public void setHref(String href) {
        this.lazyLoad();
        this.href = href;
    }

    public void setStatus(Status status) {
        this.lazyLoad();
        this.status = status;
    }

    public void setPriority(Priority priority) {
        this.lazyLoad();
        this.priority = priority;
    }

    public void setQueuePosition(Integer queuePosition) {
        this.lazyLoad();
        this.queuePosition = queuePosition;
    }

    public void setNicename(String nicename) {
        this.lazyLoad();
        this.nicename = nicename;
    }

    public void setDescription(String description) {
        this.lazyLoad();
        this.description = description;
    }

    public void setBatchId(String batchId) {
        this.lazyLoad();
        this.batchId = batchId;
    }

    public void setScript(Script script) {
        this.lazyLoad();
        this.script = script;
    }

    public void setScriptHref(String scriptHref) {
        this.lazyLoad();
        if (this.script == null) {
            try {
                this.script = new Script(scriptHref);
            }
            catch (Pipeline2Exception e) {
                Pipeline2Logger.logger().error("Could not create script element with href='" + scriptHref + "'", e);
            }
        } else {
            this.script.setHref(scriptHref);
        }
    }

    public void setCallback(List<Callback> callback) {
        this.lazyLoad();
        this.callback = callback;
    }

    public void setProgress(BigDecimal progress) {
        this.lazyLoad();
        this.progress = progress;
    }

    public void setLogHref(String logHref) {
        this.lazyLoad();
        this.logHref = logHref;
    }

    public void setJobStorage(JobStorage storage) {
        this.lazyLoad();
        this.storage = storage;
        this.lazyLoaded = false;
    }

    public void joinMessages(Job jobUpdate) {
        this.lazyLoad();
        if (this == jobUpdate) {
            return;
        }
        if (jobUpdate.messages == null) {
            return;
        }
        this.progress = jobUpdate.progress;
        if (this.messages == null) {
            this.messages = jobUpdate.messages;
        } else {
            this.messages.join(jobUpdate.messages);
        }
        Collections.sort(this.messages);
    }

    void joinMessages(List<Message> messagesTree) {
        this.lazyLoad();
        JobMessages update = new JobMessages(messagesTree, -1);
        if (this.messages == null) {
            this.messages = update;
        } else {
            this.messages.join(update);
        }
        Collections.sort(this.messages);
        this.progress = this.messages.getProgressFrom();
    }

    public void setResults(Result result, SortedMap<Result, List<Result>> results) {
        this.lazyLoad();
        this.lazyLoadResults();
        if (this.results != results) {
            if (results == null) {
                this.results = null;
            } else {
                this.results = new TreeMap<Result, List<Result>>();
                for (Result outputPortOrOption : results.keySet()) {
                    this.results.put(outputPortOrOption, new ArrayList());
                    ((List)this.results.get(outputPortOrOption)).addAll((Collection)results.get(outputPortOrOption));
                    Collections.sort((List)this.results.get(outputPortOrOption));
                }
            }
        }
        this.result = result;
    }

    public void setJobXml(Node jobXml) {
        this.jobNode = jobXml;
        this.lazyLoaded = false;
    }

    public List<Argument> getInputs() {
        this.lazyLoad();
        if (this.script == null) {
            if (this.argumentInputs == null) {
                this.argumentInputs = new ArrayList<Argument>();
            }
            return this.argumentInputs;
        }
        return this.script.getInputs();
    }

    public List<Argument> getOutputs() {
        this.lazyLoad();
        if (this.script == null) {
            if (this.argumentOutputs == null) {
                this.argumentOutputs = new ArrayList<Argument>();
            }
            return this.argumentOutputs;
        }
        return this.script.getOutputs();
    }

    public void setInputs(List<Argument> argumentInputs) {
        this.lazyLoad();
        if (this.script == null) {
            this.argumentInputs = argumentInputs;
        } else {
            this.script.setInputs(argumentInputs);
        }
    }

    public void setOutputs(List<Argument> argumentOutputs) {
        this.lazyLoad();
        if (this.script == null) {
            this.argumentOutputs = argumentOutputs;
        } else {
            this.script.setOutputs(argumentOutputs);
        }
    }

    public Argument getArgument(String name) {
        this.lazyLoad();
        List<Argument> inputs = this.getInputs();
        List<Argument> outputs = this.getOutputs();
        if (inputs != null) {
            for (Argument arg : this.getInputs()) {
                if (!arg.getName().equals(name)) continue;
                return arg;
            }
        }
        if (outputs != null) {
            for (Argument arg : this.getOutputs()) {
                if (!arg.getName().equals(name)) continue;
                return arg;
            }
        }
        return null;
    }

    @Override
    public int compareTo(Job o) {
        if (this.id == null && o.id == null) {
            return 0;
        }
        if (this.id == null && o.id != null) {
            return -1;
        }
        if (this.id != null && o.id == null) {
            return 1;
        }
        return this.id.compareTo(o.id);
    }

    public Result getResultFromHref(String href) {
        if (!(this.results != null || this.resultsNode == null || href != null && href.startsWith("http"))) {
            return Job.getResultFromHref(this.resultsNode, href);
        }
        this.lazyLoadResults();
        if (href == null || "".equals(href) || href.equals(this.result.href) || href.equals(this.result.relativeHref)) {
            return this.result;
        }
        for (Result key : this.results.keySet()) {
            if (href.equals(key.href) || href.equals(key.relativeHref)) {
                return key;
            }
            for (Result value : (List)this.results.get(key)) {
                if (value == null || !href.equals(value.href) && !href.equals(value.relativeHref)) continue;
                return value;
            }
        }
        return null;
    }

    public Document toXml() {
        Object e;
        this.lazyLoad();
        Document jobDocument = XML.getXml("<job xmlns=\"http://www.daisy.org/ns/pipeline/data\"/>");
        Element jobElement = jobDocument.getDocumentElement();
        if (this.id != null) {
            jobElement.setAttribute("id", this.id);
        }
        if (this.href != null) {
            jobElement.setAttribute("href", this.href);
        }
        if (this.status != null) {
            jobElement.setAttribute("status", this.status.toString());
        }
        if (this.priority != null) {
            jobElement.setAttribute("priority", this.priority.toString());
        }
        if (this.script != null) {
            XML.appendChildAcrossDocuments(jobElement, this.script.toXml().getDocumentElement());
        }
        if (this.nicename != null) {
            e = jobElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "nicename");
            e.setTextContent(this.nicename);
            jobElement.appendChild((Node)e);
        }
        if (this.description != null) {
            e = jobElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "description");
            e.setAttribute("xml:space", "preserve");
            e.setTextContent(this.description);
            jobElement.appendChild((Node)e);
        }
        if (this.batchId != null) {
            e = jobElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "batchId");
            e.setTextContent(this.batchId);
            jobElement.appendChild((Node)e);
        }
        if (this.logHref != null) {
            e = jobElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "log");
            e.setAttribute("href", this.logHref);
            jobElement.appendChild((Node)e);
        }
        if (this.callback != null) {
            for (Callback callback : this.callback) {
                XML.appendChildAcrossDocuments(jobElement, callback.toXml().getDocumentElement());
            }
        }
        if (this.messages != null) {
            Element msgsElement = jobElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "messages");
            if (this.progress != null) {
                msgsElement.setAttribute("progress", Float.toString(this.progress.floatValue()));
            }
            if (this.messages.msgSeq >= 0) {
                msgsElement.setAttribute("msgSeq", "" + this.messages.msgSeq);
            }
            for (Message m : this.messages.asTree()) {
                XML.appendChildAcrossDocuments(msgsElement, m.toXml());
            }
            jobElement.appendChild(msgsElement);
        }
        if (this.results != null) {
            Element resultsElement = jobDocument.createElementNS(XPath.dp2ns.get("d"), "results");
            this.result.toXml(resultsElement);
            for (Result r : this.results.keySet()) {
                Element resultElement = jobDocument.createElementNS(XPath.dp2ns.get("d"), "result");
                r.toXml(resultElement);
                for (Result fileResult : (List)this.results.get(r)) {
                    Element fileElement = jobDocument.createElementNS(XPath.dp2ns.get("d"), "result");
                    fileResult.toXml(fileElement);
                    resultElement.appendChild(fileElement);
                }
                resultsElement.appendChild(resultElement);
            }
            jobElement.appendChild(resultsElement);
        }
        if (this.script == null) {
            if (this.argumentInputs != null) {
                for (Argument argument : this.argumentInputs) {
                    XML.appendChildAcrossDocuments(jobElement, argument.toXml().getDocumentElement());
                }
            }
            if (this.argumentOutputs != null) {
                for (Argument argument : this.argumentOutputs) {
                    XML.appendChildAcrossDocuments(jobElement, argument.toXml().getDocumentElement());
                }
            }
        }
        return jobDocument;
    }

    public Document toJobRequestXml(boolean absoluteUris) {
        String value;
        Element item;
        Element arg;
        Element e;
        this.lazyLoad();
        Document jobRequestDocument = XML.getXml("<jobRequest xmlns=\"http://www.daisy.org/ns/pipeline/data\"/>");
        Element jobRequestElement = jobRequestDocument.getDocumentElement();
        if (this.script != null) {
            e = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "script");
            e.setAttribute("href", this.script.getHref());
            jobRequestElement.appendChild(e);
        } else {
            Pipeline2Logger.logger().warn("script/@href is required in jobRequest.");
        }
        if (this.nicename != null) {
            e = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "nicename");
            e.setTextContent(this.nicename);
            jobRequestElement.appendChild(e);
        } else {
            Pipeline2Logger.logger().debug("nicename for job is not provided.");
        }
        if (this.priority != null) {
            e = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "priority");
            e.setTextContent(this.priority.toString());
            jobRequestElement.appendChild(e);
        } else {
            Pipeline2Logger.logger().debug("priority for job is not provided.");
        }
        if (this.batchId != null) {
            e = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "batchId");
            e.setTextContent(this.batchId);
            jobRequestElement.appendChild(e);
        } else {
            Pipeline2Logger.logger().debug("batchId for job is not provided.");
        }
        ArrayList<Argument> options = new ArrayList<Argument>();
        ArrayList<Argument> inputs = new ArrayList<Argument>();
        List<Argument> outputs = this.getOutputs();
        for (Argument inputOrOption : this.getInputs()) {
            if (inputOrOption.getKind() == Argument.Kind.input) {
                inputs.add(inputOrOption);
                continue;
            }
            options.add(inputOrOption);
        }
        File contextDir = this.storage == null ? null : this.storage.getContextDir();
        URI contextDirUri = contextDir == null ? null : contextDir.toURI();
        for (Argument input : inputs) {
            if (!input.isDefined()) continue;
            arg = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "input");
            arg.setAttribute("name", input.getName());
            if (contextDirUri != null) {
                for (File file : input.getAsFileList(this.storage)) {
                    item = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "item");
                    if (file == null) {
                        Pipeline2Logger.logger().warn("File referenced from '" + input.getName() + "' not found in context: '" + input.get() + "'");
                        value = input.get();
                    } else {
                        value = absoluteUris ? file.toURI().toString() : input.get();
                    }
                    item.setAttribute("value", value);
                    arg.appendChild(item);
                }
            } else {
                for (String value2 : input.getAsList()) {
                    item = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "item");
                    item.setAttribute("value", value2);
                    arg.appendChild(item);
                }
            }
            jobRequestElement.appendChild(arg);
        }
        for (Argument option : options) {
            if (!option.isDefined()) continue;
            arg = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "option");
            arg.setAttribute("name", option.getName());
            if (option.getSequence().booleanValue()) {
                if (contextDirUri != null && ("anyFileURI".equals(option.getType()) || "anyDirURI".equals(option.getType()) || "anyURI".equals(option.getType()))) {
                    for (File file : option.getAsFileList(this.storage)) {
                        item = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "item");
                        if (file == null) {
                            Pipeline2Logger.logger().warn("File referenced from '" + option.getName() + "' not found in context: '" + option.get() + "'");
                            value = option.get();
                        } else {
                            value = absoluteUris ? file.toURI().toString() : option.get();
                        }
                        item.setAttribute("value", value);
                        arg.appendChild(item);
                    }
                } else {
                    for (String value2 : option.getAsList()) {
                        item = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "item");
                        item.setAttribute("value", value2);
                        arg.appendChild(item);
                    }
                }
            } else {
                String value3;
                if (contextDirUri != null && ("anyFileURI".equals(option.getType()) || "anyDirURI".equals(option.getType()) || "anyURI".equals(option.getType()))) {
                    File file;
                    file = option.getAsFile(this.storage);
                    if (file == null) {
                        Pipeline2Logger.logger().warn("File referenced from '" + option.getName() + "' not found in context: '" + option.get() + "'");
                        value3 = option.get();
                    } else {
                        value3 = absoluteUris ? file.toURI().toString() : option.get();
                    }
                } else {
                    value3 = option.get();
                }
                if ("".equals(value3)) {
                    Element item2 = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "item");
                    item2.setAttribute("value", value3);
                    arg.appendChild(item2);
                } else {
                    arg.setTextContent(value3);
                }
            }
            jobRequestElement.appendChild(arg);
        }
        for (Argument output : outputs) {
            if (!output.isDefined()) continue;
            arg = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "output");
            arg.setAttribute("name", output.getName());
            for (String value2 : output.getAsList()) {
                item = jobRequestElement.getOwnerDocument().createElementNS(XPath.dp2ns.get("d"), "item");
                item.setAttribute("value", value2);
                arg.appendChild(item);
            }
            jobRequestElement.appendChild(arg);
        }
        if (this.callback != null) {
            for (Callback c : this.callback) {
                XML.appendChildAcrossDocuments(jobRequestElement, c.toXml());
            }
        } else {
            Pipeline2Logger.logger().debug("callback for job is not provided.");
        }
        return jobRequestDocument;
    }

    public List<Argument> getArguments() {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.addAll(this.getInputs());
        arguments.addAll(this.getOutputs());
        return arguments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getProgressFrom() {
        this.lazyLoad();
        if (this.progress == null && this.messagesNode != null) {
            try {
                String attr = XPath.selectText("@progress", this.messagesNode, XPath.dp2ns);
                if (attr == null) {
                    if (this.messages == null) throw new RuntimeException("could not compute progress");
                    this.progress = this.messages.getProgressFrom();
                } else {
                    this.progress = new BigDecimal(attr).min(BigDecimal.ONE);
                }
            }
            catch (Pipeline2Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.progress != null) return Job.toPercentage(this.progress);
        return 0.0;
    }

    public Long getProgressFromTime() {
        if (this.messages == null) {
            return null;
        }
        return this.messages.getProgressFromTime();
    }

    public double getProgressTo() {
        return this.getProgressTo(1000);
    }

    public double getProgressTo(Integer timeUntilUpdateRequest) {
        return this.getProgressTo(new Date().getTime(), timeUntilUpdateRequest);
    }

    private double getProgressTo(long now, Integer timeUntilUpdateRequest) {
        if (this.messages == null) {
            return 100.0;
        }
        return Math.min(100.0, this.getProgressFrom() + this.getProgressInterval(now, timeUntilUpdateRequest));
    }

    public double getProgressEstimate() {
        return this.getProgressEstimate(1000);
    }

    public double getProgressEstimate(Integer timeUntilUpdateRequest) {
        return this.getProgressEstimate(new Date().getTime(), timeUntilUpdateRequest);
    }

    double getProgressEstimate(Long now) {
        return this.getProgressEstimate(now, null);
    }

    double getProgressEstimate(Long now, Integer timeUntilUpdateRequest) {
        this.getMessages();
        if (this.status == null || this.status == Status.IDLE) {
            return 0.0;
        }
        if (this.status != Status.RUNNING) {
            return 100.0;
        }
        if (this.messages == null) {
            return 0.0;
        }
        Long previousTime = this.messages.getProgressFromTime();
        if (previousTime == null) {
            previousTime = now;
        }
        Double previousPercentage = this.getProgressFrom();
        Double nextPercentage = this.getProgressTo();
        Double inverseExponential = nextPercentage - (nextPercentage - previousPercentage) * Math.exp(-((double)Math.max(0L, now - previousTime)) / this.getProgressTimeConstant(now, timeUntilUpdateRequest));
        Double linear = previousPercentage + (double)(now - previousTime) * this.getAverageProgress(now);
        return Math.min(linear, inverseExponential);
    }

    private double getProgressInterval(long now, Integer timeUntilUpdateRequest) {
        if (this.messages == null) {
            return 0.0;
        }
        double interval = Job.toPercentage(this.messages.getProgressInterval());
        if (timeUntilUpdateRequest != null) {
            double minInterval = this.getAverageProgress(now) * (double)timeUntilUpdateRequest.intValue();
            interval = Math.max(interval, minInterval);
        }
        return interval;
    }

    private double getAverageProgress(Long now) {
        Long startTime = this.messages.getJobStartTime();
        if (startTime == null) {
            return 0.0;
        }
        if (now.equals(startTime)) {
            return 0.0;
        }
        return this.getProgressFrom() / (double)(now - startTime);
    }

    private double getProgressTimeConstant(long now, Integer timeUntilUpdateRequest) {
        if (this.messages != null) {
            double progressFrom = this.getProgressFrom();
            double progressInterval = this.getProgressInterval(now, timeUntilUpdateRequest);
            Long progressFromTime = this.getProgressFromTime();
            Long jobStartTime = this.messages.getJobStartTime();
            if (progressFrom > 0.0 && jobStartTime != null && progressFromTime != null && progressFromTime - jobStartTime > 0L && progressInterval > 0.0) {
                return (double)(-(progressFromTime - jobStartTime)) * progressInterval / progressFrom / Math.log(0.05);
            }
        }
        return 20000.0;
    }

    private static double toPercentage(BigDecimal progress) {
        return progress.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).doubleValue();
    }

    public String toString() {
        return XML.toString(this.toXml());
    }

    static {
        ns.put("d", "http://www.daisy.org/ns/pipeline/data");
    }

    public static enum Priority {
        high,
        medium,
        low;

    }

    public static enum Status {
        IDLE,
        RUNNING,
        SUCCESS,
        ERROR,
        FAIL;

    }
}

