/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.util.ArrayList;
import java.util.List;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Client {
    private String id;
    private String href;
    private String secret;
    private Role role;
    private String contactInfo;
    private Node clientNode;
    private boolean lazyLoaded = false;

    public Client(Node clientNode) {
        this.clientNode = clientNode;
    }

    public void lazyLoad() {
        if (!this.lazyLoaded) {
            try {
                this.id = XPath.selectText("@id", this.clientNode, XPath.dp2ns);
                if (this.id == null) {
                    this.id = "";
                }
                this.href = XPath.selectText("@href", this.clientNode, XPath.dp2ns);
                if (this.href == null) {
                    this.href = "";
                }
                this.secret = XPath.selectText("@secret", this.clientNode, XPath.dp2ns);
                if (this.secret == null) {
                    this.secret = "";
                }
                try {
                    this.role = Role.valueOf(XPath.selectText("@role", this.clientNode, XPath.dp2ns));
                }
                catch (IllegalArgumentException e) {
                    this.role = null;
                }
                catch (NullPointerException e) {
                    this.role = null;
                }
                this.contactInfo = XPath.selectText("@contact", this.clientNode, XPath.dp2ns);
                if (this.contactInfo == null) {
                    this.contactInfo = "";
                }
            }
            catch (Pipeline2Exception e) {
                Pipeline2Logger.logger().error("Failed to parse argument node", e);
            }
            this.lazyLoaded = true;
        }
    }

    public static List<Client> parseClientsXml(Node clientsNode) {
        try {
            if (clientsNode instanceof Document) {
                clientsNode = XPath.selectNode("/d:clients", clientsNode, XPath.dp2ns);
            }
            List<Node> clientNodes = XPath.selectNodes("d:client", clientsNode, XPath.dp2ns);
            ArrayList<Client> clients = new ArrayList<Client>();
            for (Node clientNode : clientNodes) {
                clients.add(new Client(clientNode));
            }
            return clients;
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Failed to parse clients XML", e);
            return null;
        }
    }

    public String getId() {
        this.lazyLoad();
        return this.id;
    }

    public String getHref() {
        this.lazyLoad();
        return this.href;
    }

    public String getSecret() {
        this.lazyLoad();
        return this.secret;
    }

    public Role getRole() {
        this.lazyLoad();
        return this.role;
    }

    public String getContactInfo() {
        this.lazyLoad();
        return this.contactInfo;
    }

    public void setId(String id) {
        this.lazyLoad();
        this.id = id;
    }

    public void setHref(String href) {
        this.lazyLoad();
        this.href = href;
    }

    public void setSecret(String secret) {
        this.lazyLoad();
        this.secret = secret;
    }

    public void setRole(Role role) {
        this.lazyLoad();
        this.role = role;
    }

    public void setContactInfo(String contactInfo) {
        this.lazyLoad();
        this.contactInfo = contactInfo;
    }

    public static enum Role {
        ADMIN,
        CLIENTAPP;

    }
}

