/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.drive;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.DriveScopes;
import com.google.api.services.drive.model.File;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Set;
import javax.inject.Singleton;
import org.ctoolkit.restapi.client.AccessToken;
import org.ctoolkit.restapi.client.ApiToken;
import org.ctoolkit.restapi.client.ServiceUnavailableException;
import org.ctoolkit.restapi.client.UnauthorizedException;
import org.ctoolkit.restapi.client.adaptee.DeleteExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.InsertExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.UnderlyingClientAdaptee;
import org.ctoolkit.restapi.client.drive.adaptee.FileAdaptee;
import org.ctoolkit.restapi.client.googleapis.GoogleApiProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleApiDriveModule
extends AbstractModule {
    public static final String API_PREFIX = "drive";
    private static final Logger logger = LoggerFactory.getLogger(GoogleApiDriveModule.class);
    private ApiToken<? extends HttpRequestInitializer> initialized;

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<InsertExecutorAdaptee<File>>(){}).to(FileAdaptee.class).in(Singleton.class);
        this.bind((TypeLiteral)new TypeLiteral<DeleteExecutorAdaptee<File>>(){}).to(FileAdaptee.class).in(Singleton.class);
        this.bind((TypeLiteral)new TypeLiteral<UnderlyingClientAdaptee<Drive>>(){}).to(FileAdaptee.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    Drive provideDrive(GoogleApiProxyFactory factory) {
        Drive.Builder builder;
        Set scopes = DriveScopes.all();
        try {
            this.initialized = factory.authorize((Collection)scopes, null, API_PREFIX);
            HttpRequestInitializer credential = (HttpRequestInitializer)this.initialized.getCredential();
            builder = new Drive.Builder(factory.getHttpTransport(), factory.getJsonFactory(), credential);
            builder.setApplicationName(factory.getApplicationName(API_PREFIX));
        }
        catch (GeneralSecurityException e) {
            logger.error("Failed. Scopes: " + scopes.toString() + " Application name: " + factory.getApplicationName(API_PREFIX) + " Service account: " + factory.getServiceAccountEmail(API_PREFIX), (Throwable)e);
            throw new UnauthorizedException(e.getMessage());
        }
        catch (IOException e) {
            logger.error("Failed. Scopes: " + scopes.toString() + " Application name: " + factory.getApplicationName(API_PREFIX) + " Service account: " + factory.getServiceAccountEmail(API_PREFIX), (Throwable)e);
            throw new ServiceUnavailableException(e.getMessage());
        }
        return builder.build();
    }

    @Provides
    @AccessToken(apiName="drive")
    ApiToken.Data provideDriveTokenData(Drive client) {
        this.initialized.setServiceUrl(client.getBaseUrl());
        return this.initialized.getTokenData();
    }
}

