/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.conscrypt.AbstractOpenSSLSession;
import org.conscrypt.AbstractSessionContext;
import org.conscrypt.HandshakeListener;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLECGroupContext;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSessionImpl;
import org.conscrypt.OpenSSLX509Certificate;
import org.conscrypt.PSKKeyManager;
import org.conscrypt.PeerInfoProvider;
import org.conscrypt.Platform;
import org.conscrypt.Preconditions;
import org.conscrypt.SSLNullSession;
import org.conscrypt.SSLParametersImpl;
import org.conscrypt.SSLUtils;

final class ConscryptEngine
extends SSLEngine
implements NativeCrypto.SSLHandshakeCallbacks,
SSLParametersImpl.AliasChooser,
SSLParametersImpl.PSKCallbacks {
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private static final ByteBuffer EMPTY = ByteBuffer.allocateDirect(0);
    private String peerHostname;
    private final SSLParametersImpl sslParameters;
    private final Object stateLock = new Object();
    private int engineState = 0;
    private boolean handshakeFinished;
    private long sslNativePointer;
    private long networkBio;
    private AbstractOpenSSLSession sslSession;
    private AbstractOpenSSLSession handshakeSession;
    private OpenSSLKey channelIdPrivateKey;
    private int maxSealOverhead;
    private HandshakeListener handshakeListener;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final PeerInfoProvider peerInfoProvider;
    private SSLException handshakeException;

    ConscryptEngine(SSLParametersImpl sslParameters) {
        this.sslParameters = sslParameters;
        this.peerInfoProvider = PeerInfoProvider.nullProvider();
    }

    ConscryptEngine(String host, int port, SSLParametersImpl sslParameters) {
        this.sslParameters = sslParameters;
        this.peerInfoProvider = PeerInfoProvider.forHostAndPort(host, port);
    }

    ConscryptEngine(SSLParametersImpl sslParameters, PeerInfoProvider peerInfoProvider) {
        this.sslParameters = sslParameters;
        this.peerInfoProvider = Preconditions.checkNotNull(peerInfoProvider, "peerInfoProvider");
    }

    int maxSealOverhead() {
        return this.maxSealOverhead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChannelIdEnabled(boolean enabled) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.getUseClientMode()) {
                throw new IllegalStateException("Not allowed in client mode");
            }
            if (this.isHandshakeStarted()) {
                throw new IllegalStateException("Could not enable/disable Channel ID after the initial handshake has begun.");
            }
            this.sslParameters.channelIdEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getChannelId() throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.getUseClientMode()) {
                throw new IllegalStateException("Not allowed in client mode");
            }
            if (this.isHandshakeStarted()) {
                throw new IllegalStateException("Channel ID is only available after handshake completes");
            }
            return NativeCrypto.SSL_get_tls_channel_id(this.sslNativePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChannelIdPrivateKey(PrivateKey privateKey) {
        if (!this.getUseClientMode()) {
            throw new IllegalStateException("Not allowed in server mode");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isHandshakeStarted()) {
                throw new IllegalStateException("Could not change Channel ID private key after the initial handshake has begun.");
            }
            if (privateKey == null) {
                this.sslParameters.channelIdEnabled = false;
                this.channelIdPrivateKey = null;
                return;
            }
            this.sslParameters.channelIdEnabled = true;
            try {
                ECParameterSpec ecParams = null;
                if (privateKey instanceof ECKey) {
                    ecParams = ((ECKey)((Object)privateKey)).getParams();
                }
                if (ecParams == null) {
                    ecParams = OpenSSLECGroupContext.getCurveByName("prime256v1").getECParameterSpec();
                }
                this.channelIdPrivateKey = OpenSSLKey.fromECPrivateKeyForTLSStackOnly(privateKey, ecParams);
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHandshakeListener(HandshakeListener handshakeListener) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isHandshakeStarted()) {
                throw new IllegalStateException("Handshake listener must be set before starting the handshake.");
            }
            this.handshakeListener = handshakeListener;
        }
    }

    private boolean isHandshakeStarted() {
        switch (this.engineState) {
            case 0: 
            case 1: {
                return false;
            }
        }
        return true;
    }

    void setHostname(String hostname) {
        this.sslParameters.setUseSni(hostname != null);
        this.peerHostname = hostname;
    }

    String getHostname() {
        return this.peerHostname != null ? this.peerHostname : this.peerInfoProvider.getHostname();
    }

    @Override
    public String getPeerHost() {
        return this.peerHostname != null ? this.peerHostname : this.peerInfoProvider.getHostnameOrIP();
    }

    @Override
    public int getPeerPort() {
        return this.peerInfoProvider.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginHandshake() throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.beginHandshakeInternal();
        }
    }

    private void beginHandshakeInternal() throws SSLException {
        switch (this.engineState) {
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("Handshake has already been started");
            }
            case 6: 
            case 7: 
            case 8: {
                throw new IllegalStateException("Engine has already been closed");
            }
            default: {
                throw new IllegalStateException("Client/server mode must be set before handshake");
            }
        }
        this.engineState = 2;
        boolean releaseResources = true;
        try {
            AbstractSessionContext sessionContext = this.sslParameters.getSessionContext();
            this.sslNativePointer = NativeCrypto.SSL_new(sessionContext.sslCtxNativePointer);
            this.networkBio = NativeCrypto.SSL_BIO_new(this.sslNativePointer);
            NativeCrypto.SSL_accept_renegotiations(this.sslNativePointer);
            if (this.getUseClientMode()) {
                NativeCrypto.SSL_set_connect_state(this.sslNativePointer);
                NativeCrypto.SSL_enable_ocsp_stapling(this.sslNativePointer);
                if (this.sslParameters.isCTVerificationEnabled(this.getHostname())) {
                    NativeCrypto.SSL_enable_signed_cert_timestamps(this.sslNativePointer);
                }
            } else {
                NativeCrypto.SSL_set_accept_state(this.sslNativePointer);
                if (this.sslParameters.getOCSPResponse() != null) {
                    NativeCrypto.SSL_enable_ocsp_stapling(this.sslNativePointer);
                }
            }
            this.sslSession = this.sslParameters.getSessionToReuse(this.sslNativePointer, this.getPeerHost(), this.getPeerPort());
            this.sslParameters.setSSLParameters(this.sslNativePointer, this, this, this.getHostname());
            this.sslParameters.setCertificateValidation(this.sslNativePointer);
            this.sslParameters.setTlsChannelId(this.sslNativePointer, this.channelIdPrivateKey);
            this.maxSealOverhead = NativeCrypto.SSL_max_seal_overhead(this.sslNativePointer);
            this.handshake();
            releaseResources = false;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message.contains("unexpected CCS")) {
                String logMessage = String.format("ssl_unexpected_ccs: host=%s", this.getPeerHost());
                Platform.logEvent(logMessage);
            }
            throw SSLUtils.toSSLHandshakeException(e);
        }
        finally {
            if (releaseResources) {
                this.engineState = 8;
                this.shutdownAndFreeSslNative();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInbound() throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState == 8) {
                return;
            }
            this.engineState = this.engineState == 7 ? 8 : 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOutbound() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState == 8 || this.engineState == 7) {
                return;
            }
            if (this.isHandshakeStarted()) {
                this.shutdownAndFreeSslNative();
            }
            this.engineState = this.engineState == 6 ? 8 : 7;
        }
        this.shutdown();
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslParameters.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    @Override
    public SSLParameters getSSLParameters() {
        SSLParameters params = super.getSSLParameters();
        Platform.getSSLParameters(params, this.sslParameters, this);
        return params;
    }

    @Override
    public void setSSLParameters(SSLParameters p) {
        super.setSSLParameters(p);
        Platform.setSSLParameters(p, this.sslParameters, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.getHandshakeStatusInternal();
        }
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatusInternal() {
        if (this.handshakeFinished) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        switch (this.engineState) {
            case 2: {
                return ConscryptEngine.pendingStatus(this.pendingOutboundEncryptedBytes());
            }
            case 3: {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        throw new IllegalStateException("Unexpected engine state: " + this.engineState);
    }

    private int pendingOutboundEncryptedBytes() {
        return NativeCrypto.SSL_pending_written_bytes_in_BIO(this.networkBio);
    }

    private int pendingInboundCleartextBytes() {
        return NativeCrypto.SSL_pending_readable_bytes(this.sslNativePointer);
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int pendingOutboundBytes) {
        return pendingOutboundBytes > 0 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public SSLSession getSession() {
        if (this.sslSession == null) {
            return this.handshakeSession != null ? Platform.wrapSSLSession(this.handshakeSession) : SSLNullSession.getNullSession();
        }
        return Platform.wrapSSLSession(this.sslSession);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInboundDone() {
        if (this.sslNativePointer == 0L) {
            Object object = this.stateLock;
            synchronized (object) {
                return this.engineState == 8 || this.engineState == 6;
            }
        }
        return (NativeCrypto.SSL_get_shutdown(this.sslNativePointer) & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOutboundDone() {
        if (this.sslNativePointer == 0L) {
            Object object = this.stateLock;
            synchronized (object) {
                return this.engineState == 8 || this.engineState == 7;
            }
        }
        return (NativeCrypto.SSL_get_shutdown(this.sslNativePointer) & 1) != 0;
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setEnabledCipherSuites(suites);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setEnabledProtocols(protocols);
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseClientMode(boolean mode) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isHandshakeStarted()) {
                throw new IllegalArgumentException("Can not change mode after handshake: engineState == " + this.engineState);
            }
            this.engineState = 1;
        }
        this.sslParameters.setUseClientMode(mode);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.unwrap(this.singleSrcBuffer(src), this.singleDstBuffer(dst));
                this.resetSingleSrcBuffer();
                this.resetSingleDstBuffer();
            }
            catch (Throwable throwable) {
                this.resetSingleSrcBuffer();
                this.resetSingleDstBuffer();
                throw throwable;
            }
            return sSLEngineResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.unwrap(this.singleSrcBuffer(src), dsts);
                this.resetSingleSrcBuffer();
            }
            catch (Throwable throwable) {
                this.resetSingleSrcBuffer();
                throw throwable;
            }
            return sSLEngineResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.unwrap(this.singleSrcBuffer(src), 0, 1, dsts, offset, length);
                this.resetSingleSrcBuffer();
            }
            catch (Throwable throwable) {
                this.resetSingleSrcBuffer();
                throw throwable;
            }
            return sSLEngineResult;
        }
    }

    SSLEngineResult unwrap(ByteBuffer[] srcs, ByteBuffer[] dsts) throws SSLException {
        Preconditions.checkArgument(srcs != null, "srcs is null");
        Preconditions.checkArgument(dsts != null, "dsts is null");
        return this.unwrap(srcs, 0, srcs.length, dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLEngineResult unwrap(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
        Preconditions.checkArgument(srcs != null, "srcs is null");
        Preconditions.checkArgument(dsts != null, "dsts is null");
        ConscryptEngine.checkIndex(srcs.length, srcsOffset, srcsLength, "srcs");
        ConscryptEngine.checkIndex(dsts.length, dstsOffset, dstsLength, "dsts");
        int dstLength = ConscryptEngine.calcDstsLength(dsts, dstsOffset, dstsLength);
        int endOffset = dstsOffset + dstsLength;
        int srcsEndOffset = srcsOffset + srcsLength;
        long srcLength = ConscryptEngine.calcSrcsLength(srcs, srcsOffset, srcsEndOffset);
        Object object = this.stateLock;
        synchronized (object) {
            int pendingCleartextBytes;
            int bytesProduced;
            int bytesConsumed;
            SSLEngineResult.HandshakeStatus handshakeStatus;
            block35: {
                switch (this.engineState) {
                    case 1: {
                        this.beginHandshakeInternal();
                        break;
                    }
                    case 6: 
                    case 8: {
                        return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatusInternal(), 0, 0);
                    }
                    case 0: {
                        throw new IllegalStateException("Client/server mode must be set before calling unwrap");
                    }
                }
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                if (!this.handshakeFinished) {
                    handshakeStatus = this.handshake();
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        return NEED_WRAP_OK;
                    }
                    if (this.engineState == 8) {
                        return NEED_WRAP_CLOSED;
                    }
                }
                boolean noCleartextDataAvailable = this.pendingInboundCleartextBytes() <= 0;
                int lenRemaining = 0;
                if (srcLength > 0L && noCleartextDataAvailable) {
                    if (srcLength < 5L) {
                        return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), 0, 0);
                    }
                    int packetLength = SSLUtils.getEncryptedPacketLength(srcs, srcsOffset);
                    if (packetLength < 0) {
                        throw new SSLException("Unable to parse TLS packet header");
                    }
                    if (srcLength < (long)packetLength) {
                        return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), 0, 0);
                    }
                    lenRemaining = packetLength;
                } else if (noCleartextDataAvailable) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), 0, 0);
                }
                bytesConsumed = 0;
                if (lenRemaining > 0 && srcsOffset < srcsEndOffset) {
                    do {
                        ByteBuffer src;
                        int remaining;
                        if ((remaining = (src = srcs[srcsOffset]).remaining()) == 0) {
                            ++srcsOffset;
                            continue;
                        }
                        int written = this.writeEncryptedData(src, Math.min(lenRemaining, remaining));
                        if (written > 0) {
                            bytesConsumed += written;
                            if ((lenRemaining -= written) == 0 || written != remaining) break;
                            ++srcsOffset;
                            continue;
                        }
                        NativeCrypto.SSL_clear_error();
                        break;
                    } while (srcsOffset < srcsEndOffset);
                }
                bytesProduced = 0;
                try {
                    if (dstLength > 0) {
                        for (int idx = dstsOffset; idx < endOffset; ++idx) {
                            ByteBuffer dst = dsts[idx];
                            if (!dst.hasRemaining()) continue;
                            int bytesRead = this.readPlaintextData(dst);
                            if (bytesRead > 0) {
                                bytesProduced += bytesRead;
                                if (!dst.hasRemaining()) continue;
                                break block35;
                            }
                            switch (bytesRead) {
                                case -3: 
                                case -2: {
                                    return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
                                }
                            }
                            throw this.shutdownWithError("SSL_read");
                        }
                        break block35;
                    }
                    this.readPlaintextData(EMPTY);
                }
                catch (SSLException e) {
                    if (this.pendingOutboundEncryptedBytes() > 0) {
                        if (!this.handshakeFinished && this.handshakeException == null) {
                            this.handshakeException = e;
                        }
                        return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, bytesConsumed, bytesProduced);
                    }
                    this.shutdown();
                    throw this.convertException(e);
                }
                catch (InterruptedIOException e) {
                    return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
                }
                catch (EOFException e) {
                    this.closeAll();
                    throw this.convertException(e);
                }
                catch (IOException e) {
                    this.shutdown();
                    throw this.convertException(e);
                }
            }
            int n = pendingCleartextBytes = this.handshakeFinished ? this.pendingInboundCleartextBytes() : 0;
            if (pendingCleartextBytes > 0) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.mayFinishHandshake(handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED ? handshakeStatus : this.getHandshakeStatusInternal()), bytesConsumed, bytesProduced);
            }
            return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
        }
    }

    private static int calcDstsLength(ByteBuffer[] dsts, int dstsOffset, int dstsLength) {
        int capacity = 0;
        for (int i = 0; i < dsts.length; ++i) {
            ByteBuffer dst = dsts[i];
            Preconditions.checkArgument(dst != null, "dsts[%d] is null", i);
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            if (i < dstsOffset || i >= dstsOffset + dstsLength) continue;
            capacity += dst.remaining();
        }
        return capacity;
    }

    private static long calcSrcsLength(ByteBuffer[] srcs, int srcsOffset, int srcsEndOffset) {
        long len = 0L;
        for (int i = srcsOffset; i < srcsEndOffset; ++i) {
            ByteBuffer src = srcs[i];
            if (src == null) {
                throw new IllegalArgumentException("srcs[" + i + "] is null");
            }
            len += (long)src.remaining();
        }
        return len;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLEngineResult.HandshakeStatus handshake() throws SSLException {
        long sslSessionCtx = 0L;
        try {
            if (this.handshakeException != null) {
                if (this.pendingOutboundEncryptedBytes() > 0) {
                    SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                    return handshakeStatus;
                }
                SSLException e = this.handshakeException;
                this.handshakeException = null;
                throw e;
            }
            int ssl_error_code = NativeCrypto.ENGINE_SSL_do_handshake(this.sslNativePointer, this);
            switch (ssl_error_code) {
                case 2: {
                    SSLEngineResult.HandshakeStatus handshakeStatus = ConscryptEngine.pendingStatus(this.pendingOutboundEncryptedBytes());
                    return handshakeStatus;
                }
                case 3: {
                    SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                    return handshakeStatus;
                }
            }
            sslSessionCtx = NativeCrypto.SSL_get1_session(this.sslNativePointer);
        }
        catch (SSLException e) {
            if (this.pendingOutboundEncryptedBytes() > 0) {
                this.handshakeException = e;
                SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                return handshakeStatus;
            }
            this.shutdown();
            throw e;
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        catch (Exception e2) {
            throw SSLUtils.toSSLHandshakeException(e2);
        }
        if (sslSessionCtx == 0L) {
            throw this.shutdownWithError("Failed to obtain session after handshake completed");
        }
        this.sslSession = this.sslParameters.setupSession(sslSessionCtx, this.sslNativePointer, this.sslSession, this.getPeerHost(), this.getPeerPort(), true);
        this.engineState = this.sslSession != null && this.engineState == 2 ? 4 : 5;
        this.finishHandshake();
        return SSLEngineResult.HandshakeStatus.FINISHED;
        finally {
            if (this.sslSession == null && sslSessionCtx != 0L) {
                NativeCrypto.SSL_SESSION_free(sslSessionCtx);
            }
        }
    }

    private void finishHandshake() throws SSLException {
        this.handshakeFinished = true;
        if (this.handshakeListener != null) {
            this.handshakeListener.onHandshakeFinished();
        }
    }

    private int writePlaintextData(ByteBuffer src, int len) throws SSLException {
        try {
            int sslWrote;
            int pos = src.position();
            if (src.isDirect()) {
                long addr = NativeCrypto.getDirectBufferAddress(src) + (long)pos;
                sslWrote = NativeCrypto.ENGINE_SSL_write_direct(this.sslNativePointer, addr, len, this);
            } else {
                ByteBuffer heapSrc = this.toHeapBuffer(src, len);
                sslWrote = NativeCrypto.ENGINE_SSL_write_heap(this.sslNativePointer, heapSrc.array(), heapSrc.arrayOffset() + heapSrc.position(), len, this);
            }
            if (sslWrote > 0) {
                src.position(pos + sslWrote);
            }
            return sslWrote;
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    private int readPlaintextData(ByteBuffer dst) throws IOException {
        try {
            int sslRead;
            int pos = dst.position();
            int limit = dst.limit();
            int len = Math.min(16709, limit - pos);
            if (dst.isDirect()) {
                long addr = NativeCrypto.getDirectBufferAddress(dst) + (long)pos;
                sslRead = NativeCrypto.ENGINE_SSL_read_direct(this.sslNativePointer, addr, len, this);
                if (sslRead > 0) {
                    dst.position(pos + sslRead);
                }
            } else if (dst.hasArray()) {
                sslRead = NativeCrypto.ENGINE_SSL_read_heap(this.sslNativePointer, dst.array(), dst.arrayOffset() + pos, len, this);
                if (sslRead > 0) {
                    dst.position(pos + sslRead);
                }
            } else {
                byte[] data = new byte[len];
                sslRead = NativeCrypto.ENGINE_SSL_read_heap(this.sslNativePointer, data, 0, len, this);
                if (sslRead > 0) {
                    dst.put(data, 0, sslRead);
                }
            }
            return sslRead;
        }
        catch (CertificateException e) {
            throw this.convertException(e);
        }
    }

    private SSLException convertException(Throwable e) {
        if (e instanceof SSLHandshakeException || !this.handshakeFinished) {
            return SSLUtils.toSSLHandshakeException(e);
        }
        return SSLUtils.toSSLException(e);
    }

    private int writeEncryptedData(ByteBuffer src, int len) throws SSLException {
        try {
            int netWrote;
            int pos = src.position();
            if (src.isDirect()) {
                long addr = NativeCrypto.getDirectBufferAddress(src) + (long)pos;
                netWrote = NativeCrypto.ENGINE_SSL_write_BIO_direct(this.sslNativePointer, this.networkBio, addr, len, this);
            } else {
                ByteBuffer heapSrc = this.toHeapBuffer(src, len);
                netWrote = NativeCrypto.ENGINE_SSL_write_BIO_heap(this.sslNativePointer, this.networkBio, heapSrc.array(), heapSrc.arrayOffset() + heapSrc.position(), len, this);
            }
            if (netWrote >= 0) {
                src.position(pos + netWrote);
            }
            return netWrote;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    private SSLEngineResult readPendingBytesFromBIO(ByteBuffer dst, int bytesConsumed, int bytesProduced, SSLEngineResult.HandshakeStatus status) throws SSLException {
        try {
            int pendingNet = this.pendingOutboundEncryptedBytes();
            if (pendingNet > 0) {
                int capacity = dst.remaining();
                if (capacity < pendingNet) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.mayFinishHandshake(status == SSLEngineResult.HandshakeStatus.FINISHED ? status : this.getHandshakeStatus(pendingNet)), bytesConsumed, bytesProduced);
                }
                int produced = this.readEncryptedData(dst, pendingNet);
                if (produced <= 0) {
                    NativeCrypto.SSL_clear_error();
                } else {
                    bytesProduced += produced;
                    pendingNet -= produced;
                }
                return new SSLEngineResult(this.getEngineStatus(), this.mayFinishHandshake(status == SSLEngineResult.HandshakeStatus.FINISHED ? status : this.getHandshakeStatus(pendingNet)), bytesConsumed, bytesProduced);
            }
            return null;
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    private int readEncryptedData(ByteBuffer dst, int pending) throws SSLException {
        try {
            int bioRead = 0;
            if (dst.remaining() >= pending) {
                int pos = dst.position();
                int limit = dst.limit();
                int len = Math.min(pending, limit - pos);
                if (dst.isDirect()) {
                    long addr = NativeCrypto.getDirectBufferAddress(dst) + (long)pos;
                    bioRead = NativeCrypto.ENGINE_SSL_read_BIO_direct(this.sslNativePointer, this.networkBio, addr, len, this);
                    if (bioRead > 0) {
                        dst.position(pos + bioRead);
                        return bioRead;
                    }
                } else if (dst.hasArray()) {
                    bioRead = NativeCrypto.ENGINE_SSL_read_BIO_heap(this.sslNativePointer, this.networkBio, dst.array(), dst.arrayOffset() + pos, pending, this);
                    if (bioRead > 0) {
                        dst.position(pos + bioRead);
                        return bioRead;
                    }
                } else {
                    byte[] data = new byte[len];
                    bioRead = NativeCrypto.ENGINE_SSL_read_BIO_heap(this.sslNativePointer, this.networkBio, data, 0, pending, this);
                    if (bioRead > 0) {
                        dst.put(data, 0, bioRead);
                        return bioRead;
                    }
                }
            }
            return bioRead;
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus status) throws SSLException {
        if (!this.handshakeFinished && status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return this.handshake();
        }
        return status;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int pending) {
        return !this.handshakeFinished ? ConscryptEngine.pendingStatus(pending) : SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.Status getEngineStatus() {
        switch (this.engineState) {
            case 6: 
            case 7: 
            case 8: {
                return SSLEngineResult.Status.CLOSED;
            }
        }
        return SSLEngineResult.Status.OK;
    }

    private void closeAll() throws SSLException {
        this.closeOutbound();
        this.closeInbound();
    }

    private SSLEngineResult sslReadErrorResult(int err, int bytesConsumed, int bytesProduced) throws SSLException {
        if (!this.handshakeFinished && this.pendingOutboundEncryptedBytes() > 0) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, bytesConsumed, bytesProduced);
        }
        throw this.shutdownWithError(NativeCrypto.SSL_get_error_string(err));
    }

    private SSLException shutdownWithError(String err) {
        this.shutdown();
        if (!this.handshakeFinished) {
            return new SSLException(err);
        }
        return new SSLHandshakeException(err);
    }

    private SSLEngineResult newResult(int bytesConsumed, int bytesProduced, SSLEngineResult.HandshakeStatus status) throws SSLException {
        return new SSLEngineResult(this.getEngineStatus(), this.mayFinishHandshake(status == SSLEngineResult.HandshakeStatus.FINISHED ? status : this.getHandshakeStatusInternal()), bytesConsumed, bytesProduced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.wrap(this.singleSrcBuffer(src), dst);
                this.resetSingleSrcBuffer();
            }
            catch (Throwable throwable) {
                this.resetSingleSrcBuffer();
                throw throwable;
            }
            return sSLEngineResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        Preconditions.checkArgument(srcs != null, "srcs is null");
        Preconditions.checkArgument(dst != null, "dst is null");
        ConscryptEngine.checkIndex(srcs.length, offset, length, "srcs");
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult pendingNetResult;
            switch (this.engineState) {
                case 1: {
                    this.beginHandshakeInternal();
                    break;
                }
                case 7: 
                case 8: {
                    return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatusInternal(), 0, 0);
                }
                case 0: {
                    throw new IllegalStateException("Client/server mode must be set before calling wrap");
                }
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            if (!this.handshakeFinished) {
                handshakeStatus = this.handshake();
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    return NEED_UNWRAP_OK;
                }
                if (this.engineState == 8) {
                    return NEED_UNWRAP_CLOSED;
                }
            }
            int srcsLen = 0;
            int endOffset = offset + length;
            for (int i = offset; i < endOffset; ++i) {
                ByteBuffer src = srcs[i];
                if (src == null) {
                    throw new IllegalArgumentException("srcs[" + i + "] is null");
                }
                if (srcsLen == 16384 || (srcsLen += src.remaining()) <= 16384 && srcsLen >= 0) continue;
                srcsLen = 16384;
            }
            if (dst.remaining() < SSLUtils.calculateOutNetBufSize(srcsLen)) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatusInternal(), 0, 0);
            }
            int bytesProduced = 0;
            int bytesConsumed = 0;
            block14: for (int i = offset; i < endOffset; ++i) {
                ByteBuffer src = srcs[i];
                Preconditions.checkArgument(src != null, "srcs[%d] is null", i);
                while (src.hasRemaining()) {
                    SSLEngineResult pendingNetResult2;
                    int result = this.writePlaintextData(src, Math.min(src.remaining(), 16384 - bytesConsumed));
                    if (result > 0) {
                        pendingNetResult2 = this.readPendingBytesFromBIO(dst, bytesConsumed += result, bytesProduced, handshakeStatus);
                        if (pendingNetResult2 != null) {
                            if (pendingNetResult2.getStatus() != SSLEngineResult.Status.OK) {
                                return pendingNetResult2;
                            }
                            bytesProduced = pendingNetResult2.bytesProduced();
                        }
                        if (bytesConsumed != 16384) continue;
                        break block14;
                    }
                    int sslError = NativeCrypto.SSL_get_error(this.sslNativePointer, result);
                    switch (sslError) {
                        case 6: {
                            this.closeAll();
                            pendingNetResult2 = this.readPendingBytesFromBIO(dst, bytesConsumed, bytesProduced, handshakeStatus);
                            return pendingNetResult2 != null ? pendingNetResult2 : CLOSED_NOT_HANDSHAKING;
                        }
                        case 2: {
                            pendingNetResult2 = this.readPendingBytesFromBIO(dst, bytesConsumed, bytesProduced, handshakeStatus);
                            return pendingNetResult2 != null ? pendingNetResult2 : new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, bytesConsumed, bytesProduced);
                        }
                        case 3: {
                            pendingNetResult2 = this.readPendingBytesFromBIO(dst, bytesConsumed, bytesProduced, handshakeStatus);
                            return pendingNetResult2 != null ? pendingNetResult2 : NEED_WRAP_CLOSED;
                        }
                    }
                    throw this.shutdownWithError("SSL_write");
                }
            }
            if (bytesConsumed == 0 && (pendingNetResult = this.readPendingBytesFromBIO(dst, 0, bytesProduced, handshakeStatus)) != null) {
                return pendingNetResult;
            }
            return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
        }
    }

    @Override
    public int clientPSKKeyRequested(String identityHint, byte[] identity, byte[] key) {
        return this.sslParameters.clientPSKKeyRequested(identityHint, identity, key, this);
    }

    @Override
    public int serverPSKKeyRequested(String identityHint, String identity, byte[] key) {
        return this.sslParameters.serverPSKKeyRequested(identityHint, identity, key, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSSLStateChange(int type, int val) {
        Object object = this.stateLock;
        synchronized (object) {
            switch (type) {
                case 16: {
                    this.engineState = 2;
                    break;
                }
                case 32: {
                    if (this.engineState != 2 && this.engineState != 4) {
                        throw new IllegalStateException("Completed handshake while in mode " + this.engineState);
                    }
                    this.engineState = 3;
                }
            }
        }
    }

    @Override
    public void verifyCertificateChain(long[] certRefs, String authMethod) throws CertificateException {
        try {
            X509TrustManager x509tm = this.sslParameters.getX509TrustManager();
            if (x509tm == null) {
                throw new CertificateException("No X.509 TrustManager");
            }
            if (certRefs == null || certRefs.length == 0) {
                throw new SSLException("Peer sent no certificate");
            }
            X509Certificate[] peerCertChain = OpenSSLX509Certificate.createCertChain(certRefs);
            byte[] ocspData = NativeCrypto.SSL_get_ocsp_response(this.sslNativePointer);
            byte[] tlsSctData = NativeCrypto.SSL_get_signed_cert_timestamp_list(this.sslNativePointer);
            this.handshakeSession = new OpenSSLSessionImpl(NativeCrypto.SSL_get1_session(this.sslNativePointer), null, peerCertChain, ocspData, tlsSctData, this.getPeerHost(), this.getPeerPort(), null);
            if (this.getUseClientMode()) {
                Platform.checkServerTrusted(x509tm, peerCertChain, authMethod, this);
            } else {
                String authType = ((OpenSSLX509Certificate)peerCertChain[0]).getPublicKey().getAlgorithm();
                Platform.checkClientTrusted(x509tm, peerCertChain, authType, this);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        finally {
            this.handshakeSession = null;
        }
    }

    @Override
    public void clientCertificateRequested(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws CertificateEncodingException, SSLException {
        this.sslParameters.chooseClientCertificate(keyTypeBytes, asn1DerEncodedPrincipals, this.sslNativePointer, this);
    }

    private void shutdown() {
        try {
            NativeCrypto.ENGINE_SSL_shutdown(this.sslNativePointer, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void shutdownAndFreeSslNative() {
        try {
            this.shutdown();
        }
        finally {
            this.free();
        }
    }

    private void free() {
        if (this.sslNativePointer == 0L) {
            return;
        }
        NativeCrypto.SSL_free(this.sslNativePointer);
        NativeCrypto.BIO_free_all(this.networkBio);
        this.sslNativePointer = 0L;
        this.networkBio = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    SSLSession handshakeSession() {
        if (this.handshakeSession != null) {
            return Platform.wrapSSLSession(this.handshakeSession);
        }
        return null;
    }

    @Override
    public String chooseServerAlias(X509KeyManager keyManager, String keyType) {
        if (keyManager instanceof X509ExtendedKeyManager) {
            X509ExtendedKeyManager ekm = (X509ExtendedKeyManager)keyManager;
            return ekm.chooseEngineServerAlias(keyType, null, this);
        }
        return keyManager.chooseServerAlias(keyType, null, null);
    }

    @Override
    public String chooseClientAlias(X509KeyManager keyManager, X500Principal[] issuers, String[] keyTypes) {
        if (keyManager instanceof X509ExtendedKeyManager) {
            X509ExtendedKeyManager ekm = (X509ExtendedKeyManager)keyManager;
            return ekm.chooseEngineClientAlias(keyTypes, issuers, this);
        }
        return keyManager.chooseClientAlias(keyTypes, issuers, null);
    }

    @Override
    public String chooseServerPSKIdentityHint(PSKKeyManager keyManager) {
        return keyManager.chooseServerKeyIdentityHint(this);
    }

    @Override
    public String chooseClientPSKIdentity(PSKKeyManager keyManager, String identityHint) {
        return keyManager.chooseClientKeyIdentity(identityHint, this);
    }

    @Override
    public SecretKey getPSKKey(PSKKeyManager keyManager, String identityHint, String identity) {
        return keyManager.getKey(identityHint, identity, this);
    }

    void setUseSessionTickets(boolean useSessionTickets) {
        this.sslParameters.setUseSessionTickets(useSessionTickets);
    }

    void setAlpnProtocols(String[] alpnProtocols) {
        this.sslParameters.setAlpnProtocols(alpnProtocols);
    }

    void setAlpnProtocols(byte[] alpnProtocols) {
        this.sslParameters.setAlpnProtocols(alpnProtocols);
    }

    byte[] getAlpnSelectedProtocol() {
        return NativeCrypto.SSL_get0_alpn_selected(this.sslNativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer toHeapBuffer(ByteBuffer buffer, int len) {
        if (buffer.hasArray()) {
            return buffer;
        }
        ByteBuffer heapBuffer = ByteBuffer.allocate(len);
        int pos = buffer.position();
        int limit = buffer.limit();
        buffer.limit(pos + len);
        try {
            heapBuffer.put(buffer);
            heapBuffer.flip();
            ByteBuffer byteBuffer = heapBuffer;
            return byteBuffer;
        }
        finally {
            buffer.limit(limit);
            buffer.position(pos);
        }
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer src) {
        this.singleSrcBuffer[0] = src;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer src) {
        this.singleDstBuffer[0] = src;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    private static void checkIndex(int arrayLength, int offset, int length, String arrayName) {
        if ((offset | length) < 0 || offset + length > arrayLength) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + " (expected: offset <= offset + length <= " + arrayName + ".length (" + arrayLength + "))");
        }
    }
}

