/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.conscrypt.AddressUtils;
import org.conscrypt.EmptyArray;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.PSKKeyManager;
import org.conscrypt.SSLParametersImpl;
import org.conscrypt.SSLUtils;

final class SslWrapper {
    private final SSLParametersImpl parameters;
    private final NativeCrypto.SSLHandshakeCallbacks handshakeCallbacks;
    private final SSLParametersImpl.AliasChooser aliasChooser;
    private final SSLParametersImpl.PSKCallbacks pskCallbacks;
    private X509Certificate[] localCertificates;
    private volatile long ssl;

    static SslWrapper newInstance(SSLParametersImpl parameters, NativeCrypto.SSLHandshakeCallbacks handshakeCallbacks, SSLParametersImpl.AliasChooser chooser, SSLParametersImpl.PSKCallbacks pskCallbacks) throws SSLException {
        long ctx = parameters.getSessionContext().sslCtxNativePointer;
        long ssl = NativeCrypto.SSL_new(ctx);
        return new SslWrapper(ssl, parameters, handshakeCallbacks, chooser, pskCallbacks);
    }

    private SslWrapper(long ssl, SSLParametersImpl parameters, NativeCrypto.SSLHandshakeCallbacks handshakeCallbacks, SSLParametersImpl.AliasChooser aliasChooser, SSLParametersImpl.PSKCallbacks pskCallbacks) {
        this.ssl = ssl;
        this.parameters = parameters;
        this.handshakeCallbacks = handshakeCallbacks;
        this.aliasChooser = aliasChooser;
        this.pskCallbacks = pskCallbacks;
    }

    long ssl() {
        return this.ssl;
    }

    BioWrapper newBio() {
        try {
            return new BioWrapper();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    void offerToResumeSession(long sslSessionNativePointer) throws SSLException {
        NativeCrypto.SSL_set_session(this.ssl, sslSessionNativePointer);
    }

    byte[] getSessionId() {
        return NativeCrypto.SSL_session_id(this.ssl);
    }

    long getTime() {
        return NativeCrypto.SSL_get_time(this.ssl);
    }

    long getTimeout() {
        return NativeCrypto.SSL_get_timeout(this.ssl);
    }

    void setTimeout(long millis) {
        NativeCrypto.SSL_set_timeout(this.ssl, millis);
    }

    String getCipherSuite() {
        return NativeCrypto.cipherSuiteToJava(NativeCrypto.SSL_get_current_cipher(this.ssl));
    }

    X509Certificate[] getPeerCertificates() throws CertificateException {
        byte[][] encoded = NativeCrypto.SSL_get0_peer_certificates(this.ssl);
        return encoded == null ? null : SSLUtils.decodeX509CertificateChain(encoded);
    }

    X509Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    byte[] getPeerCertificateOcspData() {
        return NativeCrypto.SSL_get_ocsp_response(this.ssl);
    }

    byte[] getPeerTlsSctData() {
        return NativeCrypto.SSL_get_signed_cert_timestamp_list(this.ssl);
    }

    int clientPSKKeyRequested(String identityHint, byte[] identityBytesOut, byte[] key) {
        byte[] identityBytes;
        PSKKeyManager pskKeyManager = this.parameters.getPSKKeyManager();
        if (pskKeyManager == null) {
            return 0;
        }
        String identity = this.pskCallbacks.chooseClientPSKIdentity(pskKeyManager, identityHint);
        if (identity == null) {
            identity = "";
            identityBytes = EmptyArray.BYTE;
        } else if (identity.isEmpty()) {
            identityBytes = EmptyArray.BYTE;
        } else {
            try {
                identityBytes = identity.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding not supported", e);
            }
        }
        if (identityBytes.length + 1 > identityBytesOut.length) {
            return 0;
        }
        if (identityBytes.length > 0) {
            System.arraycopy(identityBytes, 0, identityBytesOut, 0, identityBytes.length);
        }
        identityBytesOut[identityBytes.length] = 0;
        SecretKey secretKey = this.pskCallbacks.getPSKKey(pskKeyManager, identityHint, identity);
        byte[] secretKeyBytes = secretKey.getEncoded();
        if (secretKeyBytes == null) {
            return 0;
        }
        if (secretKeyBytes.length > key.length) {
            return 0;
        }
        System.arraycopy(secretKeyBytes, 0, key, 0, secretKeyBytes.length);
        return secretKeyBytes.length;
    }

    int serverPSKKeyRequested(String identityHint, String identity, byte[] key) {
        PSKKeyManager pskKeyManager = this.parameters.getPSKKeyManager();
        if (pskKeyManager == null) {
            return 0;
        }
        SecretKey secretKey = this.pskCallbacks.getPSKKey(pskKeyManager, identityHint, identity);
        byte[] secretKeyBytes = secretKey.getEncoded();
        if (secretKeyBytes == null) {
            return 0;
        }
        if (secretKeyBytes.length > key.length) {
            return 0;
        }
        System.arraycopy(secretKeyBytes, 0, key, 0, secretKeyBytes.length);
        return secretKeyBytes.length;
    }

    void chooseClientCertificate(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws SSLException, CertificateEncodingException {
        X500Principal[] issuers;
        Set<String> keyTypesSet = SSLUtils.getSupportedClientKeyTypes(keyTypeBytes);
        String[] keyTypes = keyTypesSet.toArray(new String[keyTypesSet.size()]);
        if (asn1DerEncodedPrincipals == null) {
            issuers = null;
        } else {
            issuers = new X500Principal[asn1DerEncodedPrincipals.length];
            for (int i = 0; i < asn1DerEncodedPrincipals.length; ++i) {
                issuers[i] = new X500Principal(asn1DerEncodedPrincipals[i]);
            }
        }
        X509KeyManager keyManager = this.parameters.getX509KeyManager();
        String alias = keyManager != null ? this.aliasChooser.chooseClientAlias(keyManager, issuers, keyTypes) : null;
        this.setCertificate(alias);
    }

    void setCertificate(String alias) throws CertificateEncodingException, SSLException {
        OpenSSLKey key;
        if (alias == null) {
            return;
        }
        X509KeyManager keyManager = this.parameters.getX509KeyManager();
        if (keyManager == null) {
            return;
        }
        PrivateKey privateKey = keyManager.getPrivateKey(alias);
        if (privateKey == null) {
            return;
        }
        this.localCertificates = keyManager.getCertificateChain(alias);
        if (this.localCertificates == null) {
            return;
        }
        int numLocalCerts = this.localCertificates.length;
        PublicKey publicKey = numLocalCerts > 0 ? this.localCertificates[0].getPublicKey() : null;
        byte[][] encodedLocalCerts = new byte[numLocalCerts][];
        for (int i = 0; i < numLocalCerts; ++i) {
            encodedLocalCerts[i] = this.localCertificates[i].getEncoded();
        }
        try {
            key = OpenSSLKey.fromPrivateKeyForTLSStackOnly(privateKey, publicKey);
        }
        catch (InvalidKeyException e) {
            throw new SSLException(e);
        }
        NativeCrypto.setLocalCertsAndPrivateKey(this.ssl, encodedLocalCerts, key.getNativeRef());
    }

    String getVersion() {
        return NativeCrypto.SSL_get_version(this.ssl);
    }

    String getRequestedServerName() {
        return NativeCrypto.SSL_get_servername(this.ssl);
    }

    byte[] getTlsChannelId() throws SSLException {
        return NativeCrypto.SSL_get_tls_channel_id(this.ssl);
    }

    void initialize(String hostname, OpenSSLKey channelIdPrivateKey) throws IOException {
        boolean enableSessionCreation = this.parameters.getEnableSessionCreation();
        if (!enableSessionCreation) {
            NativeCrypto.SSL_set_session_creation_enabled(this.ssl, false);
        }
        NativeCrypto.SSL_accept_renegotiations(this.ssl);
        if (this.isClient()) {
            NativeCrypto.SSL_set_connect_state(this.ssl);
            NativeCrypto.SSL_enable_ocsp_stapling(this.ssl);
            if (this.parameters.isCTVerificationEnabled(hostname)) {
                NativeCrypto.SSL_enable_signed_cert_timestamps(this.ssl);
            }
        } else {
            NativeCrypto.SSL_set_accept_state(this.ssl);
            if (this.parameters.getOCSPResponse() != null) {
                NativeCrypto.SSL_enable_ocsp_stapling(this.ssl);
            }
        }
        if (this.parameters.getEnabledProtocols().length == 0 && this.parameters.isEnabledProtocolsFiltered) {
            throw new SSLHandshakeException("No enabled protocols; SSLv3 is no longer supported and was filtered from the list");
        }
        NativeCrypto.setEnabledProtocols(this.ssl, this.parameters.enabledProtocols);
        NativeCrypto.setEnabledCipherSuites(this.ssl, this.parameters.enabledCipherSuites);
        if (this.parameters.alpnProtocols != null) {
            NativeCrypto.setAlpnProtocols(this.ssl, this.isClient(), this.parameters.alpnProtocols);
        }
        if (!this.isClient() && this.parameters.alpnProtocolSelector != null) {
            NativeCrypto.setAlpnProtocolSelector(this.ssl, this.parameters.alpnProtocolSelector);
        }
        if (!this.isClient()) {
            HashSet<String> keyTypes = new HashSet<String>();
            for (long sslCipherNativePointer : NativeCrypto.SSL_get_ciphers(this.ssl)) {
                String keyType = SSLUtils.getServerX509KeyType(sslCipherNativePointer);
                if (keyType == null) continue;
                keyTypes.add(keyType);
            }
            X509KeyManager keyManager = this.parameters.getX509KeyManager();
            if (keyManager != null) {
                for (String keyType : keyTypes) {
                    try {
                        this.setCertificate(this.aliasChooser.chooseServerAlias(keyManager, keyType));
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException(e);
                    }
                }
            }
            NativeCrypto.SSL_set_options(this.ssl, 0x400000L);
            if (this.parameters.sctExtension != null) {
                NativeCrypto.SSL_set_signed_cert_timestamp_list(this.ssl, this.parameters.sctExtension);
            }
            if (this.parameters.ocspResponse != null) {
                NativeCrypto.SSL_set_ocsp_response(this.ssl, this.parameters.ocspResponse);
            }
        }
        this.enablePSKKeyManagerIfRequested();
        if (this.parameters.useSessionTickets) {
            NativeCrypto.SSL_clear_options(this.ssl, 16384L);
        } else {
            NativeCrypto.SSL_set_options(this.ssl, NativeCrypto.SSL_get_options(this.ssl) | 0x4000L);
        }
        if (this.parameters.getUseSni() && AddressUtils.isValidSniHostname(hostname)) {
            NativeCrypto.SSL_set_tlsext_host_name(this.ssl, hostname);
        }
        NativeCrypto.SSL_set_mode(this.ssl, 256L);
        this.setCertificateValidation(this.ssl);
        this.setTlsChannelId(channelIdPrivateKey);
    }

    void doHandshake(FileDescriptor fd, int timeoutMillis) throws CertificateException, SocketTimeoutException, SSLException {
        NativeCrypto.SSL_do_handshake(this.ssl, fd, this.handshakeCallbacks, timeoutMillis);
    }

    int doHandshake() throws IOException {
        return NativeCrypto.ENGINE_SSL_do_handshake(this.ssl, this.handshakeCallbacks);
    }

    int read(FileDescriptor fd, byte[] buf, int offset, int len, int timeoutMillis) throws IOException {
        return NativeCrypto.SSL_read(this.ssl, fd, this.handshakeCallbacks, buf, offset, len, timeoutMillis);
    }

    void write(FileDescriptor fd, byte[] buf, int offset, int len, int timeoutMillis) throws IOException {
        NativeCrypto.SSL_write(this.ssl, fd, this.handshakeCallbacks, buf, offset, len, timeoutMillis);
    }

    private void enablePSKKeyManagerIfRequested() throws SSLException {
        PSKKeyManager pskKeyManager = this.parameters.getPSKKeyManager();
        if (pskKeyManager != null) {
            boolean pskEnabled = false;
            for (String enabledCipherSuite : this.parameters.enabledCipherSuites) {
                if (enabledCipherSuite == null || !enabledCipherSuite.contains("PSK")) continue;
                pskEnabled = true;
                break;
            }
            if (pskEnabled) {
                if (this.isClient()) {
                    NativeCrypto.set_SSL_psk_client_callback_enabled(this.ssl, true);
                } else {
                    NativeCrypto.set_SSL_psk_server_callback_enabled(this.ssl, true);
                    String identityHint = this.pskCallbacks.chooseServerPSKIdentityHint(pskKeyManager);
                    NativeCrypto.SSL_use_psk_identity_hint(this.ssl, identityHint);
                }
            }
        }
    }

    private void setTlsChannelId(OpenSSLKey channelIdPrivateKey) throws SSLException {
        if (!this.parameters.channelIdEnabled) {
            return;
        }
        if (this.parameters.getUseClientMode()) {
            if (channelIdPrivateKey == null) {
                throw new SSLHandshakeException("Invalid TLS channel ID key specified");
            }
            NativeCrypto.SSL_set1_tls_channel_id(this.ssl, channelIdPrivateKey.getNativeRef());
        } else {
            NativeCrypto.SSL_enable_tls_channel_id(this.ssl);
        }
    }

    private void setCertificateValidation(long sslNativePointer) throws SSLException {
        if (!this.isClient()) {
            X509TrustManager trustManager;
            X509Certificate[] issuers;
            boolean certRequested;
            if (this.parameters.getNeedClientAuth()) {
                NativeCrypto.SSL_set_verify(sslNativePointer, 3);
                certRequested = true;
            } else if (this.parameters.getWantClientAuth()) {
                NativeCrypto.SSL_set_verify(sslNativePointer, 1);
                certRequested = true;
            } else {
                NativeCrypto.SSL_set_verify(sslNativePointer, 0);
                certRequested = false;
            }
            if (certRequested && (issuers = (trustManager = this.parameters.getX509TrustManager()).getAcceptedIssuers()) != null && issuers.length != 0) {
                byte[][] issuersBytes;
                try {
                    issuersBytes = SSLUtils.encodeIssuerX509Principals(issuers);
                }
                catch (CertificateEncodingException e) {
                    throw new SSLException("Problem encoding principals", e);
                }
                NativeCrypto.SSL_set_client_CA_list(sslNativePointer, issuersBytes);
            }
        }
    }

    void interrupt() {
        NativeCrypto.SSL_interrupt(this.ssl);
    }

    void shutdown(FileDescriptor fd) throws IOException {
        NativeCrypto.SSL_shutdown(this.ssl, fd, this.handshakeCallbacks);
    }

    void shutdown() throws IOException {
        NativeCrypto.ENGINE_SSL_shutdown(this.ssl, this.handshakeCallbacks);
    }

    boolean wasShutdownReceived() {
        return (NativeCrypto.SSL_get_shutdown(this.ssl) & 2) != 0;
    }

    boolean wasShutdownSent() {
        return (NativeCrypto.SSL_get_shutdown(this.ssl) & 1) != 0;
    }

    int readDirectByteBuffer(long destAddress, int destLength) throws IOException, CertificateException {
        return NativeCrypto.ENGINE_SSL_read_direct(this.ssl, destAddress, destLength, this.handshakeCallbacks);
    }

    int writeDirectByteBuffer(long sourceAddress, int sourceLength) throws IOException {
        return NativeCrypto.ENGINE_SSL_write_direct(this.ssl, sourceAddress, sourceLength, this.handshakeCallbacks);
    }

    int getPendingReadableBytes() {
        return NativeCrypto.SSL_pending_readable_bytes(this.ssl);
    }

    int getMaxSealOverhead() {
        return NativeCrypto.SSL_max_seal_overhead(this.ssl);
    }

    void close() {
        NativeCrypto.SSL_free(this.ssl);
        this.ssl = 0L;
    }

    boolean isClosed() {
        return this.ssl == 0L;
    }

    int getError(int result) {
        return NativeCrypto.SSL_get_error(this.ssl, result);
    }

    byte[] getAlpnSelectedProtocol() {
        return NativeCrypto.getAlpnSelectedProtocol(this.ssl);
    }

    private boolean isClient() {
        return this.parameters.getUseClientMode();
    }

    final class BioWrapper {
        private long bio;

        private BioWrapper() throws SSLException {
            this.bio = NativeCrypto.SSL_BIO_new(SslWrapper.this.ssl);
        }

        int getPendingWrittenBytes() {
            return NativeCrypto.SSL_pending_written_bytes_in_BIO(this.bio);
        }

        int writeDirectByteBuffer(long address, int length) throws IOException {
            return NativeCrypto.ENGINE_SSL_write_BIO_direct(SslWrapper.this.ssl, this.bio, address, length, SslWrapper.this.handshakeCallbacks);
        }

        int readDirectByteBuffer(long destAddress, int destLength) throws IOException {
            return NativeCrypto.ENGINE_SSL_read_BIO_direct(SslWrapper.this.ssl, this.bio, destAddress, destLength, SslWrapper.this.handshakeCallbacks);
        }

        void close() {
            NativeCrypto.BIO_free_all(this.bio);
            this.bio = 0L;
        }
    }
}

