/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.task.list.items.internal;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.ext.task.list.items.TaskListItemMarker;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.parser.PostProcessor;

public class TaskListItemPostProcessor
implements PostProcessor {
    private static final Pattern REGEX_TASK_LIST_ITEM = Pattern.compile("^\\[([xX\\s])]\\s+(.*)");

    public Node process(Node node) {
        TaskListItemVisitor visitor = new TaskListItemVisitor();
        node.accept((Visitor)visitor);
        return node;
    }

    private static class TaskListItemVisitor
    extends AbstractVisitor {
        private TaskListItemVisitor() {
        }

        public void visit(ListItem listItem) {
            Text textNode;
            Matcher matcher;
            Node node;
            Node child = listItem.getFirstChild();
            if (child instanceof Paragraph && (node = child.getFirstChild()) instanceof Text && (matcher = REGEX_TASK_LIST_ITEM.matcher((textNode = (Text)node).getLiteral())).matches()) {
                String checked = matcher.group(1);
                boolean isChecked = Objects.equals(checked, "X") || Objects.equals(checked, "x");
                listItem.prependChild((Node)new TaskListItemMarker(isChecked));
                textNode.setLiteral(matcher.group(2));
            }
            this.visitChildren((Node)listItem);
        }
    }
}

