/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.AsyncFoldLeft;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class AbstractHttpTransport
extends AbstractServerTransport {
    public static final String PREFIX = "long-polling";
    public static final String JSON_DEBUG_OPTION = "jsonDebug";
    public static final String MESSAGE_PARAM = "message";
    public static final String BROWSER_COOKIE_NAME_OPTION = "browserCookieName";
    public static final String BROWSER_COOKIE_DOMAIN_OPTION = "browserCookieDomain";
    public static final String BROWSER_COOKIE_PATH_OPTION = "browserCookiePath";
    public static final String BROWSER_COOKIE_SECURE_OPTION = "browserCookieSecure";
    public static final String BROWSER_COOKIE_HTTP_ONLY_OPTION = "browserCookieHttpOnly";
    public static final String BROWSER_COOKIE_SAME_SITE_OPTION = "browserCookieSameSite";
    public static final String MAX_SESSIONS_PER_BROWSER_OPTION = "maxSessionsPerBrowser";
    public static final String HTTP2_MAX_SESSIONS_PER_BROWSER_OPTION = "http2MaxSessionsPerBrowser";
    public static final String MULTI_SESSION_INTERVAL_OPTION = "multiSessionInterval";
    public static final String TRUST_CLIENT_SESSION_OPTION = "trustClientSession";
    public static final String DUPLICATE_META_CONNECT_HTTP_RESPONSE_CODE_OPTION = "duplicateMetaConnectHttpResponseCode";
    @Deprecated
    public static final String TRUST_CLIENT_SESSION = "trustClientSession";
    private final Map<String, Collection<ServerSessionImpl>> _sessions = new HashMap<String, Collection<ServerSessionImpl>>();
    private final ConcurrentMap<String, AtomicInteger> _browserMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> _browserSweep = new ConcurrentHashMap<String, AtomicInteger>();
    private String _browserCookieName;
    private String _browserCookieDomain;
    private String _browserCookiePath;
    private boolean _browserCookieSecure;
    private boolean _browserCookieHttpOnly;
    private String _browserCookieSameSite;
    private int _maxSessionsPerBrowser;
    private int _http2MaxSessionsPerBrowser;
    private long _multiSessionInterval;
    private boolean _trustClientSession;
    private int _duplicateMetaConnectHttpResponseCode;
    private long _lastSweep;

    protected AbstractHttpTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public void init() {
        super.init();
        this._browserCookieName = this.getOption(BROWSER_COOKIE_NAME_OPTION, "BAYEUX_BROWSER");
        this._browserCookieDomain = this.getOption(BROWSER_COOKIE_DOMAIN_OPTION, null);
        this._browserCookiePath = this.getOption(BROWSER_COOKIE_PATH_OPTION, "/");
        this._browserCookieSecure = this.getOption(BROWSER_COOKIE_SECURE_OPTION, false);
        this._browserCookieHttpOnly = this.getOption(BROWSER_COOKIE_HTTP_ONLY_OPTION, true);
        this._browserCookieSameSite = this.getOption(BROWSER_COOKIE_SAME_SITE_OPTION, null);
        this._maxSessionsPerBrowser = this.getOption(MAX_SESSIONS_PER_BROWSER_OPTION, 1);
        this._http2MaxSessionsPerBrowser = this.getOption(HTTP2_MAX_SESSIONS_PER_BROWSER_OPTION, -1);
        this._multiSessionInterval = this.getOption(MULTI_SESSION_INTERVAL_OPTION, 2000);
        this._trustClientSession = this.getOption("trustClientSession", false);
        this._duplicateMetaConnectHttpResponseCode = this.getOption(DUPLICATE_META_CONNECT_HTTP_RESPONSE_CODE_OPTION, 500);
        if (this._duplicateMetaConnectHttpResponseCode < 400) {
            throw new IllegalArgumentException("Option 'duplicateMetaConnectHttpResponseCode' must be greater or equal to 400, not " + this._duplicateMetaConnectHttpResponseCode);
        }
    }

    protected long getMultiSessionInterval() {
        return this._multiSessionInterval;
    }

    protected int getDuplicateMetaConnectHttpResponseCode() {
        return this._duplicateMetaConnectHttpResponseCode;
    }

    public abstract boolean accept(HttpServletRequest var1);

    public abstract void handle(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    protected abstract HttpScheduler suspend(Context var1, Promise<Void> var2, ServerMessage.Mutable var3, long var4);

    protected abstract void write(Context var1, List<ServerMessage> var2, Promise<Void> var3);

    protected void processMessages(Context context, ServerMessage.Mutable[] messages, Promise<Void> promise) {
        if (messages.length == 0) {
            promise.fail((Throwable)new IOException("protocol violation"));
        } else {
            boolean batch;
            Collection<ServerSessionImpl> sessions = this.findCurrentSessions(context.request);
            ServerMessage.Mutable message = messages[0];
            ServerSessionImpl session = this.findSession(sessions, message);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Processing {} messages for session {}", (Object)messages.length, (Object)session);
            }
            boolean bl = batch = session != null && !"/meta/connect".equals(message.getChannel());
            if (batch) {
                session.startBatch();
            }
            context.messages = messages;
            context.session = session;
            context.bayeuxContext = new HttpContext(context.request);
            AsyncFoldLeft.run((Object[])messages, null, (result, item, loop) -> this.processMessage(context, (ServerMessageImpl)((Object)item), (Promise<Void>)Promise.from(arg_0 -> ((AsyncFoldLeft.Loop)loop).proceed(arg_0), arg_0 -> ((AsyncFoldLeft.Loop)loop).fail(arg_0))), (Promise)Promise.from(y -> {
                this.flush(context, promise);
                if (batch) {
                    session.endBatch();
                }
            }, arg_0 -> promise.fail(arg_0)));
        }
    }

    private void processMessage(Context context, ServerMessageImpl message, Promise<Void> promise) {
        String channel;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Processing {}", (Object)message);
        }
        message.setServerTransport(this);
        message.setBayeuxContext(context.bayeuxContext);
        ServerSessionImpl session = context.session;
        if (session != null) {
            session.setServerTransport(this);
        }
        if ("/meta/handshake".equals(channel = message.getChannel())) {
            if (context.messages.length > 1) {
                promise.fail((Throwable)new IOException("bayeux protocol violation"));
            } else {
                this.processMetaHandshake(context, message, promise);
            }
        } else if ("/meta/connect".equals(channel)) {
            boolean canSuspend = context.messages.length == 1;
            this.processMetaConnect(context, message, canSuspend, (Promise<Void>)Promise.from(y -> this.resume(context, message, promise), arg_0 -> promise.fail(arg_0)));
        } else {
            this.processMessage1(context, message, promise);
        }
    }

    protected ServerSessionImpl findSession(Collection<ServerSessionImpl> sessions, ServerMessage.Mutable message) {
        if ("/meta/handshake".equals(message.getChannel())) {
            ServerSessionImpl session = this.getBayeux().newServerSession();
            session.setAllowMessageDeliveryDuringHandshake(this.isAllowMessageDeliveryDuringHandshake());
            return session;
        }
        String clientId = message.getClientId();
        if (sessions != null && clientId != null) {
            for (ServerSessionImpl session : sessions) {
                if (!session.getId().equals(clientId)) continue;
                return session;
            }
        }
        if (this._trustClientSession) {
            return (ServerSessionImpl)this.getBayeux().getSession(clientId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ServerSessionImpl> findCurrentSessions(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._browserCookieName.equals(cookie.getName())) continue;
                Map<String, Collection<ServerSessionImpl>> map = this._sessions;
                synchronized (map) {
                    return this._sessions.get(cookie.getValue());
                }
            }
        }
        return null;
    }

    private void processMetaHandshake(Context context, ServerMessage.Mutable message, Promise<Void> promise) {
        this.handleMessage(context, message, (Promise<ServerMessage.Mutable>)Promise.from(reply -> {
            ServerSessionImpl session = context.session;
            if (reply.isSuccessful()) {
                String id = this.findBrowserId(context);
                if (id == null) {
                    id = this.setBrowserId(context);
                }
                String browserId = id;
                session.setBrowserId(browserId);
                Map<String, Collection<ServerSessionImpl>> map = this._sessions;
                synchronized (map) {
                    Collection sessions = this._sessions.computeIfAbsent(browserId, k -> new CopyOnWriteArrayList());
                    sessions.add(session);
                }
                session.addListener((ServerSession.ServerSessionListener)((ServerSession.RemoveListener)(s, timeout) -> {
                    Map<String, Collection<ServerSessionImpl>> map = this._sessions;
                    synchronized (map) {
                        Collection<ServerSessionImpl> sessions = this._sessions.get(browserId);
                        sessions.remove(session);
                        if (sessions.isEmpty()) {
                            this._sessions.remove(browserId);
                        }
                    }
                }));
            }
            this.processReply(session, (ServerMessage.Mutable)reply, (Promise<ServerMessage.Mutable>)Promise.from(r -> {
                if (r != null) {
                    context.replies.add((ServerMessage.Mutable)r);
                }
                context.sendQueue = r != null && r.isSuccessful() && this.allowMessageDeliveryDuringHandshake(session);
                context.scheduleExpiration = true;
                promise.succeed(null);
            }, arg_0 -> ((Promise)promise).fail(arg_0)));
        }, arg_0 -> promise.fail(arg_0)));
    }

    private void processMetaConnect(Context context, ServerMessage.Mutable message, boolean canSuspend, Promise<Void> promise) {
        ServerSessionImpl session = context.session;
        if (session != null) {
            session.setScheduler(null);
        }
        boolean wasConnected = session != null && session.isConnected();
        this.handleMessage(context, message, (Promise<ServerMessage.Mutable>)Promise.from(reply -> {
            boolean proceed = true;
            if (session != null) {
                boolean maySuspend;
                boolean bl = maySuspend = !session.shouldSchedule();
                if (canSuspend && maySuspend && reply.isSuccessful()) {
                    HttpServletRequest request = context.request;
                    boolean allowSuspendConnect = this.incBrowserId(session, this.isHTTP2(request));
                    if (allowSuspendConnect) {
                        long timeout = session.calculateTimeout(this.getTimeout());
                        if (timeout > 0L && wasConnected && session.isConnected()) {
                            HttpScheduler scheduler = this.suspend(context, promise, message, timeout);
                            session.setScheduler(scheduler);
                            proceed = false;
                        } else {
                            this.decBrowserId(session, this.isHTTP2(request));
                        }
                    } else {
                        Map advice = reply.getAdvice(true);
                        advice.put("multiple-clients", true);
                        long multiSessionInterval = this.getMultiSessionInterval();
                        if (multiSessionInterval > 0L) {
                            advice.put("reconnect", "retry");
                            advice.put("interval", multiSessionInterval);
                        } else {
                            advice.put("reconnect", "none");
                            reply.setSuccessful(false);
                        }
                    }
                }
                if (proceed && session.isDisconnected()) {
                    reply.getAdvice(true).put("reconnect", "none");
                }
            }
            if (proceed) {
                promise.succeed(null);
            }
        }, arg_0 -> promise.fail(arg_0)));
    }

    private void processMessage1(Context context, ServerMessageImpl message, Promise<Void> promise) {
        this.handleMessage(context, message, (Promise<ServerMessage.Mutable>)Promise.from(y -> {
            ServerSessionImpl session = context.session;
            this.processReply(session, message.getAssociated(), (Promise<ServerMessage.Mutable>)Promise.from(reply -> {
                boolean metaConnectDelivery;
                if (reply != null) {
                    context.replies.add((ServerMessage.Mutable)reply);
                }
                boolean bl = metaConnectDelivery = this.isMetaConnectDeliveryOnly() || session != null && session.isMetaConnectDeliveryOnly();
                if (!metaConnectDelivery) {
                    context.sendQueue = true;
                }
                promise.succeed(null);
            }, arg_0 -> ((Promise)promise).fail(arg_0)));
        }, arg_0 -> promise.fail(arg_0)));
    }

    protected boolean isHTTP2(HttpServletRequest request) {
        return "HTTP/2.0".equals(request.getProtocol());
    }

    protected void flush(Context context, Promise<Void> promise) {
        List<ServerMessage> messages = Collections.emptyList();
        ServerSessionImpl session = context.session;
        if (context.sendQueue && session != null) {
            messages = session.takeQueue(context.replies);
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Flushing {}, replies={}, messages={}", new Object[]{session, context.replies, messages});
        }
        this.write(context, messages, promise);
    }

    protected void resume(Context context, ServerMessage.Mutable message, Promise<Void> promise) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Resumed {}", (Object)message);
        }
        ServerMessage.Mutable reply = message.getAssociated();
        ServerSessionImpl session = context.session;
        if (session != null) {
            Map<String, Object> advice = session.takeAdvice(this);
            if (advice != null) {
                reply.put((Object)"advice", advice);
            }
            if (session.isDisconnected()) {
                reply.getAdvice(true).put("reconnect", "none");
            }
        }
        this.processReply(session, reply, (Promise<ServerMessage.Mutable>)Promise.from(r -> {
            if (r != null) {
                context.replies.add((ServerMessage.Mutable)r);
            }
            context.sendQueue = true;
            context.scheduleExpiration = true;
            promise.succeed(null);
        }, arg_0 -> promise.fail(arg_0)));
    }

    protected void sendError(HttpServletRequest request, HttpServletResponse response, int code, Throwable failure) {
        block2: {
            try {
                request.setAttribute("javax.servlet.error.exception", (Object)failure);
                response.setStatus(code);
            }
            catch (Throwable x) {
                if (!this._logger.isDebugEnabled()) break block2;
                this._logger.debug("", x);
            }
        }
    }

    protected String findBrowserId(Context context) {
        return context.bayeuxContext.getCookie(this._browserCookieName);
    }

    protected String setBrowserId(Context context) {
        StringBuilder builder = new StringBuilder();
        while (builder.length() < 16) {
            builder.append(Long.toString(this.getBayeux().randomLong(), 36));
        }
        builder.setLength(16);
        String browserId = builder.toString();
        builder.setLength(0);
        builder.append(this._browserCookieName).append("=").append(browserId);
        if (this._browserCookieDomain != null) {
            builder.append("; Domain=").append(this._browserCookieDomain);
        }
        if (this._browserCookiePath != null) {
            builder.append("; Path=").append(this._browserCookiePath);
        }
        if (this._browserCookieHttpOnly) {
            builder.append("; HttpOnly");
        }
        if (context.request.isSecure() && this._browserCookieSecure) {
            builder.append("; Secure");
        }
        if (this._browserCookieSameSite != null) {
            builder.append("; SameSite=").append(this._browserCookieSameSite);
        }
        context.response.addHeader("Set-Cookie", builder.toString());
        return browserId;
    }

    protected boolean incBrowserId(ServerSessionImpl session, boolean http2) {
        int sessions;
        AtomicInteger newCount;
        int maxSessionsPerBrowser;
        int n = maxSessionsPerBrowser = http2 ? this._http2MaxSessionsPerBrowser : this._maxSessionsPerBrowser;
        if (maxSessionsPerBrowser < 0) {
            return true;
        }
        if (maxSessionsPerBrowser == 0) {
            return false;
        }
        String browserId = session.getBrowserId();
        AtomicInteger count = (AtomicInteger)this._browserMap.get(browserId);
        if (count == null && (count = this._browserMap.putIfAbsent(browserId, newCount = new AtomicInteger())) == null) {
            count = newCount;
        }
        if ((sessions = count.incrementAndGet()) == 1) {
            this._browserSweep.remove(browserId);
        }
        boolean result = true;
        if (sessions > maxSessionsPerBrowser) {
            sessions = count.decrementAndGet();
            result = false;
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("client {} {} sessions for {}", new Object[]{browserId, sessions, session});
        }
        return result;
    }

    protected void decBrowserId(ServerSessionImpl session, boolean http2) {
        int maxSessionsPerBrowser = http2 ? this._http2MaxSessionsPerBrowser : this._maxSessionsPerBrowser;
        String browserId = session.getBrowserId();
        if (maxSessionsPerBrowser <= 0 || browserId == null) {
            return;
        }
        int sessions = -1;
        AtomicInteger count = (AtomicInteger)this._browserMap.get(browserId);
        if (count != null) {
            sessions = count.decrementAndGet();
        }
        if (sessions == 0) {
            this._browserSweep.put(browserId, new AtomicInteger(0));
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("client {} {} sessions for {}", new Object[]{browserId, sessions, session});
        }
    }

    protected void handleJSONParseException(HttpServletRequest request, HttpServletResponse response, String json, Throwable failure) throws IOException {
        this._logger.warn("Could not parse JSON: " + json, failure);
        this.sendError(request, response, 400, failure);
    }

    protected void handleMessage(Context context, ServerMessage.Mutable message, Promise<ServerMessage.Mutable> promise) {
        this.getBayeux().handle(context.session, message, promise);
    }

    protected AsyncContext getAsyncContext(HttpServletRequest request) {
        try {
            return request.getAsyncContext();
        }
        catch (Throwable x) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Could not retrieve AsyncContext for " + request, x);
            }
            return null;
        }
    }

    @Override
    protected void sweep() {
        long now = System.nanoTime();
        long elapsed = TimeUnit.NANOSECONDS.toMillis(now - this._lastSweep);
        if (this._lastSweep != 0L && elapsed > 0L) {
            int maxSweeps = (int)(2L * this.getMaxInterval() / elapsed);
            for (Map.Entry<String, AtomicInteger> entry : this._browserSweep.entrySet()) {
                String key;
                AtomicInteger count = entry.getValue();
                if (count == null || count.incrementAndGet() <= maxSweeps || this._browserSweep.remove(key = entry.getKey()) != count || ((AtomicInteger)this._browserMap.get(key)).get() != 0) continue;
                this._browserMap.remove(key);
                if (!this._logger.isDebugEnabled()) continue;
                this._logger.debug("Swept browserId {}", (Object)key);
            }
        }
        this._lastSweep = now;
    }

    protected byte[] toJSONBytes(ServerMessage msg) {
        ServerMessageImpl message = (ServerMessageImpl)((Object)(msg instanceof ServerMessageImpl ? msg : this.getBayeux().newMessage(msg)));
        byte[] bytes = message.getJSONBytes();
        if (bytes == null) {
            bytes = this.toJSON((ServerMessage)message).getBytes(StandardCharsets.UTF_8);
        }
        return bytes;
    }

    public static class Context {
        protected final List<ServerMessage.Mutable> replies = new ArrayList<ServerMessage.Mutable>();
        public final HttpServletRequest request;
        public final HttpServletResponse response;
        protected ServerMessage.Mutable[] messages;
        protected ServerSessionImpl session;
        protected BayeuxContext bayeuxContext;
        protected boolean sendQueue;
        protected boolean scheduleExpiration;
        protected HttpScheduler scheduler;

        protected Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }
    }

    private static class HttpContext
    implements BayeuxContext {
        final HttpServletRequest _request;

        private HttpContext(HttpServletRequest request) {
            this._request = request;
        }

        public Principal getUserPrincipal() {
            return this._request.getUserPrincipal();
        }

        public boolean isUserInRole(String role) {
            return this._request.isUserInRole(role);
        }

        public InetSocketAddress getRemoteAddress() {
            return new InetSocketAddress(this._request.getRemoteHost(), this._request.getRemotePort());
        }

        public InetSocketAddress getLocalAddress() {
            return new InetSocketAddress(this._request.getLocalName(), this._request.getLocalPort());
        }

        public String getHeader(String name) {
            return this._request.getHeader(name);
        }

        public List<String> getHeaderValues(String name) {
            return Collections.list(this._request.getHeaders(name));
        }

        public String getParameter(String name) {
            return this._request.getParameter(name);
        }

        public List<String> getParameterValues(String name) {
            return Arrays.asList(this._request.getParameterValues(name));
        }

        public String getCookie(String name) {
            Cookie[] cookies = this._request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!name.equals(c.getName())) continue;
                    return c.getValue();
                }
            }
            return null;
        }

        public String getHttpSessionId() {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                return session.getId();
            }
            return null;
        }

        public Object getHttpSessionAttribute(String name) {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                return session.getAttribute(name);
            }
            return null;
        }

        public void setHttpSessionAttribute(String name, Object value) {
            HttpSession session = this._request.getSession(false);
            if (session == null) {
                throw new IllegalStateException("!session");
            }
            session.setAttribute(name, value);
        }

        public void invalidateHttpSession() {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }

        public Object getRequestAttribute(String name) {
            return this._request.getAttribute(name);
        }

        private ServletContext getServletContext() {
            HttpSession s = this._request.getSession(false);
            if (s != null) {
                return s.getServletContext();
            }
            s = this._request.getSession(true);
            ServletContext servletContext = s.getServletContext();
            s.invalidate();
            return servletContext;
        }

        public Object getContextAttribute(String name) {
            return this.getServletContext().getAttribute(name);
        }

        public String getContextInitParameter(String name) {
            return this.getServletContext().getInitParameter(name);
        }

        public String getContextPath() {
            return this._request.getContextPath();
        }

        public String getURL() {
            StringBuffer url = this._request.getRequestURL();
            String query = this._request.getQueryString();
            if (query != null) {
                url.append("?").append(query);
            }
            return url.toString();
        }

        public List<Locale> getLocales() {
            return Collections.list(this._request.getLocales());
        }

        public String getProtocol() {
            return this._request.getProtocol();
        }

        public boolean isSecure() {
            return this._request.isSecure();
        }
    }

    public static interface HttpScheduler
    extends AbstractServerTransport.Scheduler {
        public ServerMessage.Mutable getMessage();
    }

    protected abstract class LongPollScheduler
    implements Runnable,
    HttpScheduler,
    AsyncListener {
        private final Context context;
        private final Promise<Void> promise;
        private final ServerMessage.Mutable message;
        private final Scheduler.Task task;
        private final AtomicBoolean cancel;

        protected LongPollScheduler(Context context, Promise<Void> promise, ServerMessage.Mutable message, long timeout) {
            this.context = context;
            this.promise = promise;
            this.message = message;
            this.task = AbstractHttpTransport.this.getBayeux().schedule(this, timeout);
            this.cancel = new AtomicBoolean();
            AsyncContext asyncContext = AbstractHttpTransport.this.getAsyncContext(context.request);
            if (asyncContext != null) {
                asyncContext.addListener((AsyncListener)this);
            }
        }

        public Context getContext() {
            return this.context;
        }

        public Promise<Void> getPromise() {
            return this.promise;
        }

        @Override
        public ServerMessage.Mutable getMessage() {
            return this.message;
        }

        @Override
        public void schedule() {
            if (this.cancelTimeout()) {
                if (AbstractHttpTransport.this._logger.isDebugEnabled()) {
                    AbstractHttpTransport.this._logger.debug("Resuming /meta/connect after schedule");
                }
                this.resume(false);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelTimeout()) {
                if (AbstractHttpTransport.this._logger.isDebugEnabled()) {
                    AbstractHttpTransport.this._logger.debug("Cancelling {}", (Object)this.message);
                }
                this.error(new TimeoutException());
            }
        }

        @Override
        public void destroy() {
            this.cancel();
        }

        private boolean cancelTimeout() {
            boolean cancelled = this.cancel.compareAndSet(false, true);
            this.task.cancel();
            return cancelled;
        }

        @Override
        public void run() {
            if (this.cancelTimeout()) {
                this.context.session.setScheduler(null);
                if (AbstractHttpTransport.this._logger.isDebugEnabled()) {
                    AbstractHttpTransport.this._logger.debug("Resuming /meta/connect after timeout");
                }
                this.resume(true);
            }
        }

        private void resume(boolean timeout) {
            AbstractHttpTransport.this.decBrowserId(this.context.session, AbstractHttpTransport.this.isHTTP2(this.context.request));
            this.dispatch(timeout);
        }

        public void onStartAsync(AsyncEvent event) {
        }

        public void onTimeout(AsyncEvent event) {
        }

        public void onComplete(AsyncEvent asyncEvent) throws IOException {
        }

        public void onError(AsyncEvent event) {
            this.error(event.getThrowable());
        }

        protected abstract void dispatch(boolean var1);

        private void error(Throwable failure) {
            HttpServletRequest request = this.context.request;
            AbstractHttpTransport.this.decBrowserId(this.context.session, AbstractHttpTransport.this.isHTTP2(request));
            this.promise.fail(failure);
        }
    }
}

