/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="CometD cloud peer discovery component")
public class Seti
extends AbstractLifeCycle
implements Dumpable {
    public static final String SETI_ATTRIBUTE = Seti.class.getName();
    private static final String SETI_ALL_CHANNEL = "/seti/all";
    private static final List<String> PROTECTED_CHANNELS = Arrays.asList("/seti/**", "/seti/*");
    private final Map<String, Set<Location>> _uid2Location = new HashMap<String, Set<Location>>();
    private final List<PresenceListener> _presenceListeners = new CopyOnWriteArrayList<PresenceListener>();
    private final Oort.CometListener _cometListener = new CometListener();
    private final ServerChannel.SubscriptionListener _initialStateListener = new InitialStateListener();
    private final BayeuxServer.SubscriptionListener _allChannelsFilter = new AllChannelsFilter();
    private final Authorizer _authorizer = new SetiAuthorizer();
    private final Oort _oort;
    private final String _setiId;
    private final Logger _logger;
    private final LocalSession _session;

    public Seti(Oort oort) {
        this._oort = oort;
        this._setiId = this.generateSetiId(oort.getURL());
        this._logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + this._setiId));
        this._session = oort.getBayeuxServer().newLocalSession(this._setiId);
    }

    @ManagedAttribute(value="The Oort of this Seti", readonly=true)
    public Oort getOort() {
        return this._oort;
    }

    @ManagedAttribute(value="The unique ID of this Seti", readonly=true)
    public String getId() {
        return this._setiId;
    }

    protected void doStart() {
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        bayeux.addListener((BayeuxServer.BayeuxServerListener)this._allChannelsFilter);
        this._session.handshake();
        this.protectSetiChannels(bayeux);
        ServerChannel setiAllChannel = (ServerChannel)bayeux.createChannelIfAbsent(SETI_ALL_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        setiAllChannel.addListener((ConfigurableServerChannel.ServerChannelListener)this._initialStateListener);
        this._session.getChannel(SETI_ALL_CHANNEL).subscribe((channel, message) -> this.receiveBroadcast(message));
        this._oort.observeChannel(SETI_ALL_CHANNEL);
        String setiChannelName = this.generateSetiChannel(this._setiId);
        this._session.getChannel(setiChannelName).subscribe((channel, message) -> this.receiveDirect(message));
        this._oort.observeChannel(setiChannelName);
        this._oort.addCometListener(this._cometListener);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("{} started", (Object)this);
        }
    }

    protected void doStop() {
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        this.removeAssociationsAndPresences();
        this._presenceListeners.clear();
        this._oort.removeCometListener(this._cometListener);
        String setiChannelName = this.generateSetiChannel(this._setiId);
        this._oort.deobserveChannel(setiChannelName);
        this._oort.deobserveChannel(SETI_ALL_CHANNEL);
        ServerChannel setiAllChannel = bayeux.getChannel(SETI_ALL_CHANNEL);
        if (setiAllChannel != null) {
            setiAllChannel.removeListener((ConfigurableServerChannel.ServerChannelListener)this._initialStateListener);
        }
        this.unprotectSetiChannels(bayeux);
        this._session.disconnect();
        bayeux.removeListener((BayeuxServer.BayeuxServerListener)this._allChannelsFilter);
    }

    protected void protectSetiChannels(BayeuxServer bayeux) {
        PROTECTED_CHANNELS.forEach(name -> bayeux.createChannelIfAbsent(name, new ConfigurableServerChannel.Initializer[]{channel -> channel.addAuthorizer(this._authorizer)}));
    }

    protected void unprotectSetiChannels(BayeuxServer bayeux) {
        PROTECTED_CHANNELS.forEach(name -> {
            ServerChannel channel = bayeux.getChannel(name);
            if (channel != null) {
                channel.removeAuthorizer(this._authorizer);
            }
        });
    }

    protected String generateSetiId(String oortURL) {
        return Oort.replacePunctuation(oortURL, '_');
    }

    protected String generateSetiChannel(String setiId) {
        return "/seti/" + setiId;
    }

    public boolean associate(String userId, ServerSession session) {
        if (session == null) {
            throw new NullPointerException();
        }
        LocalLocation location = new LocalLocation(userId, session);
        boolean wasAssociated = this.isAssociated(userId);
        boolean added = this.associate(userId, location);
        if (added) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Associated {} to user {}", (Object)session, (Object)userId);
            }
            session.addListener((ServerSession.ServerSessionListener)location);
            session.setAttribute(LocalLocation.class.getName(), (Object)location);
            if (!wasAssociated) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Broadcasting association addition for user {}", (Object)userId);
                }
                this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)new SetiPresence(true, userId));
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean associate(String userId, Location location) {
        if (!this.isRunning()) {
            return false;
        }
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set locations = this._uid2Location.computeIfAbsent(userId, k -> new HashSet());
            boolean result = locations.add(location);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Associations: {}", (Object)this._uid2Location.size());
            }
            if (this._logger.isTraceEnabled()) {
                this._logger.trace("Associations: {}", this._uid2Location);
            }
            return result;
        }
    }

    private boolean associateRemote(String userId, SetiLocation location) {
        boolean associated = this.associate(userId, location);
        String oortURL = location._oortURL;
        if (associated && !this._oort.isCometConnected(oortURL)) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Disassociating {} since comet {} is not connected", (Object)userId, (Object)oortURL);
            }
            this.disassociate(userId, location);
            return false;
        }
        return associated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Whether the given userId is associated locally", impact="INFO")
    public boolean isAssociated(@Name(value="userId", description="The userId to test for local association") String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return false;
            }
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="The number of local associations for the given userId", impact="INFO")
    public int getAssociationCount(@Name(value="userId", description="The userId to test for local association count") String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations == null) {
                return 0;
            }
            int result = 0;
            for (Location location : locations) {
                if (!(location instanceof LocalLocation)) continue;
                ++result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Whether the given userId is present in the cloud", impact="INFO")
    public boolean isPresent(@Name(value="userId", description="The userId to test for presence in the cloud") String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            return locations != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="The number of local and remote associations for the given userId", impact="INFO")
    public int getPresenceCount(@Name(value="userId", description="The userId to test for presence count") String userId) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            return locations == null ? 0 : locations.size();
        }
    }

    public boolean disassociate(String userId, ServerSession session) {
        LocalLocation location = new LocalLocation(userId, session);
        boolean removed = this.disassociate(userId, location);
        if (removed) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Disassociated {} from user {}", (Object)session, (Object)userId);
            }
            location = (LocalLocation)session.removeAttribute(LocalLocation.class.getName());
            session.removeListener((ServerSession.ServerSessionListener)location);
            if (this._session.isConnected() && !this.isAssociated(userId)) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Broadcasting association removal for user {}", (Object)userId);
                }
                this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)new SetiPresence(false, userId));
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerSession> disassociate(String userId) {
        HashSet<LocalLocation> localLocations = new HashSet<LocalLocation>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> userLocations = this._uid2Location.get(userId);
            if (userLocations != null) {
                for (Location location : userLocations) {
                    if (!(location instanceof LocalLocation)) continue;
                    localLocations.add((LocalLocation)location);
                }
            }
        }
        HashSet<ServerSession> removedUserSessions = new HashSet<ServerSession>();
        for (LocalLocation location : localLocations) {
            ServerSession session = location._session;
            boolean removed = this.disassociate(userId, session);
            if (!removed) continue;
            removedUserSessions.add(session);
        }
        return removedUserSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean disassociate(String userId, Location location) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            boolean result = false;
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                result = locations.remove(location);
                if (locations.isEmpty()) {
                    this._uid2Location.remove(userId);
                }
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Associations: {}", (Object)this._uid2Location.size());
            }
            if (this._logger.isTraceEnabled()) {
                this._logger.trace("Associations: {}", this._uid2Location);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAssociationsAndPresences() {
        HashSet<String> userIds = new HashSet<String>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            this.getAssociatedUserIds(userIds);
            this._uid2Location.clear();
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Broadcasting association removal for users {}", userIds);
        }
        SetiPresence presence = new SetiPresence(Collections.emptySet());
        presence.put("alive", false);
        this._session.getChannel(SETI_ALL_CHANNEL).publish((Object)presence);
    }

    protected void removePresences(String oortURL) {
        Set<String> userIds = this.removeRemotePresences(oortURL);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Removing presences of comet {} for users {}", (Object)oortURL, userIds);
        }
        for (String userId : userIds) {
            this.notifyPresenceRemoved(oortURL, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> removeRemotePresences(String oortURL) {
        HashSet<String> userIds = new HashSet<String>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Iterator<Map.Entry<String, Set<Location>>> entries = this._uid2Location.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, Set<Location>> entry = entries.next();
                Set<Location> userLocations = entry.getValue();
                Iterator<Location> iterator = userLocations.iterator();
                while (iterator.hasNext()) {
                    Location location = iterator.next();
                    if (!(location instanceof SetiLocation) || !oortURL.equals(((SetiLocation)location)._oortURL)) continue;
                    iterator.remove();
                    userIds.add(entry.getKey());
                    break;
                }
                if (!userLocations.isEmpty()) continue;
                entries.remove();
            }
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="The set of userIds known to this Seti", readonly=true)
    public Set<String> getUserIds() {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            return new HashSet<String>(this._uid2Location.keySet());
        }
    }

    public Set<String> getAssociatedUserIds() {
        HashSet<String> result = new HashSet<String>();
        this.getAssociatedUserIds(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAssociatedUserIds(Set<String> result) {
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            block3: for (Map.Entry<String, Set<Location>> entry : this._uid2Location.entrySet()) {
                for (Location location : entry.getValue()) {
                    if (!(location instanceof LocalLocation)) continue;
                    result.add(entry.getKey());
                    continue block3;
                }
            }
        }
    }

    public void sendMessage(String toUserId, String toChannel, Object data) {
        this.sendMessage(Collections.singleton(toUserId), toChannel, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Collection<String> toUserIds, String toChannel, Object data) {
        for (String toUserId : toUserIds) {
            HashSet<Location> copy = new HashSet<Location>();
            Map<String, Set<Location>> map = this._uid2Location;
            synchronized (map) {
                Set<Location> locations = this._uid2Location.get(toUserId);
                if (locations == null) {
                    copy.add(new SetiLocation(toUserId, null));
                } else {
                    copy.addAll(locations);
                }
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Sending message to locations {}", copy);
            }
            for (Location location : copy) {
                location.send(toUserId, toChannel, data);
            }
        }
    }

    protected void receiveDirect(Message message) {
        Map data;
        Boolean presence;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received direct message {}", (Object)message);
        }
        if ((presence = (Boolean)(data = message.getDataAsMap()).get("presence")) != null) {
            this.receivePresence(data);
        } else {
            this.receiveMessage(data);
        }
    }

    protected void receiveBroadcast(Message message) {
        Map data;
        Boolean presence;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received broadcast message {}", (Object)message);
        }
        if ((presence = (Boolean)(data = message.getDataAsMap()).get("presence")) != null) {
            this.receivePresence(data);
        } else {
            this.receiveMessage(data);
        }
    }

    protected void receivePresence(Map<String, Object> presence) {
        String oortURL;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received presence message {}", presence);
        }
        if (this._setiId.equals(this.generateSetiId(oortURL = (String)presence.get("oortURL")))) {
            this.receiveLocalPresence(presence);
        } else {
            this.receiveRemotePresence(presence);
        }
    }

    protected void receiveLocalPresence(Map<String, Object> presence) {
        String oortURL = (String)presence.get("oortURL");
        boolean present = (Boolean)presence.get("presence");
        Set<String> userIds = this.convertPresenceUsers(presence);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Notifying presence listeners {}", presence);
        }
        for (String userId : userIds) {
            if (present) {
                this.notifyPresenceAdded(oortURL, userId);
                continue;
            }
            this.notifyPresenceRemoved(oortURL, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveRemotePresence(Map<String, Object> presence) {
        OortComet oortComet;
        String oortURL = (String)presence.get("oortURL");
        boolean present = (Boolean)presence.get("presence");
        boolean replace = presence.get("replace") == Boolean.TRUE;
        Set<String> userIds = this.convertPresenceUsers(presence);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received remote presence message from comet {} for {}", (Object)oortURL, userIds);
        }
        HashSet<String> added = new HashSet<String>();
        HashSet<String> removed = new HashSet<String>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            if (replace) {
                removed.addAll(this.removeRemotePresences(oortURL));
            }
            for (String userId : userIds) {
                SetiLocation location = new SetiLocation(userId, oortURL);
                if (present) {
                    if (!this.associateRemote(userId, location)) continue;
                    added.add(userId);
                    continue;
                }
                if (!this.disassociate(userId, location)) continue;
                removed.add(userId);
            }
        }
        HashSet toRemove = new HashSet(removed);
        toRemove.removeAll(added);
        for (String userId : toRemove) {
            this.notifyPresenceRemoved(oortURL, userId);
        }
        added.removeAll(removed);
        for (String userId : added) {
            this.notifyPresenceAdded(oortURL, userId);
        }
        if (presence.get("alive") == Boolean.TRUE && (oortComet = this._oort.findComet(oortURL)) != null) {
            Set<String> associatedUserIds = this.getAssociatedUserIds();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Pushing associated users {} to comet {}", associatedUserIds, (Object)oortURL);
            }
            ClientSessionChannel channel = oortComet.getChannel(this.generateSetiChannel(this.generateSetiId(oortURL)));
            channel.publish((Object)new SetiPresence(associatedUserIds));
        }
    }

    public void addPresenceListener(PresenceListener listener) {
        this._presenceListeners.add(listener);
    }

    public void removePresenceListener(PresenceListener listener) {
        this._presenceListeners.remove(listener);
    }

    public void removePresenceListeners() {
        this._presenceListeners.clear();
    }

    private void notifyPresenceAdded(String oortURL, String userId) {
        PresenceListener.Event event = new PresenceListener.Event(this, userId, oortURL);
        for (PresenceListener listener : this._presenceListeners) {
            try {
                listener.presenceAdded(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    private void notifyPresenceRemoved(String oortURL, String userId) {
        PresenceListener.Event event = new PresenceListener.Event(this, userId, oortURL);
        for (PresenceListener listener : this._presenceListeners) {
            try {
                listener.presenceRemoved(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveMessage(Map<String, Object> message) {
        String userId = (String)message.get("userId");
        String channel = (String)message.get("channel");
        Object data = message.get("data");
        HashSet<Location> copy = new HashSet<Location>();
        Map<String, Set<Location>> map = this._uid2Location;
        synchronized (map) {
            Set<Location> locations = this._uid2Location.get(userId);
            if (locations != null) {
                for (Location location : locations) {
                    if (!(location instanceof LocalLocation)) continue;
                    copy.add(location);
                }
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Received message {} for locations {}", message, copy);
        }
        for (Location location : copy) {
            location.receive(userId, channel, data);
        }
    }

    private Set<String> convertPresenceUsers(Map<String, Object> presence) {
        Object value = presence.get("userIds");
        if (value instanceof Set) {
            return (Set)value;
        }
        if (value instanceof Collection) {
            return new HashSet<String>((Collection)value);
        }
        if (value.getClass().isArray()) {
            HashSet<String> result = new HashSet<String>();
            for (Object item : (Object[])value) {
                result.add(item.toString());
            }
            return result;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        boolean detailed = ((BayeuxServerImpl)this.getOort().getBayeuxServer()).isDetailedDump();
        if (detailed) {
            List locations;
            Map<String, Set<Location>> map = this._uid2Location;
            synchronized (map) {
                locations = new TreeMap<String, Set<Location>>(this._uid2Location).entrySet().stream().map(entry -> new AbstractMap.SimpleEntry((String)entry.getKey(), new HashSet((Collection)entry.getValue()))).collect(Collectors.toList());
            }
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{new DumpableCollection("locations", locations)});
        } else {
            int size;
            Map<String, Set<Location>> map = this._uid2Location;
            synchronized (map) {
                size = this._uid2Location.size();
            }
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{"locations size=" + size});
        }
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getName(), this.getId());
    }

    private class SetiPresence
    extends HashMap<String, Object> {
        private static final String USER_IDS_FIELD = "userIds";
        private static final String OORT_URL_FIELD = "oortURL";
        private static final String ALIVE_FIELD = "alive";
        private static final String PRESENCE_FIELD = "presence";
        private static final String REPLACE_FIELD = "replace";

        private SetiPresence(boolean present, String userId) {
            this(present, Collections.singleton(userId), false);
        }

        private SetiPresence(Set<String> userIds) {
            this(true, userIds, true);
        }

        private SetiPresence(boolean present, Set<String> userIds, boolean replace) {
            super(4);
            this.put(USER_IDS_FIELD, userIds);
            this.put(OORT_URL_FIELD, Seti.this._oort.getURL());
            this.put(PRESENCE_FIELD, present);
            this.put(REPLACE_FIELD, replace);
        }
    }

    private class SetiMessage
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "userId";
        private static final String CHANNEL_FIELD = "channel";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String DATA_FIELD = "data";

        private SetiMessage(String toUser, String toChannel, Object data) {
            super(4);
            this.put(USER_ID_FIELD, toUser);
            this.put(CHANNEL_FIELD, toChannel);
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(DATA_FIELD, data);
        }
    }

    private class CometListener
    implements Oort.CometListener {
        private CometListener() {
        }

        @Override
        public void cometJoined(Oort.CometListener.Event event) {
            String oortURL = event.getCometURL();
            OortComet oortComet = Seti.this._oort.findComet(oortURL);
            if (Seti.this._logger.isDebugEnabled()) {
                Seti.this._logger.debug("Comet joined: {} with {}", (Object)oortURL, (Object)oortComet);
            }
            if (oortComet != null) {
                ClientSessionChannel channel = oortComet.getChannel(Seti.this.generateSetiChannel(Seti.this.generateSetiId(oortURL)));
                Set<String> userIds = Seti.this.getAssociatedUserIds();
                if (Seti.this._logger.isDebugEnabled()) {
                    Seti.this._logger.debug("Pushing associated users {} to comet {}", userIds, (Object)oortURL);
                }
                channel.publish((Object)new SetiPresence(userIds));
            }
        }

        @Override
        public void cometLeft(Oort.CometListener.Event event) {
            String oortURL = event.getCometURL();
            if (Seti.this._logger.isDebugEnabled()) {
                Seti.this._logger.debug("Comet left: {}", (Object)oortURL);
            }
            Seti.this.removePresences(oortURL);
        }
    }

    private class InitialStateListener
    implements ServerChannel.SubscriptionListener {
        private InitialStateListener() {
        }

        public void subscribed(ServerSession session, ServerChannel channel, ServerMessage message) {
            if (!session.isLocalSession()) {
                Set<String> associatedUserIds = Seti.this.getAssociatedUserIds();
                if (Seti.this._logger.isDebugEnabled()) {
                    Seti.this._logger.debug("Broadcasting associated users {}", associatedUserIds);
                }
                SetiPresence presence = new SetiPresence(associatedUserIds);
                presence.put("alive", true);
                session.deliver((Session)Seti.this._session, Seti.SETI_ALL_CHANNEL, (Object)presence, Promise.noop());
            }
        }
    }

    private class AllChannelsFilter
    implements BayeuxServer.SubscriptionListener,
    ServerSession.MessageListener {
        private AllChannelsFilter() {
        }

        public void subscribed(ServerSession session, ServerChannel channel, ServerMessage message) {
            if ("/**".equals(channel.getId()) && !session.isLocalSession()) {
                session.addListener((ServerSession.ServerSessionListener)this);
            }
        }

        public boolean onMessage(ServerSession session, ServerSession sender, ServerMessage message) {
            if (message.getChannel().startsWith("/seti/")) {
                if (Seti.this._logger.isDebugEnabled()) {
                    Seti.this._logger.debug("Dropping Seti message {} to channel '/**' subscriber {}", (Object)message, (Object)session);
                }
                return false;
            }
            return true;
        }
    }

    private class SetiAuthorizer
    implements Authorizer {
        private SetiAuthorizer() {
        }

        public Authorizer.Result authorize(Authorizer.Operation operation, ChannelId channel, ServerSession session, ServerMessage message) {
            if (session.isLocalSession() || Seti.this.getOort().isOort(session)) {
                return Authorizer.Result.grant();
            }
            return Authorizer.Result.ignore();
        }
    }

    protected class LocalLocation
    implements Location,
    ServerSession.RemovedListener {
        private final String _userId;
        private final ServerSession _session;

        protected LocalLocation(String userId, ServerSession session) {
            this._userId = userId;
            this._session = session;
        }

        @Override
        public void send(String toUser, String toChannel, Object data) {
            this._session.deliver((Session)Seti.this._session, toChannel, data, Promise.noop());
        }

        @Override
        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public void removed(ServerSession session, ServerMessage message, boolean timeout) {
            Seti.this.disassociate(this._userId, session);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocalLocation)) {
                return false;
            }
            LocalLocation that = (LocalLocation)obj;
            return this._userId.equals(that._userId) && this._session.getId().equals(that._session.getId());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this._userId, this._session.getId());
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this._session);
        }
    }

    protected static interface Location {
        public void send(String var1, String var2, Object var3);

        public void receive(String var1, String var2, Object var3);

        public int hashCode();

        public boolean equals(Object var1);
    }

    protected class SetiLocation
    implements Location {
        private final String _userId;
        private final String _oortURL;
        private final String _setiChannel;

        protected SetiLocation(String userId, String oortURL) {
            this._userId = userId;
            this._oortURL = oortURL;
            this._setiChannel = oortURL == null ? Seti.SETI_ALL_CHANNEL : Seti.this.generateSetiChannel(Seti.this.generateSetiId(oortURL));
        }

        @Override
        public void send(String toUser, String toChannel, Object data) {
            Seti.this._session.getChannel(this._setiChannel).publish((Object)new SetiMessage(toUser, toChannel, data));
        }

        @Override
        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SetiLocation)) {
                return false;
            }
            SetiLocation that = (SetiLocation)obj;
            return this._userId.equals(that._userId) && this._setiChannel.equals(that._setiChannel);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this._userId, this._setiChannel);
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this._setiChannel);
        }
    }

    public static interface PresenceListener
    extends EventListener {
        default public void presenceAdded(Event event) {
        }

        default public void presenceRemoved(Event event) {
        }

        public static class Event
        extends EventObject {
            private final String userId;
            private final String url;

            public Event(Seti source, String userId, String url) {
                super((Object)source);
                this.userId = userId;
                this.url = url;
            }

            public Seti getSeti() {
                return (Seti)((Object)this.getSource());
            }

            public String getUserId() {
                return this.userId;
            }

            public String getOortURL() {
                return this.url;
            }

            public boolean isLocal() {
                return this.getSeti().getOort().getURL().equals(this.getOortURL());
            }

            @Override
            public String toString() {
                return String.format("%s[%s %s on %s]", new Object[]{this.getClass().getName(), this.getUserId(), this.isLocal() ? "local" : "remote", this.getSeti()});
            }
        }
    }
}

