/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux.server;

import java.util.List;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;

public interface BayeuxServer
extends Bayeux {
    public static final String ATTRIBUTE = "org.cometd.bayeux";

    public void addExtension(Extension var1);

    public void removeExtension(Extension var1);

    public List<Extension> getExtensions();

    public void addListener(BayeuxServerListener var1);

    public void removeListener(BayeuxServerListener var1);

    public ServerChannel getChannel(String var1);

    public List<ServerChannel> getChannels();

    public MarkedReference<ServerChannel> createChannelIfAbsent(String var1, ConfigurableServerChannel.Initializer ... var2);

    public ServerSession getSession(String var1);

    public List<ServerSession> getSessions();

    public boolean removeSession(ServerSession var1);

    public LocalSession newLocalSession(String var1);

    public ServerMessage.Mutable newMessage();

    public SecurityPolicy getSecurityPolicy();

    public void setSecurityPolicy(SecurityPolicy var1);

    public static interface Extension {
        default public void incoming(ServerSession from, ServerMessage.Mutable message, Promise<Boolean> promise) {
            promise.succeed(message.isMeta() ? this.rcvMeta(from, message) : this.rcv(from, message));
        }

        default public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
            return true;
        }

        default public boolean rcvMeta(ServerSession from, ServerMessage.Mutable message) {
            return true;
        }

        default public void outgoing(ServerSession from, ServerSession to, ServerMessage.Mutable message, Promise<Boolean> promise) {
            promise.succeed(message.isMeta() ? this.sendMeta(to, message) : this.send(from, to, message));
        }

        default public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
            return true;
        }

        default public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
            return true;
        }

        @Deprecated
        public static class Adapter
        implements Extension {
        }
    }

    public static interface SubscriptionListener
    extends BayeuxServerListener {
        public void subscribed(ServerSession var1, ServerChannel var2, ServerMessage var3);

        public void unsubscribed(ServerSession var1, ServerChannel var2, ServerMessage var3);
    }

    public static interface SessionListener
    extends BayeuxServerListener {
        public void sessionAdded(ServerSession var1, ServerMessage var2);

        public void sessionRemoved(ServerSession var1, boolean var2);
    }

    public static interface ChannelListener
    extends BayeuxServerListener,
    ConfigurableServerChannel.Initializer {
        public void channelAdded(ServerChannel var1);

        public void channelRemoved(String var1);
    }

    public static interface BayeuxServerListener
    extends Bayeux.BayeuxListener {
    }
}

