/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.codejargon.fluentjdbc.api.FluentJdbc;
import org.codejargon.fluentjdbc.api.ParamSetter;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.integration.providers.DataSourceConnectionProvider;
import org.codejargon.fluentjdbc.api.query.SqlErrorHandler;
import org.codejargon.fluentjdbc.api.query.Transaction;
import org.codejargon.fluentjdbc.api.query.listen.AfterQueryListener;
import org.codejargon.fluentjdbc.internal.FluentJdbcInternal;
import org.codejargon.fluentjdbc.internal.query.DefaultSqlHandler;
import org.codejargon.fluentjdbc.internal.query.QueryConfig;
import org.codejargon.fluentjdbc.internal.support.Maps;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

public class FluentJdbcBuilder {
    private Optional<Integer> defaultFetchSize = Optional.empty();
    private Optional<Integer> defaultBatchSize = Optional.empty();
    private Optional<ConnectionProvider> connectionProvider = Optional.empty();
    private Optional<AfterQueryListener> afterQueryListener = Optional.empty();
    private Optional<Transaction.Isolation> defaultTransactionIsolation = Optional.empty();
    private SqlErrorHandler defaultSqlErrorHandler = new DefaultSqlHandler();
    private Map<Class, ParamSetter> paramSetters = Maps.copyOf(new HashMap());

    public FluentJdbcBuilder connectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = Optional.of(Preconditions.checkNotNull(connectionProvider, "connectionProvider"));
        return this;
    }

    public FluentJdbcBuilder connectionProvider(DataSource dataSource) {
        return this.connectionProvider(new DataSourceConnectionProvider(dataSource));
    }

    public FluentJdbcBuilder paramSetters(Map<Class, ParamSetter> map) {
        this.paramSetters = Preconditions.checkNotNull(map, "paramSetters");
        return this;
    }

    public FluentJdbcBuilder defaultFetchSize(Integer n) {
        Preconditions.checkArgument(Preconditions.checkNotNull(n, "rows") >= 0, "Fetch size rows must be >= 0");
        this.defaultFetchSize = Optional.of(n);
        return this;
    }

    public FluentJdbcBuilder defaultBatchSize(Integer n) {
        Preconditions.checkArgument(Preconditions.checkNotNull(n, "size") >= 0, "Batch size rows must be >= 0");
        this.defaultBatchSize = Optional.of(n);
        return this;
    }

    public FluentJdbcBuilder defaultTransactionIsolation(Transaction.Isolation isolation) {
        this.defaultTransactionIsolation = Optional.of(Preconditions.checkNotNull(isolation, "isolation"));
        return this;
    }

    public FluentJdbcBuilder defaultSqlHandler(SqlErrorHandler sqlErrorHandler) {
        this.defaultSqlErrorHandler = sqlErrorHandler;
        return this;
    }

    public FluentJdbcBuilder afterQueryListener(AfterQueryListener afterQueryListener) {
        this.afterQueryListener = Optional.of(afterQueryListener);
        return this;
    }

    public FluentJdbc build() {
        return new FluentJdbcInternal(this.connectionProvider, new QueryConfig(this.defaultFetchSize, this.defaultBatchSize, Maps.copyOf(this.paramSetters), this.afterQueryListener, this.defaultTransactionIsolation, this.defaultSqlErrorHandler));
    }
}

