/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query.namedparameter;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;

public class NamedTransformedSqlFactory {
    final Map<String, NamedTransformedSql> namedParamSqlCacheNoCollections = Collections.synchronizedMap(new WeakHashMap());
    final Map<Map<String, Integer>, NamedTransformedSql> namedParamCacheWithCollections = Collections.synchronizedMap(new WeakHashMap());

    public NamedTransformedSql create(String string, Map<String, ?> map) {
        if (NamedTransformedSqlFactory.hasCollection(map)) {
            Map<String, Integer> map2 = this.collectionParamCacheKey(map);
            NamedTransformedSql namedTransformedSql = this.namedParamCacheWithCollections.get(map2);
            if (namedTransformedSql == null) {
                namedTransformedSql = NamedTransformedSql.forSqlAndParams(string, map);
                this.namedParamCacheWithCollections.put(map2, namedTransformedSql);
            }
            return namedTransformedSql;
        }
        NamedTransformedSql namedTransformedSql = this.namedParamSqlCacheNoCollections.get(string);
        if (namedTransformedSql == null) {
            namedTransformedSql = NamedTransformedSql.forSqlAndParams(string, map);
            this.namedParamSqlCacheNoCollections.put(string, namedTransformedSql);
        }
        return namedTransformedSql;
    }

    public static boolean hasCollection(Map<String, ?> map) {
        return map.values().stream().filter(object -> object instanceof Collection).findFirst().isPresent();
    }

    private Map<String, Integer> collectionParamCacheKey(Map<String, ?> map) {
        return Collections.unmodifiableMap(new TreeMap(map).entrySet().stream().filter(entry -> entry.getValue() instanceof Collection).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).size())));
    }
}

