/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codejargon.fluentjdbc.api.ParamSetter;

class DefaultParamSetters {
    private static final Map<Class, ParamSetter> setters;

    DefaultParamSetters() {
    }

    private static void javaTime(Map<Class, ParamSetter> map) {
        DefaultParamSetters.reg(map, Instant.class, (instant, preparedStatement, n) -> preparedStatement.setTimestamp(n, DefaultParamSetters.timestamp(instant)));
        DefaultParamSetters.reg(map, OffsetDateTime.class, (offsetDateTime, preparedStatement, n) -> preparedStatement.setTimestamp(n, DefaultParamSetters.timestamp(offsetDateTime.toInstant())));
        DefaultParamSetters.reg(map, ZonedDateTime.class, (zonedDateTime, preparedStatement, n) -> preparedStatement.setTimestamp(n, DefaultParamSetters.timestamp(zonedDateTime.toInstant())));
        DefaultParamSetters.reg(map, LocalDate.class, (localDate, preparedStatement, n) -> preparedStatement.setDate(n, java.sql.Date.valueOf(localDate)));
        DefaultParamSetters.reg(map, LocalTime.class, (localTime, preparedStatement, n) -> preparedStatement.setTime(n, Time.valueOf(localTime)));
        DefaultParamSetters.reg(map, LocalDateTime.class, (localDateTime, preparedStatement, n) -> preparedStatement.setTimestamp(n, Timestamp.valueOf(localDateTime)));
        DefaultParamSetters.reg(map, Year.class, (year, preparedStatement, n) -> preparedStatement.setDate(n, java.sql.Date.valueOf(LocalDate.of(year.getValue(), Month.JANUARY, 1))));
        DefaultParamSetters.reg(map, YearMonth.class, (yearMonth, preparedStatement, n) -> preparedStatement.setDate(n, java.sql.Date.valueOf(LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1))));
    }

    private static void javaDate(Map<Class, ParamSetter> map) {
        DefaultParamSetters.reg(map, Date.class, (date, preparedStatement, n) -> preparedStatement.setTimestamp(n, new Timestamp(date.getTime())));
    }

    static Map<Class, ParamSetter> setters() {
        return setters;
    }

    private static Timestamp timestamp(Instant instant) {
        return Timestamp.from(instant);
    }

    private static <T> void reg(Map<Class, ParamSetter> map, Class<T> clazz, ParamSetter<T> paramSetter) {
        map.put(clazz, paramSetter);
    }

    static {
        HashMap<Class, ParamSetter> hashMap = new HashMap<Class, ParamSetter>();
        DefaultParamSetters.javaDate(hashMap);
        DefaultParamSetters.javaTime(hashMap);
        setters = Collections.unmodifiableMap(hashMap);
    }
}

