/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codejargon.fluentjdbc.internal.query.QueryConfig;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.QueryRunnerPreparedStatement;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;
import org.codejargon.fluentjdbc.internal.query.namedparameter.SqlAndParamsForNamed;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

abstract class SingleQueryBase {
    protected final String sql;
    protected final QueryInternal query;
    protected final List<Object> params = new ArrayList<Object>(0);
    protected final Map<String, Object> namedParams = new HashMap<String, Object>(0);

    protected SingleQueryBase(QueryInternal queryInternal, String string) {
        this.query = queryInternal;
        this.sql = string;
    }

    protected void addParameters(List<?> list) {
        Preconditions.checkArgument(this.namedParams.isEmpty(), "Can not add positional parameters if named parameters are set.");
        this.params.addAll(list);
    }

    protected void addParameters(Object ... objectArray) {
        this.addParameters(Arrays.asList(objectArray));
    }

    protected void addNamedParameters(Map<String, ?> map) {
        Preconditions.checkArgument(this.params.isEmpty(), "Can not add named parameters if positional parameters are set.");
        this.namedParams.putAll(map);
    }

    protected void addNamedParameter(String string, Object object) {
        this.namedParams.put(string, object);
    }

    protected <T> T runQuery(QueryRunnerPreparedStatement<T> queryRunnerPreparedStatement) {
        return this.runQuery(queryRunnerPreparedStatement, false);
    }

    protected <T> T runQueryAndFetch(QueryRunnerPreparedStatement<T> queryRunnerPreparedStatement) {
        return this.runQuery(queryRunnerPreparedStatement, true);
    }

    private <T> T runQuery(QueryRunnerPreparedStatement<T> queryRunnerPreparedStatement, boolean bl) {
        return (T)this.query.query(connection -> {
            try (PreparedStatement preparedStatement = this.query.preparedStatementFactory.createSingle(connection, this, bl);){
                Object t = queryRunnerPreparedStatement.run(preparedStatement);
                return t;
            }
        }, Optional.of(this.sql));
    }

    SqlAndParams sqlAndParams(QueryConfig queryConfig) {
        return this.namedParams.isEmpty() ? new SqlAndParams(this.sql, this.params) : SqlAndParamsForNamed.create(queryConfig.namedTransformedSql(this.sql), this.namedParams);
    }

    abstract void customizeQuery(PreparedStatement var1, QueryConfig var2) throws SQLException;
}

