/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.FluentJdbcSqlException;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.query.Transaction;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;

class TransactionInternal
implements Transaction {
    private static ThreadLocal<Map<ConnectionProvider, Connection>> connections = new ThreadLocal();
    private final QueryInternal queryInternal;
    private Optional<Transaction.Isolation> isolation = Optional.empty();

    TransactionInternal(QueryInternal queryInternal) {
        this.queryInternal = queryInternal;
    }

    @Override
    public Transaction isolation(Transaction.Isolation isolation) {
        this.isolation = Optional.of(isolation);
        return this;
    }

    @Override
    public <T> T in(Supplier<T> operation) {
        Map<ConnectionProvider, Connection> cons = this.connections();
        Optional<Connection> transactionConnection = Optional.ofNullable(cons.get(this.queryInternal.connectionProvider));
        return !transactionConnection.isPresent() ? this.inNewTransaction(operation, cons) : operation.get();
    }

    @Override
    public void inNoResult(Runnable runnable) {
        this.in(() -> {
            runnable.run();
            return null;
        });
    }

    private <T> T inNewTransaction(Supplier<T> operation, Map<ConnectionProvider, Connection> cons) {
        try {
            ArrayList result = new ArrayList(1);
            this.queryInternal.connectionProvider.provide(con -> {
                Boolean originalAutocommit = null;
                try {
                    this.isolation(con);
                    originalAutocommit = con.getAutoCommit();
                    cons.put(this.queryInternal.connectionProvider, con);
                    try {
                        result.add(operation.get());
                    }
                    catch (Exception e) {
                        con.rollback();
                        throw new FluentJdbcException("Exception while executing transactioned operation. Rolling back.", e);
                    }
                    con.commit();
                }
                catch (SQLException e) {
                    throw new FluentJdbcSqlException("Error executing transaction", e);
                }
                finally {
                    try {
                        if (originalAutocommit != null && originalAutocommit.booleanValue()) {
                            con.setAutoCommit(true);
                        }
                    }
                    catch (SQLException sQLException) {}
                    this.removeTransactionedConnection(cons);
                }
            });
            return (T)result.get(0);
        }
        catch (SQLException e) {
            throw new FluentJdbcSqlException("Error executing transaction.", e);
        }
    }

    private void isolation(Connection con) throws SQLException {
        if (this.isolation.isPresent()) {
            con.setTransactionIsolation(this.isolation.get().jdbcIsolation());
        }
    }

    private Map<ConnectionProvider, Connection> connections() {
        Map<ConnectionProvider, Connection> cons = connections.get();
        if (cons == null) {
            cons = new HashMap<ConnectionProvider, Connection>(4);
            connections.set(cons);
        }
        return cons;
    }

    private void removeTransactionedConnection(Map<ConnectionProvider, Connection> cons) {
        cons.remove(this.queryInternal.connectionProvider);
        if (cons.isEmpty()) {
            connections.remove();
        }
    }

    static Optional<Connection> transactionedConnection(ConnectionProvider connectionProvider) throws SQLException {
        Optional<Connection> connection;
        Optional<Connection> optional = connection = connections.get() != null ? Optional.ofNullable(connections.get().get(connectionProvider)) : Optional.empty();
        if (connection.isPresent() && ((Connection)connection.get()).getAutoCommit()) {
            connection.get().setAutoCommit(false);
        }
        return connection;
    }
}

