/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query.namedparameter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.internal.query.namedparameter.ParsedSql;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

abstract class NamedParameterUtils {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};

    NamedParameterUtils() {
    }

    static ParsedSql parseSqlStatement(String string) {
        Preconditions.checkNotNull(string, "SQL must not be null");
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = string;
        ArrayList<ParameterHolder> arrayList = new ArrayList<ParameterHolder>();
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            int n6;
            int n7;
            while (n5 < cArray.length && n5 != (n7 = NamedParameterUtils.skipCommentsAndQuotes(cArray, n5))) {
                n5 = n7;
            }
            if (n5 >= cArray.length) break;
            char c = cArray[n5];
            if (c == ':' || c == '&') {
                String string3;
                n6 = n5 + 1;
                if (n6 < cArray.length && cArray[n6] == ':' && c == ':') {
                    n5 += 2;
                    continue;
                }
                if (n6 < cArray.length && c == ':' && cArray[n6] == '{') {
                    while (n6 < cArray.length && '}' != cArray[n6]) {
                        if (':' != cArray[++n6] && '{' != cArray[n6]) continue;
                        throw new FluentJdbcException("Parameter name contains invalid character '" + cArray[n6] + "' at position " + n5 + " in statement: " + string);
                    }
                    if (n6 >= cArray.length) {
                        throw new FluentJdbcException("Non-terminated named parameter declaration at position " + n5 + " in statement: " + string);
                    }
                    if (n6 - n5 > 3) {
                        string3 = string.substring(n5 + 2, n6);
                        n = NamedParameterUtils.addNewNamedParameter(hashSet, n, string3);
                        n3 = NamedParameterUtils.addNamedParameter(arrayList, n3, n4, n5, n6 + 1, string3);
                    }
                    ++n6;
                } else {
                    while (n6 < cArray.length && !NamedParameterUtils.isParameterSeparator(cArray[n6])) {
                        ++n6;
                    }
                    if (n6 - n5 > 1) {
                        string3 = string.substring(n5 + 1, n6);
                        n = NamedParameterUtils.addNewNamedParameter(hashSet, n, string3);
                        n3 = NamedParameterUtils.addNamedParameter(arrayList, n3, n4, n5, n6, string3);
                    }
                }
                n5 = n6 - 1;
            } else {
                if (c == '\\' && (n6 = n5 + 1) < cArray.length && cArray[n6] == ':') {
                    string2 = string2.substring(0, n5 - n4) + string2.substring(n5 - n4 + 1);
                    ++n4;
                    n5 += 2;
                    continue;
                }
                if (c == '?') {
                    ++n2;
                    ++n3;
                }
            }
            ++n5;
        }
        ParsedSql parsedSql = new ParsedSql(string2);
        for (ParameterHolder parameterHolder : arrayList) {
            parsedSql.addNamedParameter(parameterHolder.getParameterName(), parameterHolder.getStartIndex(), parameterHolder.getEndIndex());
        }
        parsedSql.setNamedParameterCount(n);
        parsedSql.setUnnamedParameterCount(n2);
        parsedSql.setTotalParameterCount(n3);
        return parsedSql;
    }

    private static int addNamedParameter(List<ParameterHolder> list, int n, int n2, int n3, int n4, String string) {
        list.add(new ParameterHolder(string, n3 - n2, n4 - n2));
        return ++n;
    }

    private static int addNewNamedParameter(Set<String> set, int n, String string) {
        if (!set.contains(string)) {
            set.add(string);
            ++n;
        }
        return n;
    }

    private static int skipCommentsAndQuotes(char[] cArray, int n) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            int n2;
            if (cArray[n] != START_SKIP[i].charAt(0)) continue;
            boolean bl = true;
            for (n2 = 1; n2 < START_SKIP[i].length(); ++n2) {
                if (cArray[n + n2] == START_SKIP[i].charAt(n2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            n2 = START_SKIP[i].length();
            for (int j = n + n2; j < cArray.length; ++j) {
                if (cArray[j] != STOP_SKIP[i].charAt(0)) continue;
                boolean bl2 = true;
                int n3 = j;
                for (int k = 1; k < STOP_SKIP[i].length(); ++k) {
                    if (j + k >= cArray.length) {
                        return cArray.length;
                    }
                    if (cArray[j + k] != STOP_SKIP[i].charAt(k)) {
                        bl2 = false;
                        break;
                    }
                    n3 = j + k;
                }
                if (!bl2) continue;
                return n3 + 1;
            }
            return cArray.length;
        }
        return n;
    }

    static String substituteNamedParameters(ParsedSql parsedSql) {
        String string = parsedSql.getOriginalSql();
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = parsedSql.getParameterNames();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray = parsedSql.getParameterIndexes(i);
            int n2 = nArray[0];
            int n3 = nArray[1];
            stringBuilder.append(string, n, n2);
            stringBuilder.append("?");
            n = n3;
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    static Object[] buildValueArray(ParsedSql parsedSql, Map<String, ?> map) {
        Object[] objectArray = new Object[parsedSql.getTotalParameterCount()];
        if (parsedSql.getNamedParameterCount() > 0 && parsedSql.getUnnamedParameterCount() > 0) {
            throw new FluentJdbcException("Not allowed to mix named and traditional ? placeholders. You have " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + parsedSql.getUnnamedParameterCount() + " traditional placeholder(s) in statement: " + parsedSql.getOriginalSql());
        }
        List<String> list = parsedSql.getParameterNames();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!map.containsKey(string)) {
                throw new FluentJdbcException(String.format("Named parameter not set: %s", string));
            }
            objectArray[i] = map.get(string);
        }
        return objectArray;
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char c2 : PARAMETER_SEPARATORS) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    private static class ParameterHolder {
        private final String parameterName;
        private final int startIndex;
        private final int endIndex;

        public ParameterHolder(String string, int n, int n2) {
            this.parameterName = string;
            this.startIndex = n;
            this.endIndex = n2;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

