/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codejargon.fluentjdbc.api.query.BatchQuery;
import org.codejargon.fluentjdbc.api.query.UpdateResult;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;
import org.codejargon.fluentjdbc.internal.query.UpdateResultInternal;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedSqlAndParams;
import org.codejargon.fluentjdbc.internal.query.namedparameter.TransformedSql;
import org.codejargon.fluentjdbc.internal.support.Ints;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

class BatchQueryInternal
implements BatchQuery {
    private final String sql;
    private final QueryInternal query;
    private Optional<Iterator<List<Object>>> params = Optional.empty();
    private Optional<Iterator<Map<String, Object>>> namedParams = Optional.empty();
    private Optional<Integer> batchSize = Optional.empty();

    public BatchQueryInternal(String sql, QueryInternal query) {
        this.sql = sql;
        this.query = query;
    }

    @Override
    public BatchQuery params(Iterator<List<Object>> params) {
        Preconditions.checkNotNull(params, "params");
        Preconditions.checkArgument(!this.namedParams.isPresent(), "Positional parameters can't be set if named parameters are already set.");
        this.params = Optional.of(params);
        return this;
    }

    @Override
    public BatchQuery namedParams(Iterator<Map<String, Object>> namedParams) {
        Preconditions.checkNotNull(namedParams, "namedParams");
        Preconditions.checkArgument(!this.params.isPresent(), "Named parameters can't be set if positional parameters are already set.");
        this.namedParams = Optional.of(namedParams);
        return this;
    }

    @Override
    public BatchQuery batchSize(Integer batchSize) {
        Preconditions.checkNotNull(batchSize, "batch size");
        Preconditions.checkArgument(batchSize > 0, "batch size must be greater than 0");
        this.batchSize = Optional.of(batchSize);
        return this;
    }

    @Override
    public List<UpdateResult> run() {
        Preconditions.checkArgument(this.params.isPresent() || this.namedParams.isPresent(), "Parameters must be set to run a batch query");
        return this.params.isPresent() ? this.positional() : this.named();
    }

    private List<UpdateResult> positional() {
        return this.query.query(connection -> {
            try (PreparedStatement statement = connection.prepareStatement(this.sql);){
                int i = 0;
                ArrayList<UpdateResult> updateResults = new ArrayList<UpdateResult>();
                while (this.params.get().hasNext()) {
                    i = this.assignParamAndRunBatchWhenNeeded(statement, i, updateResults, this.params.get().next());
                }
                updateResults.addAll(this.runBatch(statement));
                List list = Collections.unmodifiableList(updateResults);
                return list;
            }
        }, this.sql);
    }

    private List<UpdateResult> named() {
        return this.query.query(connection -> {
            TransformedSql transformedSql = this.query.config.transformedSql(this.sql);
            try (PreparedStatement statement = connection.prepareStatement(transformedSql.sql());){
                int i = 0;
                ArrayList<UpdateResult> updateResults = new ArrayList<UpdateResult>();
                while (this.namedParams.get().hasNext()) {
                    Map<String, Object> namedParamElement = this.namedParams.get().next();
                    SqlAndParams sqlAndParams = NamedSqlAndParams.sqlAndParams(transformedSql, namedParamElement);
                    i = this.assignParamAndRunBatchWhenNeeded(statement, i, updateResults, sqlAndParams.params());
                }
                updateResults.addAll(this.runBatch(statement));
                List list = Collections.unmodifiableList(updateResults);
                return list;
            }
        }, this.sql);
    }

    private int assignParamAndRunBatchWhenNeeded(PreparedStatement statement, int i, List<UpdateResult> updateResults, List<Object> params) throws SQLException {
        this.query.assignParams(statement, params);
        statement.addBatch();
        if (this.batchSize.isPresent() && ++i % this.batchSize.get() == 0) {
            updateResults.addAll(this.runBatch(statement));
        }
        return i;
    }

    private List<UpdateResult> runBatch(PreparedStatement statement) throws SQLException {
        List<Integer> updateds = Ints.asList(statement.executeBatch());
        return Collections.unmodifiableList(updateds.stream().map(i -> (long)i).map(UpdateResultInternal::new).collect(Collectors.toList()));
    }
}

