/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.codejargon.fluentjdbc.api.query.Mapper;
import org.codejargon.fluentjdbc.api.query.SelectQuery;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.SingleQueryBase;
import org.codejargon.fluentjdbc.internal.query.SingleQuerySpecification;
import org.codejargon.fluentjdbc.internal.support.Preconditions;
import org.codejargon.fluentjdbc.internal.support.Predicates;

class SelectQueryInternal
extends SingleQueryBase
implements SelectQuery {
    private Predicate filter = Predicates.alwaysTrue();
    private Optional<Integer> fetchSize = Optional.empty();
    private Optional<Long> maxRows = Optional.empty();

    SelectQueryInternal(String sql, QueryInternal query) {
        super(query, sql);
    }

    @Override
    public <T> SelectQuery filter(Predicate<T> filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public SelectQuery fetchSize(Integer rows) {
        Preconditions.checkNotNull(rows, "rows");
        Preconditions.checkArgument(rows >= 0, "Fetch size rows must be >= 0");
        this.fetchSize = Optional.of(rows);
        return this;
    }

    @Override
    public SelectQuery maxRows(Long rows) {
        Preconditions.checkNotNull(rows, "rows");
        Preconditions.checkArgument(rows >= 0L, "Max results rows must be >= 0");
        this.maxRows = Optional.of(rows);
        return this;
    }

    @Override
    public SelectQuery params(List<Object> params) {
        this.addParameters(params);
        return this;
    }

    @Override
    public SelectQuery params(Object ... params) {
        this.addParameters(params);
        return this;
    }

    @Override
    public SelectQuery namedParams(Map<String, Object> namedParams) {
        this.addNamedParameters(namedParams);
        return this;
    }

    @Override
    public <T> Optional<T> firstResult(Mapper<T> mapper) {
        return this.runQuery(this.querySpecs(), ps -> {
            try (ResultSet rs = ps.executeQuery();){
                Optional result = Optional.empty();
                while (rs.next() && !result.isPresent()) {
                    Object candidate = mapper.map(rs);
                    if (!this.filter.test(candidate)) continue;
                    result = Optional.of(candidate);
                }
                Optional optional = result;
                return optional;
            }
        });
    }

    @Override
    public <T> T singleResult(Mapper<T> mapper) {
        Optional<T> firstResult = this.firstResult(mapper);
        if (!firstResult.isPresent()) {
            throw this.query.queryException(this.sql, Optional.of("At least one result expected"), Optional.empty());
        }
        return firstResult.get();
    }

    @Override
    public <T> List<T> listResult(Mapper<T> mapper) {
        ArrayList results = new ArrayList();
        this.iterateResult(mapper, results::add);
        return Collections.unmodifiableList(results);
    }

    @Override
    public <T> Set<T> setResult(Mapper<T> mapper) {
        HashSet results = new HashSet();
        this.iterateResult(mapper, results::add);
        return Collections.unmodifiableSet(results);
    }

    @Override
    public <T> void iterateResult(Mapper<T> mapper, Consumer<T> consumer) {
        this.runQuery(this.querySpecs(), ps -> {
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Object candidate = mapper.map(rs);
                    if (!this.filter.test(candidate)) continue;
                    consumer.accept(candidate);
                }
            }
            return null;
        });
    }

    private SingleQuerySpecification querySpecs() {
        return SingleQuerySpecification.forSelect(this);
    }

    Optional<Integer> fetchSize() {
        return this.fetchSize;
    }

    Optional<Long> maxRows() {
        return this.maxRows;
    }
}

