/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.QueryRunnerPreparedStatement;
import org.codejargon.fluentjdbc.internal.query.SingleQuerySpecification;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

abstract class SingleQueryBase {
    protected final String sql;
    protected final QueryInternal query;
    protected final List<Object> params = new ArrayList<Object>(0);
    protected final Map<String, Object> namedParams = new HashMap<String, Object>(0);

    protected SingleQueryBase(QueryInternal query, String sql) {
        this.query = query;
        this.sql = sql;
    }

    protected void addParameters(List<Object> params) {
        Preconditions.checkArgument(this.namedParams.isEmpty(), "Can not add positional parameters if named parameters are set.");
        this.params.addAll(params);
    }

    protected void addParameters(Object ... params) {
        this.addParameters(Arrays.asList(params));
    }

    protected void addNamedParameters(Map<String, Object> namedParams) {
        Preconditions.checkArgument(this.params.isEmpty(), "Can not add named parameters if positional parameters are set.");
        Preconditions.checkArgument(!namedParams.isEmpty(), "Can not set empty named parameters");
        this.namedParams.putAll(namedParams);
    }

    protected <T> T runQuery(QueryRunnerPreparedStatement<T> queryRunnerPreparedStatement) {
        return (T)this.query.query(connection -> {
            try (PreparedStatement ps = this.query.preparedStatementFactory.createSingle(connection, this.querySpecs());){
                Object t = queryRunnerPreparedStatement.run(ps);
                return t;
            }
        }, this.sql);
    }

    protected abstract SingleQuerySpecification querySpecs();
}

