/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.mappers;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codejargon.fluentjdbc.api.mapper.ObjectMapperRsExtractor;

public class DefaultObjectMapperRsExtractors {
    private static final Map<Class, ObjectMapperRsExtractor> extractors;

    private static void javaDate(Map<Class, ObjectMapperRsExtractor<?>> exs) {
        DefaultObjectMapperRsExtractors.reg(exs, java.util.Date.class, ResultSet::getDate);
    }

    private static void javaTimeTypes(Map<Class, ObjectMapperRsExtractor<?>> exs) {
        DefaultObjectMapperRsExtractors.reg(exs, LocalDate.class, (rs, i) -> {
            Date date = rs.getDate(i);
            return date != null ? date.toLocalDate() : null;
        });
        DefaultObjectMapperRsExtractors.reg(exs, LocalDateTime.class, (rs, i) -> {
            Timestamp stamp = rs.getTimestamp(i);
            return stamp != null ? stamp.toLocalDateTime() : null;
        });
        DefaultObjectMapperRsExtractors.reg(exs, LocalTime.class, (rs, i) -> {
            Time time = rs.getTime(i);
            return time != null ? time.toLocalTime() : null;
        });
        DefaultObjectMapperRsExtractors.reg(exs, Year.class, (rs, i) -> {
            Date date = rs.getDate(i);
            return date != null ? Year.from(date.toLocalDate()) : null;
        });
        DefaultObjectMapperRsExtractors.reg(exs, YearMonth.class, (rs, i) -> {
            Date date = rs.getDate(i);
            return date != null ? YearMonth.from(date.toLocalDate()) : null;
        });
        DefaultObjectMapperRsExtractors.reg(exs, Instant.class, (rs, i) -> {
            Timestamp stamp = rs.getTimestamp(i);
            return stamp != null ? stamp.toInstant() : null;
        });
    }

    private static void basicTypes(Map<Class, ObjectMapperRsExtractor<?>> exs) {
        DefaultObjectMapperRsExtractors.reg(exs, Boolean.class, ResultSet::getBoolean);
        DefaultObjectMapperRsExtractors.reg(exs, Boolean.TYPE, ResultSet::getBoolean);
        DefaultObjectMapperRsExtractors.reg(exs, Short.class, ResultSet::getShort);
        DefaultObjectMapperRsExtractors.reg(exs, Short.TYPE, ResultSet::getShort);
        DefaultObjectMapperRsExtractors.reg(exs, Integer.class, ResultSet::getInt);
        DefaultObjectMapperRsExtractors.reg(exs, Integer.TYPE, ResultSet::getInt);
        DefaultObjectMapperRsExtractors.reg(exs, Long.class, ResultSet::getLong);
        DefaultObjectMapperRsExtractors.reg(exs, Long.TYPE, ResultSet::getLong);
        DefaultObjectMapperRsExtractors.reg(exs, Float.class, ResultSet::getFloat);
        DefaultObjectMapperRsExtractors.reg(exs, Float.TYPE, ResultSet::getFloat);
        DefaultObjectMapperRsExtractors.reg(exs, Double.class, ResultSet::getDouble);
        DefaultObjectMapperRsExtractors.reg(exs, Double.TYPE, ResultSet::getDouble);
        DefaultObjectMapperRsExtractors.reg(exs, BigDecimal.class, ResultSet::getBigDecimal);
        DefaultObjectMapperRsExtractors.reg(exs, Timestamp.class, ResultSet::getTimestamp);
        DefaultObjectMapperRsExtractors.reg(exs, Time.class, ResultSet::getTime);
        DefaultObjectMapperRsExtractors.reg(exs, Date.class, ResultSet::getDate);
        DefaultObjectMapperRsExtractors.reg(exs, String.class, ResultSet::getString);
    }

    public static Map<Class, ObjectMapperRsExtractor> extractors() {
        return extractors;
    }

    private static <T> void reg(Map<Class, ObjectMapperRsExtractor<?>> exs, Class<T> clazz, ObjectMapperRsExtractor<T> extractor) {
        exs.put(clazz, extractor);
    }

    static {
        HashMap exs = new HashMap();
        DefaultObjectMapperRsExtractors.basicTypes(exs);
        DefaultObjectMapperRsExtractors.javaDate(exs);
        DefaultObjectMapperRsExtractors.javaTimeTypes(exs);
        extractors = Collections.unmodifiableMap(exs);
    }
}

