/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.targetplatform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.tycho.plugin.artifactfilter.ArtifactsFilter;
import org.codehaus.tycho.plugin.artifactfilter.FilterArtifacts;
import org.codehaus.tycho.plugin.artifactfilter.TransitivityFilter;
import org.codehaus.tycho.plugin.artifactfilter.TypeFilter;
import org.codehaus.tycho.targetplatform.Util;

public class TargetPlatformMojo
extends AbstractMojo {
    private MavenProject project;
    protected ArchiverManager archiverManager;
    protected List remoteRepositories;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    private File pluginsDir;
    private File sourcePlugin;
    private MavenProjectBuilder projectBuilder;
    private File markersDirectory;
    private Set markers = new HashSet();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.markersDirectory.mkdirs();
        this.markers.addAll(Arrays.asList(this.markersDirectory.listFiles()));
        if (!this.sourcePlugin.exists()) {
            this.createSourcePlugin();
        }
        Set artifacts = this.getArtifacts();
        for (Artifact a : artifacts) {
            if (a.getType().equals("eclipse-feature")) {
                this.processFeature(a);
                continue;
            }
            this.processPlugin(a);
        }
        for (File marker : this.markers) {
            try {
                File f = this.readMarker(marker);
                this.getLog().info((CharSequence)("Deleting " + f));
                if (f.isDirectory()) {
                    FileUtils.deleteDirectory((File)f);
                } else {
                    f.delete();
                }
                if (marker.delete()) continue;
                this.getLog().error((CharSequence)"Could not delete marker");
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not delete " + marker));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File readMarker(File marker) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(marker));
        try {
            String fileName = r.readLine();
            File file = new File(fileName);
            return file;
        }
        finally {
            r.close();
        }
    }

    private void processFeature(Artifact a) {
        try {
            MavenProject project = this.projectBuilder.buildFromRepository(a, this.remoteRepositories, this.localRepository);
            Set artifacts = project.createArtifacts(this.artifactFactory, null, null);
            for (Artifact artifact : artifacts) {
                this.processPlugin(artifact);
            }
        }
        catch (ProjectBuildingException e) {
            e.printStackTrace();
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
    }

    private Set getArtifacts() throws MojoExecutionException, MojoFailureException {
        FilterArtifacts fa = new FilterArtifacts();
        fa.addFilter((ArtifactsFilter)new TypeFilter("jar,eclipse-feature", null));
        fa.addFilter((ArtifactsFilter)new TransitivityFilter(this.project.getDependencyArtifacts(), true));
        Set artifacts = fa.filter(this.project.getArtifacts(), this.getLog());
        return artifacts;
    }

    private void processPlugin(Artifact artifact) throws MojoExecutionException {
        this.markers.remove(this.getMarker(artifact));
        try {
            File target;
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            if (this.isUpToDate(artifact)) {
                this.getLog().info((CharSequence)(artifact + " is up to date"));
                return;
            }
            File f = artifact.getFile();
            JarFile jar = new JarFile(f);
            Manifest mft = jar.getManifest();
            if (mft == null || mft.getMainAttributes().getValue("Bundle-SymbolicName") == null) {
                this.getLog().debug((CharSequence)("Not a bundle. Skipping " + artifact));
                return;
            }
            this.getLog().info((CharSequence)("Processing " + artifact));
            boolean extract = !Util.isSimpleJar(artifact, jar);
            jar.close();
            String name = Util.getName(artifact.getFile());
            if (extract) {
                target = new File(this.pluginsDir, name);
                target.mkdirs();
                Util.unpack(this.archiverManager, f, target);
            } else {
                target = new File(this.pluginsDir, name + ".jar");
                FileUtils.copyFile((File)f, (File)target);
            }
            File sourceFile = this.getSourceFile(artifact);
            if (sourceFile != null) {
                File d = new File(this.sourcePlugin, name);
                d.mkdir();
                FileUtils.copyFile((File)sourceFile, (File)new File(d, "src.zip"));
            }
            this.updateMarker(artifact, target);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error processing artifact " + artifact, (Exception)e);
        }
        catch (ArtifactResolutionException e) {
            e.printStackTrace();
        }
        catch (ArtifactNotFoundException e) {
            e.printStackTrace();
        }
    }

    private boolean isUpToDate(Artifact artifact) {
        File marker = this.getMarker(artifact);
        if (!marker.exists()) {
            return false;
        }
        File file = artifact.getFile();
        if (file == null) {
            return false;
        }
        return marker.lastModified() > file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarker(Artifact artifact, File file) throws IOException {
        this.markersDirectory.mkdirs();
        File marker = this.getMarker(artifact);
        if (file != null) {
            PrintWriter w = new PrintWriter(new FileWriter(marker));
            try {
                w.println(file.getCanonicalPath());
            }
            finally {
                w.close();
            }
        } else {
            marker.createNewFile();
        }
    }

    private File getMarker(Artifact artifact) {
        File marker = new File(this.markersDirectory, artifact.getGroupId() + "-" + artifact.getArtifactId() + "-" + artifact.getVersion());
        return marker;
    }

    private File createSourcePlugin() throws MojoExecutionException {
        if (!this.sourcePlugin.exists()) {
            this.sourcePlugin.mkdirs();
        }
        File manifestDir = new File(this.sourcePlugin, "META-INF");
        manifestDir.mkdirs();
        Manifest mft = new Manifest();
        Attributes a = mft.getMainAttributes();
        a.putValue("Manifest-Version", "1.0");
        a.putValue("Bundle-SymbolicName", "source");
        a.putValue("Bundle-Name", "source");
        a.putValue("Bundle-Version", "not.important");
        try {
            FileOutputStream fos = new FileOutputStream(new File(manifestDir, "MANIFEST.MF"));
            mft.write(fos);
            fos.close();
            File pluginXML = new File(this.sourcePlugin, "plugin.xml");
            PrintWriter pw = new PrintWriter(new FileWriter(pluginXML));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<?eclipse version=\"3.0\"?>");
            pw.println("<plugin>");
            pw.println("<extension point = \"org.eclipse.pde.core.source\">");
            pw.println("\t<location path=\".\" />");
            pw.println("</extension>");
            pw.println("</plugin>");
            pw.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Creating plugin.xml", (Exception)e);
        }
        return this.sourcePlugin;
    }

    public File getSourceFile(Artifact artifact) {
        Artifact resolvedArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", "sources");
        try {
            this.artifactResolver.resolve(resolvedArtifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)("No source artifact found for " + artifact));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Error resolving " + resolvedArtifact.getId() + " - " + "sources"), (Throwable)e);
        }
        File result = resolvedArtifact.getFile();
        return result != null && result.exists() ? result : null;
    }
}

