/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.targetplatform;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.tycho.CLITools;
import org.codehaus.tycho.TychoException;
import org.codehaus.tycho.osgitools.GroupMapper;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.PomGenerator;
import org.codehaus.tycho.targetplatform.SourceManager;
import org.eclipse.osgi.service.resolver.BundleDescription;

public abstract class AbstractDeployBundlesMojo
extends AbstractMojo {
    private File baseDir;
    private String include;
    private File groupList;
    private String versionQualifier;
    private ArtifactFactory artifactFactory;
    private PomGenerator pomGenerator;
    protected CLITools cliTools;
    private SourceManager sourceManager;
    private Model targetPlatformPom;
    private List noSourceFound = new ArrayList();
    private ArtifactResolver resolver;
    private ArtifactMetadataSource metadataSource;
    private MavenProjectBuilder mavenProjectBuilder;
    private String targetArtifactId;
    private String sourceArtifactId;
    ArtifactRepository localRepository;
    private List remoteRepositories;
    OsgiState state;
    private Artifact targetPlatformArtifact;
    private List sourceArtifacts = new ArrayList();

    public void execute() throws MojoExecutionException {
        try {
            File featureDir;
            if (!StringUtils.isEmpty((String)this.targetArtifactId)) {
                this.targetPlatformArtifact = this.cliTools.createArtifact(this.targetArtifactId, "pom");
                this.targetPlatformPom = new Model();
                this.targetPlatformPom.setModelVersion("4.0.0");
                this.targetPlatformPom.setArtifactId(this.targetPlatformArtifact.getArtifactId());
                this.targetPlatformPom.setGroupId(this.targetPlatformArtifact.getGroupId());
                this.targetPlatformPom.setVersion(this.targetPlatformArtifact.getVersion());
                this.targetPlatformPom.setPackaging("eclipse-feature");
            }
            if (!StringUtils.isEmpty((String)this.sourceArtifactId)) {
                String[] split = this.sourceArtifactId.split(",");
                for (int i = 0; i < split.length; ++i) {
                    HashSet dependencies = new HashSet();
                    Artifact artifact = this.cliTools.createArtifact(split[i], "pom");
                    this.sourceArtifacts.addAll(this.getTransitiveDependencies(artifact));
                }
            }
            String[] filters = this.include.split(",");
            Pattern[] patterns = new Pattern[filters.length];
            for (int i = 0; i < patterns.length; ++i) {
                patterns[i] = Pattern.compile(filters[i]);
            }
            GroupMapper groupMapper = new GroupMapper(this.groupList);
            BundleDescription[] bundles = this.state.getBundles();
            List deployed = this.filterDeployed(patterns, bundles);
            this.sourceManager = new SourceManager(this.baseDir);
            for (BundleDescription bundle : deployed) {
                if (bundle.isResolved()) {
                    Model model = this.pomGenerator.createBundlePom(groupMapper, deployed, this.versionQualifier, bundle);
                    this.deploy(bundle, model);
                    continue;
                }
                this.getLog().error((CharSequence)("Not deploying " + bundle + " because of resolving errrors"));
            }
            if (this.targetPlatformPom != null) {
                File pom = this.writePom(this.targetPlatformPom);
                pom.deleteOnExit();
                this.targetPlatformArtifact.setFile(this.createEmptyJar());
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(this.targetPlatformArtifact, pom);
                this.targetPlatformArtifact.addMetadata((ArtifactMetadata)metadata);
                this.deployArtifact(this.targetPlatformArtifact);
            }
            if (!this.noSourceFound.isEmpty()) {
                this.getLog().info((CharSequence)"No source found for: ");
                for (String element : this.noSourceFound) {
                    this.getLog().info((CharSequence)("\t" + element));
                }
            }
            if ((featureDir = new File(this.baseDir, "features")).exists()) {
                File[] featureDirs = featureDir.listFiles();
                for (int i = 0; i < featureDirs.length; ++i) {
                    File f = featureDirs[i];
                    File featureXML = new File(f, "feature.xml");
                    if (!featureXML.exists()) continue;
                    this.deployFeature(f, bundles);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private void deployFeature(File f, BundleDescription[] bundles) {
        System.out.println("TODO deploy feature " + f);
    }

    private List filterDeployed(Pattern[] patterns, BundleDescription[] bundles) {
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>();
        for (int i = 0; i < bundles.length; ++i) {
            BundleDescription b = bundles[i];
            this.getLog().info((CharSequence)("checking " + b.getSymbolicName()));
            for (int j = 0; j < patterns.length; ++j) {
                Pattern p = patterns[j];
                if (!p.matcher(b.getSymbolicName()).matches()) continue;
                result.add(b);
            }
        }
        return result;
    }

    private void deploy(BundleDescription bundle, Model model) throws MojoExecutionException {
        File location = new File(bundle.getLocation());
        if (!SourceManager.getSourceDirs(location).isEmpty()) {
            return;
        }
        if (location.isDirectory()) {
            location = this.createJar(location);
            location.deleteOnExit();
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(model.getGroupId(), model.getArtifactId(), model.getVersion(), "jar", null);
        artifact.setFile(location);
        try {
            File sourceFile;
            File pom = this.writePom(model);
            pom.deleteOnExit();
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom);
            artifact.addMetadata((ArtifactMetadata)metadata);
            this.deployArtifact(artifact);
            if (this.targetPlatformPom != null) {
                Dependency dep = new Dependency();
                dep.setGroupId(model.getGroupId());
                dep.setArtifactId(model.getArtifactId());
                dep.setVersion(model.getVersion());
                dep.setScope(Artifact.SCOPE_COMPILE);
                this.targetPlatformPom.addDependency(dep);
            }
            if ((sourceFile = this.sourceManager.getSourceZip(model.getArtifactId(), model.getVersion())) != null) {
                Artifact sourceArtifact = this.artifactFactory.createArtifactWithClassifier(model.getGroupId(), model.getArtifactId(), model.getVersion(), "jar", "sources");
                sourceArtifact.setFile(sourceFile);
                this.deployArtifact(sourceArtifact);
            } else {
                this.noSourceFound.add(model.getArtifactId());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write POM", (Exception)e);
        }
        catch (TychoException e) {
            throw new MojoExecutionException("Could not install/deploy " + artifact, (Exception)((Object)e));
        }
    }

    public abstract void deployArtifact(Artifact var1) throws TychoException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writePom(Model model) throws IOException {
        File pom = File.createTempFile("deploy", ".pom");
        FileWriter fw = new FileWriter(pom);
        try {
            new MavenXpp3Writer().write((Writer)fw, model);
            File file = pom;
            return file;
        }
        finally {
            fw.close();
        }
    }

    private File createJar(File location) {
        try {
            File temp = File.createTempFile("deploy", ".jar");
            JarArchiver archiver = new JarArchiver();
            archiver.addDirectory(location, new String[]{"**/*"}, new String[]{"**/.svn", "**/.svn/**"});
            archiver.setDestFile(temp);
            File manifest = new File(location, "META-INF/MANIFEST.MF");
            if (manifest.exists()) {
                archiver.setManifest(manifest);
            }
            archiver.createArchive();
            return temp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File createEmptyJar() {
        try {
            File temp = File.createTempFile("deploy", ".jar");
            JarArchiver archiver = new JarArchiver();
            archiver.setDestFile(temp);
            archiver.createArchive();
            return temp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set getTransitiveDependencies(Artifact artifact) throws TychoException {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        try {
            Artifact pomArtifact = this.artifactFactory.createArtifact(groupId, artifactId, version, null, "pom");
            MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepositories, this.localRepository);
            String scope = Artifact.SCOPE_RUNTIME;
            ScopeArtifactFilter filter = new ScopeArtifactFilter(scope);
            Set artifacts = pomProject.createArtifacts(this.artifactFactory, null, null);
            ArtifactResolutionResult arr = this.resolver.resolveTransitively(artifacts, pomArtifact, this.localRepository, this.remoteRepositories, this.metadataSource, (ArtifactFilter)filter);
            artifacts = arr.getArtifacts();
            for (Artifact a : artifacts) {
                this.resolver.resolve(a, this.remoteRepositories, this.localRepository);
            }
            return artifacts;
        }
        catch (ProjectBuildingException e) {
            throw new TychoException("Error resolving transitively for " + artifact, (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new TychoException("Error resolving transitively for " + artifact, (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new TychoException("Error resolving transitively for " + artifact, (Throwable)e);
        }
        catch (Exception e) {
            throw new TychoException("Error resolving transitively for " + artifact, (Throwable)e);
        }
    }
}

