/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.tycho.eclipsepackaging.Util;
import org.codehaus.tycho.osgitools.BundleFile;
import org.codehaus.tycho.osgitools.OsgiState;

public class PackageTestFragmentMojo
extends AbstractMojo {
    protected File testOutputDirectory;
    protected MavenProject project;
    private JarArchiver jarArchiver = new JarArchiver();
    protected String finalName;
    protected MavenProjectHelper projectHelper;
    private boolean skip;
    private File outputDir;
    private OsgiState state;

    public void execute() throws MojoExecutionException {
        this.createPlugin();
    }

    private void createPlugin() throws MojoExecutionException {
        if (this.skip || !this.testOutputDirectory.exists()) {
            return;
        }
        try {
            Properties buildProperties = new Properties();
            buildProperties.load(new FileInputStream(new File(this.project.getBasedir(), "build.properties")));
            File fragment = new File(this.project.getBuild().getDirectory(), this.finalName + ".jar");
            if (fragment.exists()) {
                fragment.delete();
            }
            this.jarArchiver.addDirectory(this.testOutputDirectory, Util.DEFAULT_INCLUDES, Util.DEFAULT_EXCLUDES);
            File fragmentManifest = this.createFragmentManifest();
            this.jarArchiver.setManifest(fragmentManifest);
            this.jarArchiver.setDestFile(fragment);
            this.jarArchiver.createArchive();
            this.projectHelper.attachArtifact(this.project, "jar", "tests", fragment);
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private File createFragmentManifest() throws IOException {
        File file = new File(this.project.getBasedir(), "META-INF/MANIFEST.MF");
        BundleFile bundle = new BundleFile(this.state.loadManifest(file), file);
        Manifest mft = new Manifest();
        Attributes attr = mft.getMainAttributes();
        attr.putValue("Manifest-Version", "1.0");
        attr.putValue("Bundle-ManifestVersion", "2");
        attr.putValue("Bundle-Name", bundle.getName() + " - Tests");
        attr.putValue("Bundle-SymbolicName", bundle.getSymbolicName() + ".tests");
        attr.putValue("Bundle-Version", bundle.getVersion());
        attr.putValue("Fragment-Host", bundle.getSymbolicName());
        File result = new File(this.project.getBuild().getDirectory(), "test-manifest.mf");
        FileOutputStream fos = new FileOutputStream(result);
        mft.write(fos);
        fos.close();
        return result;
    }
}

