/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.api;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Project;

public final class JavaUtils {
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String DEFAULT_PACKAGE = "[default]";
    public static final String BARRIER_BEFORE_SQUID = "BEFORE_SQUID";
    public static final String BARRIER_AFTER_SQUID = "squid";
    public static final String JAVA_SOURCE_PROPERTY = "sonar.java.source";
    public static final String JAVA_SOURCE_DEFAULT_VALUE = "1.5";
    public static final String JAVA_TARGET_PROPERTY = "sonar.java.target";
    public static final String JAVA_TARGET_DEFAULT_VALUE = "1.5";

    private JavaUtils() {
    }

    public static String abbreviatePackage(String packageName) {
        String[] parts = StringUtils.split((String)packageName, (String)PACKAGE_SEPARATOR);
        StringBuilder sb = new StringBuilder();
        if (parts.length >= 1) {
            sb.append(parts[0]);
        }
        for (int index = 1; index < parts.length; ++index) {
            sb.append(PACKAGE_SEPARATOR).append(parts[index].charAt(0));
        }
        return sb.toString();
    }

    public static String getSourceVersion(Project project) {
        String version = project.getConfiguration() != null ? project.getConfiguration().getString(JAVA_SOURCE_PROPERTY) : null;
        return StringUtils.isNotBlank((String)version) ? version : "1.5";
    }

    public static String getTargetVersion(Project project) {
        String version = project.getConfiguration() != null ? project.getConfiguration().getString(JAVA_TARGET_PROPERTY) : null;
        return StringUtils.isNotBlank((String)version) ? version : "1.5";
    }
}

