/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.api;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Resource;

public final class JavaClass
extends Resource {
    public static final String SCOPE = "PGU";
    public static final String QUALIFIER = "CLA";
    public static final int UNKNOWN_LINE = -1;
    private int fromLine = -1;
    private int toLine = -1;

    private JavaClass(String name) {
        this.setKey(name);
    }

    private JavaClass(String name, int fromLine, int toLine) {
        this.setKey(name);
        this.fromLine = fromLine;
        this.toLine = toLine;
    }

    public String getPackageName() {
        if (StringUtils.contains((String)this.getKey(), (String)".")) {
            return StringUtils.substringBeforeLast((String)this.getKey(), (String)".");
        }
        return "";
    }

    public String getClassName() {
        String className = StringUtils.substringAfterLast((String)this.getKey(), (String)".");
        return StringUtils.defaultIfEmpty((String)className, (String)this.getKey());
    }

    public int getFromLine() {
        return this.fromLine;
    }

    public int getToLine() {
        return this.toLine;
    }

    public String getName() {
        return this.getKey();
    }

    public String getLongName() {
        return this.getKey();
    }

    public String getDescription() {
        return null;
    }

    public Language getLanguage() {
        return Java.INSTANCE;
    }

    public String getScope() {
        return SCOPE;
    }

    public String getQualifier() {
        return QUALIFIER;
    }

    public Resource getParent() {
        return null;
    }

    public boolean matchFilePattern(String antPattern) {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public static JavaClass create(String name) {
        return new JavaClass(name);
    }

    public static JavaClass create(String packageName, String className) {
        if (StringUtils.isBlank((String)packageName)) {
            return new JavaClass(className);
        }
        return new JavaClass(JavaClass.toName(packageName, className));
    }

    private static String toName(String packageName, String className) {
        if (StringUtils.isBlank((String)packageName)) {
            return className;
        }
        return packageName + "." + className;
    }

    public static class Builder {
        private String name;
        private int fromLine = -1;
        private int toLine = -1;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setName(String packageName, String className) {
            this.name = JavaClass.toName(packageName, className);
            return this;
        }

        public Builder setFromLine(int fromLine) {
            this.fromLine = Math.max(-1, fromLine);
            return this;
        }

        public Builder setToLine(int toLine) {
            this.toLine = Math.max(-1, toLine);
            return this;
        }

        public JavaClass create() {
            return new JavaClass(this.name, this.fromLine, this.toLine);
        }
    }
}

