/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.wsclient;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.ide.api.SourceCodeDiff;
import org.sonar.ide.api.SourceCodeDiffEngine;
import org.sonar.wsclient.services.Source;

public class SimpleSourceCodeDiffEngine
implements SourceCodeDiffEngine {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSourceCodeDiffEngine.class);

    public static SourceCodeDiffEngine getInstance() {
        return new SimpleSourceCodeDiffEngine();
    }

    public SourceCodeDiff diff(String local, String remote) {
        return this.diff(SimpleSourceCodeDiffEngine.split(local), SimpleSourceCodeDiffEngine.split(remote));
    }

    public SourceCodeDiff diff(String[] local, String[] remote) {
        SourceCodeDiff result = new SourceCodeDiff();
        int[] hashCodes = SimpleSourceCodeDiffEngine.getHashCodes(local);
        for (int i = 0; i < remote.length; ++i) {
            int originalLine = i + 1;
            int newLine = this.internalMatch(remote[i], hashCodes, originalLine);
            if (newLine == -1) continue;
            result.map(originalLine, newLine);
        }
        return result;
    }

    private int internalMatch(String originalSourceLine, int[] hashCodes, int originalLine) {
        int newLine = -1;
        int originalHashCode = SimpleSourceCodeDiffEngine.getHashCode(originalSourceLine);
        if (originalLine - 1 < hashCodes.length && hashCodes[originalLine - 1] == originalHashCode) {
            newLine = originalLine;
        }
        for (int i = 0; i < hashCodes.length; ++i) {
            if (hashCodes[i] != originalHashCode) continue;
            if (newLine != -1 && newLine != originalLine) {
                LOG.warn("Found more than one match for line '{}'", (Object)originalSourceLine);
                break;
            }
            newLine = i + 1;
        }
        return newLine;
    }

    public static String[] split(String text) {
        return StringUtils.splitPreserveAllTokens((String)text, (char)'\n');
    }

    static int getHashCode(String str) {
        if (str == null) {
            return 0;
        }
        return StringUtils.deleteWhitespace((String)str).hashCode();
    }

    private static int[] getHashCodes(String[] str) {
        int[] hashCodes = new int[str.length];
        for (int i = 0; i < str.length; ++i) {
            hashCodes[i] = SimpleSourceCodeDiffEngine.getHashCode(str[i]);
        }
        return hashCodes;
    }

    public static String[] getLines(Source source) {
        String[] remote = new String[((Integer)source.getLinesById().lastKey()).intValue()];
        for (int i = 0; i < remote.length; ++i) {
            remote[i] = source.getLine(i + 1);
            if (remote[i] != null) continue;
            remote[i] = "";
        }
        return remote;
    }
}

