/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.shared.duplications;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.sonar.ide.api.SonarIdeException;
import org.sonar.ide.api.SourceCodeDiff;
import org.sonar.ide.shared.duplications.Duplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DuplicationUtils {
    public static final String DUPLICATIONS_DATA = "duplications_data";

    public static List<Duplication> parse(String xml) {
        Document doc;
        ArrayList<Duplication> result = new ArrayList<Duplication>();
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            throw new SonarIdeException("Unable to parse duplications", e);
        }
        catch (IOException e) {
            throw new SonarIdeException("Unable to parse duplications", e);
        }
        List duplications = doc.getRootElement().getChildren("duplication");
        for (Object elementObj : duplications) {
            Element element = (Element)elementObj;
            String lines = element.getAttributeValue("lines");
            String start = element.getAttributeValue("start");
            String targetStart = element.getAttributeValue("target-start");
            String targetResource = element.getAttributeValue("target-resource");
            result.add(new Duplication(Integer.parseInt(lines), Integer.parseInt(start), Integer.parseInt(targetStart), targetResource));
        }
        return result;
    }

    public static List<Duplication> convertLines(Collection<Duplication> duplications, SourceCodeDiff diff) {
        ArrayList<Duplication> result = new ArrayList<Duplication>();
        for (Duplication duplication : duplications) {
            int newLine = diff.newLine(duplication.getStart());
            if (newLine == -1) continue;
            duplication.setStart(newLine);
            result.add(duplication);
        }
        return result;
    }

    private DuplicationUtils() {
    }

    public static String getDescription(Duplication duplication) {
        return String.format("Duplicates %s lines from %s starting from %s", duplication.getLines(), duplication.getTargetResource(), duplication.getTargetStart());
    }
}

