/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.shared;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.wsclient.Host;

@Deprecated
public final class SonarProperties {
    public static final Logger LOG = LoggerFactory.getLogger(SonarProperties.class);
    public static final String FILENAME = ".sonar-ide.properties";
    public static final String HOST_DEFAULT = "http://localhost:9000";
    public static final String HOST_PROPERTY = "host";
    public static final String USERNAME_PROPERTY = "username";
    public static final String PASSWORD_PROPERTY = "password";
    private static SonarProperties instance;
    private String path;
    private Host server;

    public SonarProperties(String path) {
        this.path = path;
        this.server = new Host(HOST_DEFAULT);
        this.reload();
    }

    public Host getServer() {
        return this.server;
    }

    public void reload() {
        Properties properties = SonarProperties.load(this.path);
        this.server.setHost(properties.getProperty(HOST_PROPERTY, HOST_DEFAULT));
        this.server.setPassword(properties.getProperty(PASSWORD_PROPERTY));
        this.server.setUsername(properties.getProperty(USERNAME_PROPERTY));
    }

    private static void addProperty(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public void save() {
        Properties properties = new Properties();
        SonarProperties.addProperty(properties, HOST_PROPERTY, this.server.getHost());
        SonarProperties.addProperty(properties, USERNAME_PROPERTY, this.server.getUsername());
        SonarProperties.addProperty(properties, PASSWORD_PROPERTY, this.server.getPassword());
        SonarProperties.save(properties, this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String filename) {
        Properties properties;
        block5: {
            block6: {
                LOG.info("Loading settings from '{}'", (Object)filename);
                properties = new Properties();
                if (filename == null) {
                    return properties;
                }
                FileInputStream inputStream = null;
                File file = new File(filename);
                if (!file.exists()) break block6;
                try {
                    inputStream = new FileInputStream(filename);
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    try {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SonarProperties.closeStream(inputStream);
                        throw throwable;
                    }
                    SonarProperties.closeStream(inputStream);
                    break block5;
                }
                SonarProperties.closeStream(inputStream);
                break block5;
            }
            LOG.warn("File doesn't exists");
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void save(Properties properties, String filename) {
        LOG.info("Saving settings to '{}'", (Object)filename);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filename);
            properties.store(outputStream, "Sonar Settings");
        }
        catch (FileNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            SonarProperties.closeStream(outputStream);
        }
        catch (IOException e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    SonarProperties.closeStream(outputStream);
                    throw throwable;
                }
            }
            SonarProperties.closeStream(outputStream);
        }
        SonarProperties.closeStream(outputStream);
    }

    public static String getDefaultPath() {
        return System.getProperty("user.home") + File.separator + FILENAME;
    }

    public static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

