/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.shared;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.ide.api.Logs;
import org.sonar.ide.api.SonarIdeException;
import org.sonar.ide.client.SonarClient;
import org.sonar.wsclient.Host;
import org.sonar.wsclient.Sonar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerManager {
    private static final String SERVER_CACHE_NAME = ".serverlist";
    protected final ArrayList<Host> serverList = new ArrayList();
    protected String path;
    protected final List<IServerSetListener> serverSetListeners = new ArrayList<IServerSetListener>();

    public DefaultServerManager() {
        this(null);
    }

    public DefaultServerManager(String path) {
        this.path = path;
        try {
            this.load();
        }
        catch (Exception e) {
            Logs.INFO.warn("default server manager error!", (Throwable)e);
        }
    }

    public void addServer(String location, String username, String password) throws Exception {
        this.addServer(new Host(location, username, password));
    }

    public void addServer(Host server) {
        if (this.findServer(server.getHost()) != null) {
            throw new SonarIdeException("Duplicate server: " + server.getHost());
        }
        this.serverList.add(server);
        this.commit();
        this.notifyListeners(0);
    }

    public List<Host> getServers() {
        return this.serverList;
    }

    public boolean removeServer(String host) {
        Host server = this.findServer(host);
        if (server == null) {
            return false;
        }
        boolean result = false;
        result = this.serverList.remove(server);
        this.notifyListeners(2);
        this.commit();
        return result;
    }

    public Host createServer(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Host host = this.findServer(url);
        if (host == null) {
            host = new Host(url);
            this.addServer(host);
            this.commit();
        }
        return host;
    }

    public Host findServer(String host) {
        Host server = null;
        for (Host element : this.serverList) {
            if (!element.getHost().equals(host)) continue;
            server = element;
            break;
        }
        return server;
    }

    public Sonar getSonar(String url) {
        Host server = this.createServer(url);
        return new SonarClient(server.getHost(), server.getUsername(), server.getPassword());
    }

    public boolean testSonar(String url, String user, String password) throws Exception {
        SonarClient sonar = new SonarClient(url, user, password);
        return sonar.isAvailable();
    }

    protected File getServerListFile() {
        if (StringUtils.isBlank((String)this.path)) {
            this.path = System.getProperty("user.home");
        }
        return new File(this.path + File.separator + SERVER_CACHE_NAME);
    }

    private void commit() {
        File serverListFile = this.getServerListFile();
        FileOutputStream fos = null;
        PrintWriter writer = null;
        try {
            fos = new FileOutputStream(serverListFile);
            writer = new PrintWriter(fos);
            for (Host server : this.serverList) {
                writer.println(server.getHost() + "|" + server.getUsername() + "|" + server.getPassword());
            }
            writer.flush();
            fos.flush();
        }
        catch (Exception ex) {
            throw new SonarIdeException("error in commit server manager", ex);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new SonarIdeException("error in commit server manager", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws Exception {
        this.serverList.clear();
        File serverListFile = this.getServerListFile();
        if (!serverListFile.exists()) {
            return;
        }
        FileInputStream fis = null;
        BufferedReader reader = null;
        try {
            String line;
            fis = new FileInputStream(serverListFile);
            reader = new BufferedReader(new InputStreamReader(fis));
            do {
                if (!StringUtils.isNotBlank((String)(line = reader.readLine()))) continue;
                String[] infos = StringUtils.split((String)line, (String)"|");
                if (infos.length == 1) {
                    this.serverList.add(new Host(infos[0]));
                }
                if (infos.length != 3) continue;
                this.serverList.add(new Host(infos[0], infos[1], infos[2]));
            } while (line != null);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public boolean addServerSetListener(IServerSetListener listener) {
        return this.serverSetListeners.add(listener);
    }

    public boolean removeServerSetListener(IServerSetListener listener) {
        return this.serverSetListeners.remove(listener);
    }

    protected void notifyListeners(int eventType) {
        for (IServerSetListener listener : this.serverSetListeners) {
            listener.serverSetChanged(eventType, this.serverList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IServerSetListener {
        public static final int SERVER_ADDED = 0;
        public static final int SERVER_EDIT = 1;
        public static final int SERVER_REMOVED = 2;

        public void serverSetChanged(int var1, List<Host> var2);
    }
}

