/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.testing;

import com.google.inject.Module;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.DefaultContext;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class PlexusExtension
implements BeforeEachCallback,
AfterEachCallback {
    private ExtensionContext context;
    private PlexusContainer container;
    private static String basedir;

    public void beforeEach(ExtensionContext context) throws Exception {
        basedir = PlexusExtension.getBasedir();
        this.setContext(context);
        this.getContainer().addComponent((Object)this.getContainer(), PlexusContainer.class.getName());
        ((DefaultPlexusContainer)this.getContainer()).addPlexusInjector(Collections.emptyList(), new Module[]{binder -> binder.requestInjection(context.getRequiredTestInstance())});
    }

    protected void setContext(ExtensionContext context) {
        this.context = context;
    }

    protected void setupContainer() {
        DefaultContext context = new DefaultContext();
        context.put((Object)"basedir", (Object)PlexusExtension.getBasedir());
        this.customizeContext((Context)context);
        boolean hasPlexusHome = context.contains((Object)"plexus.home");
        if (!hasPlexusHome) {
            File f = PlexusExtension.getTestFile("target/plexus-home");
            if (!f.isDirectory()) {
                f.mkdir();
            }
            context.put((Object)"plexus.home", (Object)f.getAbsolutePath());
        }
        String config = this.getCustomConfigurationName();
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setName("test").setContext(context.getContextData());
        if (config != null) {
            containerConfiguration.setContainerConfiguration(config);
        } else {
            String resource = this.getConfigurationName(null);
            containerConfiguration.setContainerConfiguration(resource);
        }
        this.customizeContainerConfiguration(containerConfiguration);
        try {
            this.container = new DefaultPlexusContainer(containerConfiguration);
        }
        catch (PlexusContainerException e) {
            throw new IllegalArgumentException("Failed to create plexus container.", e);
        }
    }

    protected void customizeContainerConfiguration(ContainerConfiguration containerConfiguration) {
        containerConfiguration.setAutoWiring(true);
        containerConfiguration.setClassPathScanning("index");
    }

    protected void customizeContext(Context context) {
    }

    protected PlexusConfiguration customizeComponentConfiguration() {
        return null;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    public PlexusContainer getContainer() {
        if (this.container == null) {
            this.setupContainer();
        }
        return this.container;
    }

    protected InputStream getConfiguration() throws Exception {
        return this.getConfiguration(null);
    }

    protected InputStream getConfiguration(String subname) throws Exception {
        return this.getResourceAsStream(this.getConfigurationName(subname));
    }

    protected String getCustomConfigurationName() {
        return null;
    }

    protected String getConfigurationName(String subname) {
        Class testClass;
        for (Class clazz = testClass = this.context.getRequiredTestClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String name = clazz.getName().replace('.', '/') + ".xml";
            if (testClass.getClassLoader().getResource(name) == null) continue;
            return name;
        }
        return null;
    }

    protected InputStream getResourceAsStream(String resource) {
        return this.context.getRequiredTestClass().getResourceAsStream(resource);
    }

    protected ClassLoader getClassLoader() {
        return this.context.getRequiredTestClass().getClassLoader();
    }

    protected <T> T lookup(String componentKey) throws ComponentLookupException {
        return (T)this.getContainer().lookup(componentKey);
    }

    protected <T> T lookup(String role, String roleHint) throws ComponentLookupException {
        return (T)this.getContainer().lookup(role, roleHint);
    }

    protected <T> T lookup(Class<T> componentClass) throws ComponentLookupException {
        return (T)this.getContainer().lookup(componentClass);
    }

    protected <T> T lookup(Class<T> componentClass, String roleHint) throws ComponentLookupException {
        return (T)this.getContainer().lookup(componentClass, roleHint);
    }

    protected void release(Object component) throws ComponentLifecycleException {
        this.getContainer().release(component);
    }

    public static File getTestFile(String path) {
        return new File(PlexusExtension.getBasedir(), path);
    }

    public static File getTestFile(String basedir, String path) {
        File basedirFile = new File(basedir);
        if (!basedirFile.isAbsolute()) {
            basedirFile = PlexusExtension.getTestFile(basedir);
        }
        return new File(basedirFile, path);
    }

    public static String getTestPath(String path) {
        return PlexusExtension.getTestFile(path).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path) {
        return PlexusExtension.getTestFile(basedir, path).getAbsolutePath();
    }

    public static String getBasedir() {
        if (basedir != null) {
            return basedir;
        }
        basedir = System.getProperty("basedir");
        if (basedir == null) {
            basedir = new File("").getAbsolutePath();
        }
        return basedir;
    }

    public String getTestConfiguration() {
        return PlexusExtension.getTestConfiguration(this.context.getRequiredTestClass());
    }

    public static String getTestConfiguration(Class<?> clazz) {
        String s = clazz.getName().replace('.', '/');
        return s.substring(0, s.indexOf("$")) + ".xml";
    }

    static {
        if (System.getProperty("guice_custom_class_loading", "").trim().isEmpty()) {
            System.setProperty("guice_custom_class_loading", "CHILD");
        }
    }
}

