/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.codehaus.plexus.components.cipher.PlexusCipher;
import org.codehaus.plexus.components.cipher.PlexusCipherException;
import org.codehaus.plexus.components.secdispatcher.Dispatcher;
import org.codehaus.plexus.components.secdispatcher.DispatcherMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;
import org.codehaus.plexus.components.secdispatcher.internal.SecUtil;
import org.codehaus.plexus.components.secdispatcher.model.SettingsSecurity;

public class DefaultSecDispatcher
implements SecDispatcher {
    public static final String ATTR_START = "[";
    public static final String ATTR_STOP = "]";
    protected final PlexusCipher cipher;
    protected final Map<String, Dispatcher> dispatchers;
    protected final Path configurationFile;

    public DefaultSecDispatcher(PlexusCipher cipher, Map<String, Dispatcher> dispatchers, Path configurationFile) {
        this.cipher = Objects.requireNonNull(cipher);
        this.dispatchers = Objects.requireNonNull(dispatchers);
        this.configurationFile = Objects.requireNonNull(configurationFile);
        if (Files.isDirectory(configurationFile, new LinkOption[0])) {
            throw new IllegalArgumentException("configurationFile cannot be a directory");
        }
    }

    @Override
    public Set<DispatcherMeta> availableDispatchers() {
        return Set.copyOf(this.dispatchers.entrySet().stream().map(this::dispatcherMeta).collect(Collectors.toSet()));
    }

    private DispatcherMeta dispatcherMeta(final Map.Entry<String, Dispatcher> dispatcher) {
        Dispatcher d = dispatcher.getValue();
        if (d instanceof DispatcherMeta) {
            DispatcherMeta meta = (DispatcherMeta)((Object)d);
            return meta;
        }
        return new DispatcherMeta(){

            @Override
            public String name() {
                return (String)dispatcher.getKey();
            }

            @Override
            public String displayName() {
                return (String)dispatcher.getKey() + " (needs manual configuration)";
            }

            @Override
            public Collection<DispatcherMeta.Field> fields() {
                return List.of();
            }
        };
    }

    @Override
    public String encrypt(String str, Map<String, String> attr) throws SecDispatcherException, IOException {
        if (this.isEncryptedString(str)) {
            return str;
        }
        try {
            String name;
            Dispatcher dispatcher;
            attr = attr == null ? new HashMap<String, String>() : new HashMap<String, String>(attr);
            if (attr.get("name") == null) {
                SettingsSecurity conf = this.readConfiguration(false);
                if (conf == null) {
                    throw new SecDispatcherException("No configuration found");
                }
                String defaultDispatcher = conf.getDefaultDispatcher();
                if (defaultDispatcher == null) {
                    throw new SecDispatcherException("No defaultDispatcher set in configuration");
                }
                attr.put("name", defaultDispatcher);
            }
            if ((dispatcher = this.dispatchers.get(name = attr.get("name"))) == null) {
                throw new SecDispatcherException("No dispatcher exist with name " + name);
            }
            Dispatcher.EncryptPayload payload = dispatcher.encrypt(str, attr, this.prepareDispatcherConfig(name));
            HashMap<String, String> resultAttributes = new HashMap<String, String>(payload.getAttributes());
            resultAttributes.put("name", name);
            resultAttributes.put("version", SecUtil.specVersion());
            String res = ATTR_START + resultAttributes.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")) + ATTR_STOP;
            res = res + payload.getEncrypted();
            return this.cipher.decorate(res);
        }
        catch (PlexusCipherException e2) {
            throw new SecDispatcherException(e2.getMessage(), e2);
        }
    }

    @Override
    public String decrypt(String str) throws SecDispatcherException, IOException {
        if (!this.isEncryptedString(str)) {
            return str;
        }
        try {
            String name;
            Dispatcher dispatcher;
            String bare = this.cipher.unDecorate(str);
            Map<String, String> attr = Objects.requireNonNull(this.stripAttributes(bare));
            if (this.isLegacyPassword(str)) {
                attr.put("name", "legacy");
            }
            if ((dispatcher = this.dispatchers.get(name = attr.get("name"))) == null) {
                throw new SecDispatcherException("No dispatcher exist with name " + name);
            }
            return dispatcher.decrypt(this.strip(bare), attr, this.prepareDispatcherConfig(name));
        }
        catch (PlexusCipherException e) {
            throw new SecDispatcherException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isLegacyPassword(String str) {
        if (!this.isEncryptedString(str)) {
            return false;
        }
        Map<String, String> attr = Objects.requireNonNull(this.stripAttributes(this.cipher.unDecorate(str)));
        return !attr.containsKey("name");
    }

    @Override
    public SettingsSecurity readConfiguration(boolean createIfMissing) throws IOException {
        SettingsSecurity configuration = SecUtil.read(this.configurationFile);
        if (configuration == null && createIfMissing) {
            configuration = new SettingsSecurity();
        }
        return configuration;
    }

    @Override
    public void writeConfiguration(SettingsSecurity configuration) throws IOException {
        Objects.requireNonNull(configuration, "configuration is null");
        SecUtil.write(this.configurationFile, configuration, true);
    }

    @Override
    public SecDispatcher.ValidationResponse validateConfiguration() {
        HashMap<SecDispatcher.ValidationResponse.Level, List<String>> report = new HashMap<SecDispatcher.ValidationResponse.Level, List<String>>();
        ArrayList<SecDispatcher.ValidationResponse> subsystems = new ArrayList<SecDispatcher.ValidationResponse>();
        boolean valid = false;
        try {
            SettingsSecurity config = this.readConfiguration(false);
            if (config == null) {
                report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("No configuration file found on path " + String.valueOf(this.configurationFile));
            } else {
                report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Configuration file present on path " + String.valueOf(this.configurationFile));
                String defaultDispatcher = config.getDefaultDispatcher();
                if (defaultDispatcher == null) {
                    report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("No default dispatcher set in configuration");
                } else {
                    report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Default dispatcher configured");
                    Dispatcher dispatcher = this.dispatchers.get(defaultDispatcher);
                    if (dispatcher == null) {
                        report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Configured default dispatcher not present in system");
                    } else {
                        SecDispatcher.ValidationResponse dispatcherResponse = dispatcher.validateConfiguration(this.prepareDispatcherConfig(defaultDispatcher));
                        subsystems.add(dispatcherResponse);
                        if (!dispatcherResponse.isValid()) {
                            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Configured default dispatcher configuration is invalid");
                        } else {
                            valid = true;
                            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Configured default dispatcher configuration is valid");
                        }
                    }
                }
            }
            Dispatcher legacy = this.dispatchers.get("legacy");
            if (legacy == null) {
                report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Legacy dispatcher not present in system");
            } else {
                report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Legacy dispatcher present in system");
                SecDispatcher.ValidationResponse legacyResponse = legacy.validateConfiguration(this.prepareDispatcherConfig("legacy"));
                subsystems.add(legacyResponse);
                if (!legacyResponse.isValid()) {
                    report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.WARNING, k -> new ArrayList()).add("Legacy dispatcher not operational; transparent fallback not possible");
                } else {
                    report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Legacy dispatcher is operational; transparent fallback possible");
                }
            }
        }
        catch (IOException e) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add(e.getMessage());
        }
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), valid, report, subsystems);
    }

    protected Map<String, String> prepareDispatcherConfig(String name) throws IOException {
        HashMap<String, String> dispatcherConf = new HashMap<String, String>();
        Map<String, String> conf = SecUtil.getConfig(SecUtil.read(this.configurationFile), name);
        if (conf != null) {
            dispatcherConf.putAll(conf);
        }
        return dispatcherConf;
    }

    protected String strip(String str) {
        int start = str.indexOf(ATTR_START);
        int stop = str.indexOf(ATTR_STOP);
        if (start != -1 && stop != -1 && stop > start) {
            return str.substring(stop + 1);
        }
        return str;
    }

    protected Map<String, String> stripAttributes(String str) {
        HashMap<String, String> result = new HashMap<String, String>();
        int start = str.indexOf(ATTR_START);
        int stop = str.indexOf(ATTR_STOP);
        if (start != -1 && stop != -1 && stop > start) {
            if (start != 0) {
                throw new SecDispatcherException("Attributes can be prefix only");
            }
            if (stop == start + 1) {
                return null;
            }
            String attrs = str.substring(start + 1, stop).trim();
            if (attrs.isEmpty()) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(attrs, ",");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int pos = pair.indexOf(61);
                if (pos == -1) {
                    throw new SecDispatcherException("Attribute malformed: " + pair);
                }
                String key = pair.substring(0, pos).trim();
                String val = pair.substring(pos + 1).trim();
                result.put(key, val);
            }
        }
        return result;
    }

    protected boolean isEncryptedString(String str) {
        return this.cipher.isEncryptedString(str);
    }
}

