/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.ModuleInfoParser;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

public class AsmModuleInfoParser
implements ModuleInfoParser {
    private static final Pattern MRJAR_DESCRIPTOR = Pattern.compile("META-INF/versions/[^/]+/module-info.class");

    @Override
    public JavaModuleDescriptor getModuleDescriptor(Path modulePath) throws IOException {
        JavaModuleDescriptor descriptor;
        if (Files.isDirectory(modulePath, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(modulePath.resolve("module-info.class"), new OpenOption[0]);){
                descriptor = this.parse(in);
            }
        }
        try (JarFile jarFile = new JarFile(modulePath.toFile());){
            JarEntry moduleInfo;
            if (modulePath.toString().toLowerCase().endsWith(".jmod")) {
                moduleInfo = jarFile.getJarEntry("classes/module-info.class");
            } else {
                moduleInfo = jarFile.getJarEntry("module-info.class");
                if (moduleInfo == null) {
                    Enumeration<JarEntry> entryIter = jarFile.entries();
                    while (entryIter.hasMoreElements()) {
                        JarEntry entry = entryIter.nextElement();
                        if (!MRJAR_DESCRIPTOR.matcher(entry.getName()).matches()) continue;
                        moduleInfo = entry;
                        break;
                    }
                }
            }
            descriptor = moduleInfo != null ? this.parse(jarFile.getInputStream(moduleInfo)) : null;
        }
        return descriptor;
    }

    private JavaModuleDescriptor parse(InputStream in) throws IOException {
        final JavaModuleDescriptorWrapper wrapper = new JavaModuleDescriptorWrapper();
        ClassReader reader = new ClassReader(in);
        reader.accept(new ClassVisitor(393216){

            public ModuleVisitor visitModule(String name, int arg1, String arg2) {
                wrapper.builder = JavaModuleDescriptor.newModule(name);
                return new ModuleVisitor(393216){

                    public void visitRequire(String module, int access, String version) {
                        wrapper.builder.requires(module);
                    }

                    public void visitExport(String pn, int ms, String ... targets) {
                        if (targets == null || targets.length == 0) {
                            wrapper.builder.exports(pn.replace('/', '.'));
                        } else {
                            wrapper.builder.exports(pn.replace('/', '.'), new HashSet<String>(Arrays.asList(targets)));
                        }
                    }
                };
            }
        }, 0);
        return wrapper.builder.build();
    }

    private static class JavaModuleDescriptorWrapper {
        private JavaModuleDescriptor.Builder builder;

        private JavaModuleDescriptorWrapper() {
        }
    }
}

