/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.merge.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.codehaus.plexus.metadata.merge.MergeException;
import org.codehaus.plexus.metadata.merge.MergeStrategy;
import org.codehaus.plexus.metadata.merge.support.AbstractMergeableSupport;
import org.codehaus.plexus.metadata.merge.support.Mergeable;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractMergeableElement
extends AbstractMergeableSupport {
    public AbstractMergeableElement(Element element) {
        super(element);
    }

    protected boolean isRecessiveElementInConflict(AbstractMergeableElement re, String eltName) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(eltName);
        return this.isRecessiveElementInConflict(re, l);
    }

    protected boolean isRecessiveElementInConflict(AbstractMergeableElement re, List eltNameList) {
        if (null == (eltNameList = this.getElementNamesForConflictResolution(eltNameList)) || eltNameList.size() == 0) {
            return false;
        }
        for (String eltName : eltNameList) {
            String dEltValue = this.getChildTextTrim(eltName);
            String rEltValue = re.getChildTextTrim(eltName);
            if (null != dEltValue && null != rEltValue && dEltValue.equals(rEltValue)) continue;
            return false;
        }
        return true;
    }

    protected boolean mergeableElementComesFromRecessive(AbstractMergeableElement re, String eltName) {
        return null == this.getChildText(eltName) && null != re.getChildText(eltName);
    }

    public void merge(Mergeable me, MergeStrategy strategy) throws MergeException {
        strategy.apply(this, me);
    }

    public void merge(Mergeable me) throws MergeException {
        if (!this.isExpectedElementType(me)) {
            throw new MergeException("Cannot Merge dissimilar elements. (Expected : '" + this.getClass().getName() + "', found '" + me.getClass().getName() + "')");
        }
        AbstractMergeableElement rce = (AbstractMergeableElement)me;
        HashSet<String> allowedTags = new HashSet<String>();
        for (int i = 0; i < this.getAllowedTags().length; ++i) {
            String tagName = this.getAllowedTags()[i].getTagName();
            allowedTags.add(tagName);
            ArrayList<String> defaultConflictChecklist = new ArrayList<String>();
            defaultConflictChecklist.add(tagName);
            if (!this.isRecessiveElementInConflict(rce, defaultConflictChecklist) && this.mergeableElementComesFromRecessive(rce, tagName)) {
                this.addContent((Content)((Element)rce.getChild(tagName).clone()));
                continue;
            }
            if (!this.getAllowedTags()[i].isMergeable() || !this.isRecessiveElementInConflict(rce, defaultConflictChecklist)) continue;
            try {
                this.getAllowedTags()[i].createMergeable(this.getChild(tagName)).merge(this.getAllowedTags()[i].createMergeable(rce.getChild(tagName)), this.getDefaultMergeStrategy());
                continue;
            }
            catch (Exception e) {
                throw new MergeException("Unable to create Mergeable instance for tag '" + this.getAllowedTags()[i] + "'.", e);
            }
        }
        for (Element child : me.getElement().getChildren()) {
            if (allowedTags.contains(child.getName())) continue;
            this.element.addContent((Content)child.clone());
        }
    }
}

