/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.metadata.ExtractorConfiguration;
import org.codehaus.plexus.metadata.MetadataGenerator;
import org.codehaus.plexus.tools.cli.AbstractCli;

public class PlexusMetadataGeneratorCli
extends AbstractCli {
    public static final char SOURCE_DIRECTORY = 's';
    public static final char CLASSES_DIRECTORY = 'c';
    public static final char OUTPUT_FILE = 'o';

    public static void main(String[] args) throws Exception {
        new PlexusMetadataGeneratorCli().execute(args);
    }

    public String getPomPropertiesPath() {
        return "META-INF/maven/org.codehaus.plexus/plexus-metadata-generator/pom.properties";
    }

    public Options buildCliOptions(Options options) {
        OptionBuilder.withLongOpt((String)"source");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Source directory.");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"classes");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Classes directory.");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output directory.");
        options.addOption(OptionBuilder.create((char)'o'));
        return options;
    }

    public void invokePlexusComponent(CommandLine cli, PlexusContainer plexus) throws Exception {
        MetadataGenerator mg = (MetadataGenerator)plexus.lookup(MetadataGenerator.class);
        ExtractorConfiguration extractorConfiguration = new ExtractorConfiguration();
        extractorConfiguration.classesDirectory = new File(cli.getOptionValue('c'));
        extractorConfiguration.classpath = Collections.EMPTY_LIST;
        extractorConfiguration.sourceDirectories = Arrays.asList(new File(cli.getOptionValue('s')).getAbsolutePath());
        extractorConfiguration.useContextClassLoader = true;
        mg.generateDescriptor(extractorConfiguration, new File(cli.getOptionValue('o')));
    }
}

