/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.testing.PlexusTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

@PlexusTest
public abstract class AbstractCompilerTckTest {
    private static final String EOL = System.lineSeparator();
    protected String roleHint;
    private TestInfo testInfo;
    @Inject
    private Map<String, Compiler> compilers;

    @BeforeEach
    final void setup(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    @Test
    public void testDeprecation() throws Exception {
        File foo = new File(this.getSrc(), "Foo.java");
        this.writeFileWithDeprecatedApi(foo, "Foo");
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setShowDeprecation(true);
        configuration.addSourceLocation(this.getSrc().getAbsolutePath());
        List<CompilerMessage> result = this.compile(configuration);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)1));
        CompilerMessage error = result.get(0);
        MatcherAssert.assertThat((Object)error.isError(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"Date"));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"deprecated"));
    }

    @Test
    public void testWarning() throws Exception {
        File foo = new File(this.getSrc(), "Foo.java");
        this.writeFileWithWarning(foo, "Foo");
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setShowWarnings(true);
        configuration.addSourceLocation(this.getSrc().getAbsolutePath());
        List<CompilerMessage> result = this.compile(configuration);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Object)1));
        CompilerMessage error = result.get(0);
        MatcherAssert.assertThat((Object)error.isError(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"finally block does not complete normally"));
    }

    protected List<CompilerMessage> compile(CompilerConfiguration configuration) throws Exception {
        File compilerOutput = this.getCompilerOutput();
        if (compilerOutput.exists()) {
            FileUtils.deleteDirectory((File)compilerOutput);
        }
        configuration.setOutputLocation(compilerOutput.getAbsolutePath());
        List result = this.getCompiler().performCompile(configuration).getCompilerMessages();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        return result;
    }

    private Compiler getCompiler() {
        return this.compilers.get(this.roleHint);
    }

    private File getCompilerOutput() {
        return new File("target/compiler-output/" + this.testInfo.getTestMethod().map(Method::getName).orElseThrow(null));
    }

    private File getSrc() {
        return new File("target/compiler-src/" + this.testInfo.getTestMethod().map(Method::getName).orElseThrow(null));
    }

    protected void writeFileWithDeprecatedApi(File path, String className) throws IOException {
        File parent = path.getParentFile();
        if (!parent.exists()) {
            MatcherAssert.assertThat((Object)parent.mkdirs(), (Matcher)Matchers.is((Object)true));
        }
        String source = "import java.util.Date;" + EOL + "" + EOL + "public class " + className + "" + EOL + "{" + EOL + "    private static Date date = new Date( \"foo\" );" + EOL + "    static " + EOL + "    { " + EOL + "        Date date = " + className + ".date; " + EOL + "        Date date2 = date; " + EOL + "        date = date2; " + EOL + "    }" + EOL + "}";
        org.codehaus.plexus.util.FileUtils.fileWrite((String)path.getAbsolutePath(), (String)source);
    }

    protected void writeFileWithWarning(File path, String className) throws IOException {
        File parent = path.getParentFile();
        if (!parent.exists()) {
            MatcherAssert.assertThat((Object)parent.mkdirs(), (Matcher)Matchers.is((Object)true));
        }
        String source = "public class " + className + "" + EOL + "{" + EOL + "    public void foo()" + EOL + "    {" + EOL + "        try{ throw new java.io.IOException(); }" + EOL + "        finally { return; }" + EOL + "    }" + EOL + "}";
        org.codehaus.plexus.util.FileUtils.fileWrite((String)path.getAbsolutePath(), (String)source);
    }
}

