/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.test.ArtifactTestCase;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompilerTest
extends ArtifactTestCase {
    private boolean compilerDebug = false;
    private boolean compilerDeprecationWarnings = false;

    protected abstract String getRoleHint();

    protected void setCompilerDebug(boolean flag) {
        this.compilerDebug = flag;
    }

    protected void setCompilerDeprecationWarnings(boolean flag) {
        this.compilerDeprecationWarnings = flag;
    }

    protected List<String> getClasspath() throws Exception {
        ArrayList<String> cp = new ArrayList<String>();
        File file = this.getLocalArtifactPath("commons-lang", "commons-lang", "2.0", "jar");
        AbstractCompilerTest.assertTrue((String)("test prerequisite: commons-lang library must be available in local repository, expected " + file.getAbsolutePath()), (boolean)file.canRead());
        cp.add(file.getAbsolutePath());
        return cp;
    }

    public void testCompilingSources() throws Exception {
        ArrayList<CompilerError> messages = new ArrayList<CompilerError>();
        TreeSet<String> files = new TreeSet<String>();
        for (CompilerConfiguration compilerConfig : this.getCompilerConfigurations()) {
            File outputDir = new File(compilerConfig.getOutputLocation());
            Compiler compiler = (Compiler)this.lookup(Compiler.ROLE, this.getRoleHint());
            messages.addAll(compiler.compile(compilerConfig));
            if (!outputDir.isDirectory()) continue;
            files.addAll(this.normalizePaths(FileUtils.getFileNames((File)outputDir, null, null, (boolean)false)));
        }
        int numCompilerErrors = this.compilerErrorCount(messages);
        int numCompilerWarnings = messages.size() - numCompilerErrors;
        if (this.expectedErrors() != numCompilerErrors) {
            System.err.println(numCompilerErrors + " error(s) found:");
            for (CompilerError error : messages) {
                if (!error.isError()) continue;
                System.err.println("----");
                System.err.println(error.getFile());
                System.err.println(error.getMessage());
                System.err.println("----");
            }
            AbstractCompilerTest.assertEquals((String)"Wrong number of compilation errors.", (int)this.expectedErrors(), (int)numCompilerErrors);
        }
        if (this.expectedWarnings() != numCompilerWarnings) {
            System.err.println(numCompilerWarnings + " warning(s) found:");
            for (CompilerError error : messages) {
                if (error.isError()) continue;
                System.err.println("----");
                System.err.println(error.getFile());
                System.err.println(error.getMessage());
                System.err.println("----");
            }
            AbstractCompilerTest.assertEquals((String)"Wrong number of compilation warnings.", (int)this.expectedWarnings(), (int)numCompilerWarnings);
        }
        AbstractCompilerTest.assertEquals(new TreeSet<String>(this.normalizePaths(this.expectedOutputFiles())), files);
    }

    private List<CompilerConfiguration> getCompilerConfigurations() throws Exception {
        String sourceDir = AbstractCompilerTest.getBasedir() + "/src/test-input/src/main";
        List filenames = FileUtils.getFileNames((File)new File(sourceDir), (String)"**/*.java", null, (boolean)false, (boolean)true);
        Collections.sort(filenames);
        ArrayList<CompilerConfiguration> compilerConfigurations = new ArrayList<CompilerConfiguration>();
        int index = 0;
        for (String filename : filenames) {
            CompilerConfiguration compilerConfig = new CompilerConfiguration();
            compilerConfig.setDebug(this.compilerDebug);
            compilerConfig.setShowDeprecation(this.compilerDeprecationWarnings);
            compilerConfig.setClasspathEntries(this.getClasspath());
            compilerConfig.addSourceLocation(sourceDir);
            compilerConfig.setOutputLocation(AbstractCompilerTest.getBasedir() + "/target/" + this.getRoleHint() + "/classes-" + index);
            compilerConfig.addInclude(filename);
            compilerConfigurations.add(compilerConfig);
            ++index;
        }
        return compilerConfigurations;
    }

    private List<String> normalizePaths(Collection<String> relativePaths) {
        ArrayList<String> normalizedPaths = new ArrayList<String>();
        for (String relativePath : relativePaths) {
            normalizedPaths.add(relativePath.replace(File.separatorChar, '/'));
        }
        return normalizedPaths;
    }

    protected int compilerErrorCount(List<CompilerError> messages) {
        int count = 0;
        for (CompilerError message : messages) {
            count += message.isError() ? 1 : 0;
        }
        return count;
    }

    protected int expectedErrors() {
        return 1;
    }

    protected int expectedWarnings() {
        return 0;
    }

    protected Collection<String> expectedOutputFiles() {
        return Collections.emptyList();
    }

    protected File getLocalArtifactPath(String groupId, String artifactId, String version, String type) {
        VersionRange versionRange = VersionRange.createFromVersion((String)version);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, versionRange, "compile", type, null, (ArtifactHandler)new DefaultArtifactHandler(type));
        return this.getLocalArtifactPath((Artifact)artifact);
    }
}

