/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.ajc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.tools.ajc.Main;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.ajc.AspectJCompilerConfiguration;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Compiler.class, hint="aspectj")
public class AspectJCompiler
extends AbstractCompiler {
    public AspectJCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = AspectJCompiler.getSourceFiles((CompilerConfiguration)config)).length == 0) {
            return new CompilerResult();
        }
        System.out.println("Compiling " + sourceFiles.length + " source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        AjBuildConfig buildConfig = this.buildCompilerConfig(config);
        return new CompilerResult().compilerMessages(this.compileInProcess(buildConfig));
    }

    private AjBuildConfig buildCompilerConfig(CompilerConfiguration config) throws CompilerException {
        String outputLocation;
        LinkedHashMap javaOpts;
        AjBuildConfig buildConfig = new AjBuildConfig(new BuildArgParser((IMessageHandler)new AspectJMessagePrinter(config.isVerbose())));
        buildConfig.setIncrementalMode(false);
        String[] files = AspectJCompiler.getSourceFiles((CompilerConfiguration)config);
        if (files != null) {
            buildConfig.setFiles(this.buildFileList(Arrays.asList(files)));
        }
        this.setSourceVersion(buildConfig, config.getSourceVersion());
        if (config.isDebug()) {
            buildConfig.getOptions().produceDebugAttributes = 7;
        }
        if ((javaOpts = config.getCustomCompilerArguments()) == null || !javaOpts.isEmpty()) {
            // empty if block
        }
        LinkedList<String> cp = new LinkedList<String>(config.getClasspathEntries());
        File javaHomeDir = new File(System.getProperty("java.home"));
        File[] jars = new File(javaHomeDir, "lib").listFiles();
        if (jars != null) {
            for (File jar : jars) {
                if (!jar.getName().endsWith(".jar") && !jar.getName().endsWith(".zip")) continue;
                cp.add(0, jar.getAbsolutePath());
            }
        }
        if ((jars = new File(javaHomeDir, "../Classes").listFiles()) != null) {
            for (File jar : jars) {
                if (!jar.getName().endsWith(".jar") && !jar.getName().endsWith(".zip")) continue;
                cp.add(0, jar.getAbsolutePath());
            }
        }
        this.checkForAspectJRT(cp);
        if (cp != null && !cp.isEmpty()) {
            ArrayList<String> elements = new ArrayList<String>(cp.size());
            for (String path : cp) {
                elements.add(new File(path).getAbsolutePath());
            }
            buildConfig.setClasspath(elements);
        }
        if ((outputLocation = config.getOutputLocation()) != null) {
            File outDir = new File(outputLocation);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            buildConfig.setOutputDir(outDir);
        }
        if (config instanceof AspectJCompilerConfiguration) {
            String outJar;
            List<File> inPaths;
            List<File> inJars;
            List<File> aspectPath;
            Map<String, String> ajOptions;
            AspectJCompilerConfiguration ajCfg = (AspectJCompilerConfiguration)config;
            Map<String, File> sourcePathResources = ajCfg.getSourcePathResources();
            if (sourcePathResources != null && !sourcePathResources.isEmpty()) {
                buildConfig.setSourcePathResources(sourcePathResources);
            }
            if ((ajOptions = ajCfg.getAJOptions()) == null || !ajOptions.isEmpty()) {
                // empty if block
            }
            if ((aspectPath = this.buildFileList(ajCfg.getAspectPath())) != null && !aspectPath.isEmpty()) {
                buildConfig.setAspectpath(this.buildFileList(ajCfg.getAspectPath()));
            }
            if ((inJars = this.buildFileList(ajCfg.getInJars())) != null && !inJars.isEmpty()) {
                buildConfig.setInJars(this.buildFileList(ajCfg.getInJars()));
            }
            if ((inPaths = this.buildFileList(ajCfg.getInPath())) != null && !inPaths.isEmpty()) {
                buildConfig.setInPath(this.buildFileList(ajCfg.getInPath()));
            }
            if ((outJar = ajCfg.getOutputJar()) != null) {
                buildConfig.setOutputJar(new File(ajCfg.getOutputJar()));
            }
        }
        return buildConfig;
    }

    private List<CompilerMessage> compileInProcess(AjBuildConfig buildConfig) throws CompilerException {
        MessageHandler messageHandler = new MessageHandler();
        AjBuildManager manager = new AjBuildManager((IMessageHandler)messageHandler);
        try {
            manager.batchBuild(buildConfig, (IMessageHandler)messageHandler);
        }
        catch (AbortException e) {
            throw new CompilerException("Unknown error while compiling", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Unknown error while compiling", (Throwable)e);
        }
        boolean errors = messageHandler.hasAnyMessage(IMessage.ERROR, true);
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        if (errors) {
            IMessage[] errorMessages;
            for (IMessage m : errorMessages = messageHandler.getMessages(IMessage.ERROR, true)) {
                ISourceLocation sourceLocation = m.getSourceLocation();
                CompilerMessage error = sourceLocation == null ? new CompilerMessage(m.getMessage(), true) : new CompilerMessage(sourceLocation.getSourceFile().getPath(), true, sourceLocation.getLine(), sourceLocation.getColumn(), sourceLocation.getEndLine(), sourceLocation.getColumn(), m.getMessage());
                messages.add(error);
            }
        }
        return messages;
    }

    private void checkForAspectJRT(List<String> cp) {
        if (cp == null || cp.isEmpty()) {
            throw new IllegalStateException("AspectJ Runtime not found in supplied classpath");
        }
        try {
            URL[] urls = new URL[cp.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File(cp.get(i)).toURL();
            }
            URLClassLoader cloader = new URLClassLoader(urls);
            cloader.loadClass("org.aspectj.lang.JoinPoint");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid classpath entry");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AspectJ Runtime not found in supplied classpath");
        }
    }

    private List<File> buildFileList(List<String> locations) {
        LinkedList<File> fileList = new LinkedList<File>();
        for (String location : locations) {
            fileList.add(new File(location));
        }
        return fileList;
    }

    private void setSourceVersion(AjBuildConfig buildConfig, String sourceVersion) throws CompilerException {
        if ("11".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x370000L;
        } else if ("10".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x360000L;
        } else if ("9".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x350000L;
        } else if ("1.9".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x350000L;
        } else if ("1.8".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x340000L;
        } else if ("1.7".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x330000L;
        } else if ("1.6".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x320000L;
        } else if ("1.5".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x310000L;
        } else if ("5.0".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x310000L;
        } else if ("1.4".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x300000L;
        } else if ("1.3".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x2F0000L;
        } else if ("1.2".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 0x2E0000L;
        } else if ("1.1".equals(sourceVersion)) {
            buildConfig.getOptions().sourceLevel = 2949123L;
        } else if (sourceVersion == null || sourceVersion.length() <= 0) {
            buildConfig.getOptions().sourceLevel = 0x2F0000L;
        } else {
            throw new CompilerException("The source version was not recognized: " + sourceVersion);
        }
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return null;
    }

    private static class AspectJMessagePrinter
    extends Main.MessagePrinter {
        public AspectJMessagePrinter(boolean verbose) {
            super(verbose);
        }
    }
}

