/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.cipher.internal;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.cipher.PlexusCipher;
import org.codehaus.plexus.components.cipher.PlexusCipherException;
import org.codehaus.plexus.components.cipher.internal.Cipher;

@Singleton
@Named
public class DefaultPlexusCipher
implements PlexusCipher {
    private static final Pattern ENCRYPTED_STRING_PATTERN = Pattern.compile(".*?[^\\\\]?\\{(.*?[^\\\\])}.*");
    private static final String ENCRYPTED_STRING_DECORATION_START = "{";
    private static final String ENCRYPTED_STRING_DECORATION_STOP = "}";
    private final Map<String, Cipher> ciphers;

    @Inject
    public DefaultPlexusCipher(Map<String, Cipher> ciphers) {
        this.ciphers = Objects.requireNonNull(ciphers);
    }

    @Override
    public Set<String> availableCiphers() {
        return Collections.unmodifiableSet(this.ciphers.keySet());
    }

    @Override
    public String encrypt(String alg, String str, String passPhrase) throws PlexusCipherException {
        Objects.requireNonNull(alg);
        Objects.requireNonNull(str);
        Objects.requireNonNull(passPhrase);
        if (str.isEmpty()) {
            return str;
        }
        return this.requireCipher(alg).encrypt(str, passPhrase);
    }

    @Override
    public String encryptAndDecorate(String alg, String str, String passPhrase) throws PlexusCipherException {
        return this.decorate(this.encrypt(alg, str, passPhrase));
    }

    @Override
    public String decrypt(String alg, String str, String passPhrase) throws PlexusCipherException {
        Objects.requireNonNull(alg);
        Objects.requireNonNull(str);
        Objects.requireNonNull(passPhrase);
        if (str.isEmpty()) {
            return str;
        }
        return this.requireCipher(alg).decrypt(str, passPhrase);
    }

    @Override
    public String decryptDecorated(String alg, String str, String passPhrase) throws PlexusCipherException {
        Objects.requireNonNull(alg);
        Objects.requireNonNull(str);
        Objects.requireNonNull(passPhrase);
        if (str.isEmpty()) {
            return str;
        }
        if (this.isEncryptedString(str)) {
            str = this.unDecorate(str);
        }
        return this.decrypt(alg, str, passPhrase);
    }

    @Override
    public boolean isEncryptedString(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        return matcher.matches() || matcher.find();
    }

    @Override
    public String unDecorate(String str) throws PlexusCipherException {
        Objects.requireNonNull(str);
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        if (matcher.matches() || matcher.find()) {
            return matcher.group(1);
        }
        throw new PlexusCipherException("Malformed decorated string");
    }

    @Override
    public String decorate(String str) {
        return ENCRYPTED_STRING_DECORATION_START + (str == null ? "" : str) + ENCRYPTED_STRING_DECORATION_STOP;
    }

    private Cipher requireCipher(String alg) throws PlexusCipherException {
        Cipher cipher = this.ciphers.get(alg);
        if (cipher == null) {
            throw new PlexusCipherException("Unsupported alg: " + alg);
        }
        return cipher;
    }

    public static String[] getServiceTypes() {
        HashSet<String> result = new HashSet<String>();
        for (Provider provider : Security.getProviders()) {
            Set<Object> keys = provider.keySet();
            for (Object o : keys) {
                String key = (String)o;
                if ((key = key.split(" ")[0]).startsWith("Alg.Alias.")) {
                    key = key.substring(10);
                }
                int ix = key.indexOf(46);
                result.add(key.substring(0, ix));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] getCryptoImpls(String serviceType) {
        Provider[] providers;
        HashSet<String> result = new HashSet<String>();
        for (Provider provider : providers = Security.getProviders()) {
            Set<Object> keys = provider.keySet();
            for (Object o : keys) {
                String key = (String)o;
                if ((key = key.split(" ")[0]).startsWith(serviceType + ".")) {
                    result.add(key.substring(serviceType.length() + 1));
                    continue;
                }
                if (!key.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(key.substring(serviceType.length() + 11));
            }
        }
        return result.toArray(new String[0]);
    }

    public static void main(String[] args) {
        String[] serviceTypes;
        for (String serviceType : serviceTypes = DefaultPlexusCipher.getServiceTypes()) {
            System.out.println(serviceType + ": provider list");
            for (String provider : DefaultPlexusCipher.getCryptoImpls(serviceType)) {
                System.out.println("        " + provider);
            }
        }
    }
}

