/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webstart.ResolvedJarResource;
import org.codehaus.plexus.util.WriterFactory;

public class VersionXmlGenerator {
    private final String encoding;

    public VersionXmlGenerator(String encoding) {
        this.encoding = encoding;
    }

    public void generate(File outputDir, Collection<ResolvedJarResource> jarResources) throws MojoExecutionException {
        if (outputDir == null) {
            throw new IllegalArgumentException("outputDir must not be null");
        }
        BufferedWriter writer = null;
        try {
            File versionXmlFile = new File(outputDir, "version.xml");
            writer = new BufferedWriter(WriterFactory.newWriter((File)versionXmlFile, (String)this.encoding));
            this.generateXml(writer, jarResources);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create the version.xml file", (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void generateXml(BufferedWriter writer, Collection<ResolvedJarResource> jarResources) throws IOException {
        writer.write("<?xml version=\"1.0\"?>");
        writer.newLine();
        writer.write("<jnlp-versions>");
        writer.newLine();
        for (ResolvedJarResource jarResource : jarResources) {
            writer.write("  <resource>");
            writer.newLine();
            writer.write("    <pattern>");
            writer.newLine();
            writer.write("      <name>");
            writer.write(jarResource.getHrefValue());
            writer.write("</name>");
            writer.newLine();
            writer.write("      <version-id>");
            writer.write(jarResource.getVersion());
            writer.write("</version-id>");
            writer.newLine();
            writer.write("    </pattern>");
            writer.newLine();
            writer.write("    <file>");
            writer.write(jarResource.getArtifact().getFile().getName());
            writer.write("</file>");
            writer.newLine();
            writer.write("  </resource>");
            writer.newLine();
        }
        writer.write("</jnlp-versions>");
        writer.newLine();
    }
}

