/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.util.Collection;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.webstart.ResolvedJarResource;
import org.codehaus.mojo.webstart.generator.AbstractGenerator;
import org.codehaus.mojo.webstart.generator.GeneratorTechnicalConfig;
import org.codehaus.mojo.webstart.generator.JarResourceGeneratorConfig;
import org.codehaus.plexus.util.StringUtils;

public class JarResourcesGenerator
extends AbstractGenerator<JarResourceGeneratorConfig> {
    public JarResourcesGenerator(Log log, GeneratorTechnicalConfig technicalConfig, JarResourceGeneratorConfig extraConfig) {
        super(log, technicalConfig, extraConfig);
    }

    @Override
    protected String getArgumentsText() {
        StringBuilder buffer = new StringBuilder();
        if (((JarResourceGeneratorConfig)this.getExtraConfig()).getArguments() != null) {
            for (String argument : ((JarResourceGeneratorConfig)this.getExtraConfig()).getArguments()) {
                buffer.append("<argument>").append(argument).append("</argument>").append(EOL);
            }
        }
        return buffer.toString();
    }

    @Override
    protected String getDependenciesText() {
        String jarResourcesText = "";
        String libPath = ((JarResourceGeneratorConfig)this.getExtraConfig()).getLibPath();
        Collection<ResolvedJarResource> jarResources = ((JarResourceGeneratorConfig)this.getExtraConfig()).getJarResources();
        if (jarResources.size() != 0) {
            int multiplier = 100;
            StringBuilder buffer = new StringBuilder(100 * jarResources.size());
            buffer.append(EOL);
            for (ResolvedJarResource jarResource : jarResources) {
                if (!jarResource.isIncludeInJnlp()) continue;
                buffer.append("<jar href=\"");
                if (StringUtils.isNotEmpty((String)libPath)) {
                    buffer.append(libPath);
                    buffer.append('/');
                }
                buffer.append(jarResource.getHrefValue());
                buffer.append("\"");
                if (jarResource.isOutputJarVersion()) {
                    buffer.append(" version=\"").append(jarResource.getVersion()).append("\"");
                }
                if (jarResource.getMainClass() != null) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>").append(EOL);
            }
            jarResourcesText = buffer.toString();
        }
        return jarResourcesText;
    }
}

