/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.velocity.VelocityContext;
import org.codehaus.mojo.webstart.JnlpExtension;
import org.codehaus.mojo.webstart.generator.AbstractGenerator;
import org.codehaus.mojo.webstart.generator.GeneratorConfig;
import org.codehaus.mojo.webstart.generator.GeneratorExtraConfigWithDeps;
import org.codehaus.mojo.webstart.generator.GeneratorTechnicalConfig;

public class Generator
extends AbstractGenerator<GeneratorConfig> {
    public Generator(Log log, GeneratorTechnicalConfig technicalConfig, GeneratorConfig extraConfig) {
        super(log, technicalConfig, extraConfig);
    }

    @Override
    protected String getArgumentsText() {
        return "";
    }

    @Override
    protected String getDependenciesText() {
        return this.indentText(4, Generator.getDependenciesText((GeneratorConfig)this.getExtraConfig()));
    }

    @Override
    protected VelocityContext createAndPopulateContext() {
        VelocityContext context = super.createAndPopulateContext();
        if (((GeneratorConfig)this.getExtraConfig()).hasJnlpExtensions()) {
            context.put("extensions", (Object)this.indentText(4, Generator.getExtensionsText((GeneratorConfig)this.getExtraConfig())));
        } else {
            context.put("extensions", (Object)"");
        }
        return context;
    }

    static String getDependenciesText(GeneratorConfig config) {
        return Generator.getDependenciesText(config, config.getPackagedJnlpArtifacts());
    }

    static String getDependenciesText(GeneratorExtraConfigWithDeps config, Collection<Artifact> artifacts) {
        String dependenciesText = "";
        if (!artifacts.isEmpty()) {
            StringBuilder buffer = new StringBuilder(100 * artifacts.size());
            buffer.append(EOL);
            if (config.isPack200()) {
                buffer.append("<property name=\"jnlp.packEnabled\" value=\"true\" />").append(EOL);
            }
            if (config.isOutputJarVersions()) {
                buffer.append("<property name=\"jnlp.versionEnabled\" value=\"true\" />").append(EOL);
            }
            String jarLibPath = null;
            if (config.getLibPath() != null) {
                jarLibPath = config.getLibPath();
                jarLibPath = jarLibPath != null && jarLibPath.trim().length() != 0 ? jarLibPath.trim() : null;
            }
            for (Artifact artifact : artifacts) {
                String filename;
                buffer.append("<jar href=\"");
                if (jarLibPath != null) {
                    buffer.append(jarLibPath).append("/");
                }
                if (config.isOutputJarVersions()) {
                    filename = config.getDependencyFilename(artifact, null, config.isUseUniqueVersions());
                    buffer.append(filename).append("\"");
                    if (config.isUseUniqueVersions()) {
                        buffer.append(" version=\"").append(artifact.getBaseVersion()).append("\"");
                    } else {
                        buffer.append(" version=\"").append(artifact.getVersion()).append("\"");
                    }
                } else {
                    filename = config.getDependencyFilename(artifact, false, config.isUseUniqueVersions());
                    buffer.append(filename).append("\"");
                }
                if (config.isArtifactWithMainClass(artifact)) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>").append(EOL);
            }
            dependenciesText = buffer.toString();
        }
        return dependenciesText;
    }

    static String getExtensionsText(GeneratorConfig config) {
        String text = "";
        List<JnlpExtension> extensions = config.getJnlpExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            StringBuilder buffer = new StringBuilder(100 * extensions.size());
            buffer.append("\n");
            for (JnlpExtension extension : extensions) {
                buffer.append("<extension name=\"");
                buffer.append(extension.getName());
                buffer.append("\" href=\"");
                buffer.append(extension.getOutputFile());
                buffer.append("\"/>").append(EOL);
            }
            text = buffer.toString();
        }
        return text;
    }
}

