/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.rule;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.model.io.stax.RuleStaxReader;
import org.codehaus.mojo.versions.rule.RuleService;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;

public class RulesServiceBuilder {
    private static final String CLASSPATH_PROTOCOL = "classpath";
    private Collection<String> ignoredVersions;
    private RuleSet ruleSet;
    private String serverId;
    private String rulesUri;
    private Log log;
    private MavenSession mavenSession;
    private Map<String, Wagon> wagonMap;

    public RulesServiceBuilder withIgnoredVersions(Collection<String> ignoredVersions) {
        this.ignoredVersions = ignoredVersions;
        return this;
    }

    public RulesServiceBuilder withRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
        return this;
    }

    public RulesServiceBuilder withServerId(String serverId) {
        this.serverId = serverId;
        return this;
    }

    public RulesServiceBuilder withRulesUri(String rulesUri) {
        this.rulesUri = rulesUri;
        return this;
    }

    public RulesServiceBuilder withLog(Log log) {
        this.log = log;
        return this;
    }

    public RulesServiceBuilder withMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
        return this;
    }

    public RulesServiceBuilder withWagonMap(Map<String, Wagon> wagonMap) {
        this.wagonMap = wagonMap;
        return this;
    }

    public RuleService build() throws MojoExecutionException {
        RuleSet ruleSet;
        assert (this.mavenSession != null);
        assert (this.log != null);
        if (this.ruleSet != null) {
            if (!StringUtils.isBlank((CharSequence)this.rulesUri)) {
                this.log.warn((CharSequence)"rulesUri is ignored if rules are specified in pom or as parameters");
            }
            ruleSet = this.ruleSet;
        } else {
            RuleSet ruleSet2 = StringUtils.isBlank((CharSequence)this.rulesUri) ? new RuleSet() : (ruleSet = this.rulesUri.startsWith("classpath:") ? RulesServiceBuilder.getRulesFromClasspath(this.rulesUri, this.log) : this.getRulesUsingWagon(this.rulesUri));
        }
        if (this.ignoredVersions != null && !this.ignoredVersions.isEmpty()) {
            ruleSet = RulesServiceBuilder.enrichRuleSet(this.ignoredVersions, ruleSet);
        }
        return new RuleService(this.log, ruleSet);
    }

    private static RuleSet getRulesFromClasspath(String uri, Log logger) throws MojoExecutionException {
        RuleSet ruleSet;
        logger.debug((CharSequence)("Going to load rules from \"" + uri + "\""));
        String choppedUrl = uri.substring(CLASSPATH_PROTOCOL.length() + 3);
        URL url = DefaultVersionsHelper.class.getResource(choppedUrl);
        if (url == null) {
            throw new MojoExecutionException("Resource \"" + uri + "\" not found in classpath.");
        }
        BufferedInputStream bis = new BufferedInputStream(url.openStream());
        try {
            RuleSet result = new RuleStaxReader().read((InputStream)bis);
            logger.debug((CharSequence)("Loaded rules from \"" + uri + "\" successfully"));
            ruleSet = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLStreamException e) {
                throw new MojoExecutionException("Could not load specified rules from " + uri, e);
            }
        }
        bis.close();
        return ruleSet;
    }

    private RuleSet getRulesUsingWagon(String rulesUri) throws MojoExecutionException {
        RulesUri uri;
        try {
            uri = RulesUri.build(rulesUri);
        }
        catch (URISyntaxException e) {
            this.log.warn((CharSequence)("Invalid rulesUri protocol: " + e.getMessage()));
            return null;
        }
        RemoteRepository repository = this.remoteRepository(uri);
        return Optional.ofNullable(this.wagonMap.get(repository.getProtocol())).map(wagon -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).orElseThrow(() -> new MojoExecutionException("Could not load specified rules from " + rulesUri));
    }

    private Optional<AuthenticationInfo> getAuthenticationInfo(final RemoteRepository repository) {
        return Optional.ofNullable(repository.getAuthentication()).map(authentication -> new AuthenticationInfo(this){
            final /* synthetic */ RulesServiceBuilder this$0;
            {
                this.this$0 = this$0;
                try (AuthenticationContext authCtx = AuthenticationContext.forRepository((RepositorySystemSession)this.this$0.mavenSession.getRepositorySession(), (RemoteRepository)repository);){
                    Optional.ofNullable(authCtx.get("username")).ifPresent(arg_0 -> (this).setUserName(arg_0));
                    Optional.ofNullable(authCtx.get("password")).ifPresent(arg_0 -> (this).setPassword(arg_0));
                    Optional.ofNullable(authCtx.get("privateKey.passphrase")).ifPresent(arg_0 -> (this).setPassphrase(arg_0));
                    Optional.ofNullable(authCtx.get("privateKey.path")).ifPresent(arg_0 -> (this).setPrivateKey(arg_0));
                }
            }
        });
    }

    private Repository wagonRepository(RemoteRepository repository) {
        return new Repository(repository.getId(), repository.getUrl());
    }

    private Optional<ProxyInfo> getProxyInfo(RemoteRepository repository) {
        return Optional.ofNullable(repository.getProxy()).map(proxy -> new ProxyInfo(this, (Proxy)proxy, repository){
            final /* synthetic */ Proxy val$proxy;
            final /* synthetic */ RemoteRepository val$repository;
            final /* synthetic */ RulesServiceBuilder this$0;
            {
                this.val$proxy = proxy;
                this.val$repository = remoteRepository;
                this.this$0 = this$0;
                this.setHost(this.val$proxy.getHost());
                this.setPort(this.val$proxy.getPort());
                this.setType(this.val$proxy.getType());
                Optional.ofNullable(this.val$proxy.getAuthentication()).ifPresent(auth -> {
                    try (AuthenticationContext authCtx = AuthenticationContext.forProxy((RepositorySystemSession)this.this$0.mavenSession.getRepositorySession(), (RemoteRepository)this.val$repository);){
                        Optional.ofNullable(authCtx.get("username")).ifPresent(arg_0 -> (this).setUserName(arg_0));
                        Optional.ofNullable(authCtx.get("password")).ifPresent(arg_0 -> (this).setPassword(arg_0));
                        Optional.ofNullable(authCtx.get("ntlm.domain")).ifPresent(arg_0 -> (this).setNtlmDomain(arg_0));
                        Optional.ofNullable(authCtx.get("ntlm.workstation")).ifPresent(arg_0 -> (this).setNtlmHost(arg_0));
                    }
                });
            }
        });
    }

    private RemoteRepository remoteRepository(RulesUri uri) {
        RemoteRepository prototype = new RemoteRepository.Builder(this.serverId, null, uri.basePath).build();
        RemoteRepository.Builder builder = new RemoteRepository.Builder(prototype);
        Optional.ofNullable(this.mavenSession.getRepositorySession().getProxySelector().getProxy(prototype)).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setProxy(arg_0));
        Optional.ofNullable(this.mavenSession.getRepositorySession().getAuthenticationSelector().getAuthentication(prototype)).ifPresent(arg_0 -> ((RemoteRepository.Builder)builder).setAuthentication(arg_0));
        Optional.ofNullable(this.mavenSession.getRepositorySession().getMirrorSelector().getMirror(prototype)).ifPresent(mirror -> builder.setMirroredRepositories(Collections.singletonList(mirror)));
        return builder.build();
    }

    private static RuleSet enrichRuleSet(Collection<String> ignoredVersions, RuleSet originalRuleSet) {
        RuleSet ruleSet = new RuleSet();
        if (originalRuleSet != null) {
            if (originalRuleSet.getRules() != null) {
                ruleSet.setRules(new ArrayList(originalRuleSet.getRules()));
            }
            if (originalRuleSet.getIgnoreVersions() != null) {
                ruleSet.setIgnoreVersions(new ArrayList(originalRuleSet.getIgnoreVersions()));
            }
        }
        if (ruleSet.getIgnoreVersions() == null) {
            ruleSet.setIgnoreVersions(new ArrayList());
        }
        ruleSet.getIgnoreVersions().addAll(ignoredVersions.stream().map(v -> {
            IgnoreVersion ignoreVersion = new IgnoreVersion();
            ignoreVersion.setType("regex");
            ignoreVersion.setVersion(v);
            return ignoreVersion;
        }).collect(Collectors.toList()));
        return ruleSet;
    }

    private static /* synthetic */ String lambda$getRulesUsingWagon$2(AuthenticationInfo ai) {
        return " as " + ai.getUserName();
    }

    private static /* synthetic */ String lambda$getRulesUsingWagon$1(ProxyInfo pi) {
        return " using proxy " + pi.getHost() + ":" + pi.getPort();
    }

    private static class RulesUri {
        String basePath;
        String resource;

        private RulesUri(String basePath, String resource) {
            this.basePath = basePath;
            this.resource = resource;
        }

        static RulesUri build(String rulesUri) throws URISyntaxException {
            int split = rulesUri.lastIndexOf(47);
            return split == -1 ? new RulesUri(rulesUri, "") : new RulesUri(rulesUri.substring(0, split) + '/', split + 1 < rulesUri.length() ? rulesUri.substring(split + 1) : "");
        }
    }
}

