/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PomHelper {
    public static final String APACHE_MAVEN_PLUGINS_GROUPID = "org.apache.maven.plugins";

    public static Model getRawModel(MavenProject project) throws IOException {
        return PomHelper.getRawModel(project.getFile());
    }

    public static Model getRawModel(File moduleProjectFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(moduleProjectFile.toPath(), new OpenOption[0])));){
            Model result = PomHelper.getRawModel(reader);
            result.setPomFile(moduleProjectFile);
            Model model = result;
            return model;
        }
    }

    public static Model getRawModel(ModifiedPomXMLEventReader modifiedPomXMLEventReader) throws IOException {
        try (StringReader reader = new StringReader(modifiedPomXMLEventReader.asStringBuilder().toString());){
            Model model = PomHelper.getRawModel(reader);
            return model;
        }
    }

    public static Model getRawModel(Reader reader) throws IOException {
        try {
            return new MavenXpp3Reader().read(reader);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static boolean setPropertyVersion(ModifiedPomXMLEventReader pom, String profileId, String property, String value) throws XMLStreamException {
        Pattern projectProfileId;
        Pattern matchScopeRegex;
        Pattern propertyRegex;
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        if (profileId == null) {
            propertyRegex = Pattern.compile("/project/properties/" + RegexUtils.quote(property));
            matchScopeRegex = Pattern.compile("/project/properties");
            projectProfileId = null;
        } else {
            propertyRegex = Pattern.compile("/project/profiles/profile/properties/" + RegexUtils.quote(property));
            matchScopeRegex = Pattern.compile("/project/profiles/profile");
            projectProfileId = Pattern.compile("/project/profiles/profile/id");
        }
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (propertyRegex.matcher(path).matches()) {
                    pom.mark(0);
                } else if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = profileId == null;
                    pom.clearMark(0);
                    pom.clearMark(1);
                } else if (profileId != null && projectProfileId.matcher(path).matches()) {
                    String candidateId = pom.getElementText();
                    path = (String)stack.pop();
                    inMatchScope = profileId.trim().equals(candidateId.trim());
                }
            }
            if (!event.isEndElement()) continue;
            if (propertyRegex.matcher(path).matches()) {
                pom.mark(1);
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1)) {
                    pom.replaceBetween(0, 1, value);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static boolean setProjectVersion(ModifiedPomXMLEventReader pom, String value) throws XMLStreamException {
        return PomHelper.setElementValue(pom, "/project", "version", value, false);
    }

    public static boolean setElementValue(ModifiedPomXMLEventReader pom, String parentPath, String elementName, String value) throws XMLStreamException {
        pom.rewind();
        return PomHelper.setElementValue(pom, parentPath, elementName, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setElementValue(final ModifiedPomXMLEventReader pom, final String parentPath, final String elementName, final String value, final boolean shouldCreate) throws XMLStreamException {
        try {
            pom.rewind();
            class ElementValueInternal {
                private final String parentName;
                private final String superParentPath;
                private static final int MARK_CHILD_BEGIN = 0;
                private static final int MARK_OPTION = 1;
                private static final int PARENT_BEGIN = 2;

                ElementValueInternal() {
                    int lastDelimeterIndex = parentPath.lastIndexOf(47);
                    this.parentName = parentPath.substring(lastDelimeterIndex + 1);
                    this.superParentPath = parentPath.substring(0, lastDelimeterIndex);
                }

                boolean process(String currentPath) throws XMLStreamException {
                    boolean replacementMade = false;
                    while (!replacementMade && pom.hasNext()) {
                        XMLEvent event = pom.nextEvent();
                        if (event.isStartElement()) {
                            String currentElementName = event.asStartElement().getName().getLocalPart();
                            if (currentPath.equals(parentPath) && elementName.equals(currentElementName)) {
                                pom.mark(0);
                            } else if (currentPath.equals(this.superParentPath) && currentElementName.equals(this.parentName)) {
                                pom.mark(2);
                            }
                            replacementMade = this.process(currentPath + "/" + currentElementName);
                            continue;
                        }
                        if (!event.isEndElement()) continue;
                        if (currentPath.equals(parentPath + "/" + elementName)) {
                            this.replaceValueInChild();
                            replacementMade = true;
                            continue;
                        }
                        if (shouldCreate && currentPath.equals(parentPath)) {
                            this.replaceValueInParent();
                            replacementMade = true;
                            continue;
                        }
                        return false;
                    }
                    return replacementMade;
                }

                private void replaceValueInChild() {
                    pom.mark(1);
                    if (pom.getBetween(0, 1).length() > 0) {
                        pom.replaceBetween(0, 1, value);
                    } else {
                        pom.replace(String.format("<%1$s>%2$s</%1$s>", elementName, value));
                    }
                }

                private void replaceValueInParent() {
                    pom.mark(1);
                    if (pom.hasMark(2)) {
                        if (pom.getBetween(2, 1).length() > 0) {
                            pom.replace(String.format("<%2$s>%3$s</%2$s></%1$s>", this.parentName, elementName, value));
                        } else {
                            pom.replace(String.format("<%1$s><%2$s>%3$s</%2$s></%1$s>", this.parentName, elementName, value));
                        }
                    } else {
                        pom.replace(String.format("<%1$s><%2$s>%3$s</%2$s></%1$s>", this.parentName, elementName, value));
                    }
                }
            }
            boolean bl = new ElementValueInternal().process("");
            return bl;
        }
        finally {
            IntStream.range(0, 3).forEach(pom::clearMark);
        }
    }

    public static String getProjectVersion(ModifiedPomXMLEventReader pom) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        Pattern matchScopeRegex = Pattern.compile("/project/version");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher(path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher(path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    return pom.getBetween(0, 1).trim();
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
        return null;
    }

    public static boolean setProjectParentVersion(ModifiedPomXMLEventReader pom, String value) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean madeReplacement = false;
        Pattern matchScopeRegex = Pattern.compile("/project/parent/version");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                path = path + "/" + event.asStartElement().getName().getLocalPart();
                if (matchScopeRegex.matcher(path).matches()) {
                    pom.mark(0);
                }
            }
            if (!event.isEndElement()) continue;
            if (matchScopeRegex.matcher(path).matches()) {
                pom.mark(1);
                if (pom.hasMark(0) && pom.hasMark(1)) {
                    pom.replaceBetween(0, 1, value);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static boolean setDependencyVersion(ModifiedPomXMLEventReader pom, String groupId, String artifactId, String oldVersion, String newVersion, Model model) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        HashSet<String> implicitPaths = new HashSet<String>(Arrays.asList("/project/parent/groupId", "/project/parent/artifactId", "/project/parent/version", "/project/groupId", "/project/artifactId", "/project/version"));
        HashMap<String, String> implicitProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : model.getProperties().entrySet()) {
            implicitProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        pom.rewind();
        while (pom.hasNext()) {
            while (pom.hasNext()) {
                XMLEvent event = pom.nextEvent();
                if (event.isStartElement()) {
                    stack.push(path);
                    String elementName = event.asStartElement().getName().getLocalPart();
                    path = path + "/" + (String)elementName;
                    if (implicitPaths.contains(path)) {
                        String elementText = pom.getElementText().trim();
                        implicitProperties.put(path.substring(1).replace('/', '.'), elementText);
                        path = (String)stack.pop();
                    }
                }
                if (!event.isEndElement()) continue;
                path = (String)stack.pop();
            }
        }
        boolean modified = true;
        block5: while (modified) {
            modified = false;
            for (Map.Entry entry : implicitProperties.entrySet()) {
                String child;
                if (!((String)entry.getKey()).contains(".parent") || implicitProperties.containsKey(child = ((String)entry.getKey()).replace(".parent", ""))) continue;
                implicitProperties.put(child, (String)entry.getValue());
                modified = true;
                continue block5;
            }
        }
        stack = new Stack();
        path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        boolean haveGroupId = false;
        boolean haveArtifactId = false;
        boolean haveOldVersion = false;
        Pattern matchScopeRegex = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)|(/build(/pluginManagement)?/plugins/plugin))?/dependencies/dependency");
        Pattern matchTargetRegex = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)|(/build(/pluginManagement)?/plugins/plugin))?/dependencies/dependency((/groupId)|(/artifactId)|(/version))");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                String elementName = event.asStartElement().getName().getLocalPart();
                path = path + "/" + elementName;
                if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveGroupId = false;
                    haveArtifactId = false;
                    haveOldVersion = false;
                } else if (inMatchScope && matchTargetRegex.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        haveGroupId = groupId.equals(PomHelper.evaluate(pom.getElementText().trim(), implicitProperties));
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        haveArtifactId = artifactId.equals(PomHelper.evaluate(pom.getElementText().trim(), implicitProperties));
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        pom.mark(0);
                    }
                }
            }
            if (!event.isEndElement()) continue;
            if (matchTargetRegex.matcher(path).matches() && "version".equals(event.asEndElement().getName().getLocalPart())) {
                pom.mark(1);
                String compressedPomVersion = StringUtils.deleteWhitespace((String)pom.getBetween(0, 1).trim());
                String compressedOldVersion = StringUtils.deleteWhitespace((String)oldVersion);
                try {
                    haveOldVersion = PomHelper.isVersionOverlap(compressedOldVersion, compressedPomVersion);
                }
                catch (InvalidVersionSpecificationException e) {
                    haveOldVersion = compressedOldVersion.equals(compressedPomVersion);
                }
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1) && haveGroupId && haveArtifactId && haveOldVersion) {
                    pom.replaceBetween(0, 1, newVersion);
                    madeReplacement = true;
                }
                pom.clearMark(0);
                pom.clearMark(1);
                haveArtifactId = false;
                haveGroupId = false;
                haveOldVersion = false;
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    public static String evaluate(String expr, Map<String, String> properties) {
        if (expr == null) {
            return null;
        }
        String expression = PomHelper.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                String retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? retVal + expr.substring(index + 1, lastIndex + 1) : retVal + PomHelper.evaluate(expr.substring(index, lastIndex + 1), properties);
                retVal = retVal + PomHelper.evaluate(expr.substring(lastIndex + 1), properties);
                return retVal;
            }
            if (expression.contains("$$")) {
                return expression.replaceAll("\\$\\$", "\\$");
            }
            return expression;
        }
        String value = properties.get(expression);
        if (value != null) {
            int exprStartDelimiter = value.indexOf("${");
            if (exprStartDelimiter >= 0) {
                value = exprStartDelimiter > 0 ? value.substring(0, exprStartDelimiter) + PomHelper.evaluate(value.substring(exprStartDelimiter), properties) : PomHelper.evaluate(value.substring(exprStartDelimiter), properties);
            }
        } else {
            System.out.println("expression: " + expression + " no value ");
        }
        return value == null ? expr : value;
    }

    private static String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf("}") == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public static boolean isVersionOverlap(String leftVersionOrRange, String rightVersionOrRange) throws InvalidVersionSpecificationException {
        VersionRange pomVersionRange = PomHelper.createVersionRange(leftVersionOrRange);
        if (!pomVersionRange.hasRestrictions()) {
            return true;
        }
        VersionRange oldVersionRange = PomHelper.createVersionRange(rightVersionOrRange);
        if (!oldVersionRange.hasRestrictions()) {
            return true;
        }
        VersionRange result = oldVersionRange.restrict(pomVersionRange);
        return result.hasRestrictions();
    }

    private static VersionRange createVersionRange(String versionOrRange) throws InvalidVersionSpecificationException {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)versionOrRange);
        if (versionRange.getRecommendedVersion() != null) {
            versionRange = VersionRange.createFromVersionSpec((String)("[" + versionOrRange + "]"));
        }
        return versionRange;
    }

    public static boolean setPluginVersion(ModifiedPomXMLEventReader pom, String groupId, String artifactId, String oldVersion, String newVersion) throws XMLStreamException {
        Stack<String> stack = new Stack<String>();
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        boolean haveGroupId = false;
        boolean needGroupId = groupId != null && !APACHE_MAVEN_PLUGINS_GROUPID.equals(groupId);
        boolean haveArtifactId = false;
        boolean haveOldVersion = false;
        Pattern matchScopeRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
        Pattern matchTargetRegex = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin((/groupId)|(/artifactId)|(/version))");
        pom.rewind();
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(path);
                String elementName = event.asStartElement().getName().getLocalPart();
                path = path + "/" + elementName;
                if (matchScopeRegex.matcher(path).matches()) {
                    inMatchScope = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveGroupId = false;
                    haveArtifactId = false;
                    haveOldVersion = false;
                } else if (inMatchScope && matchTargetRegex.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        haveGroupId = pom.getElementText().trim().equals(groupId);
                        path = (String)stack.pop();
                    } else if ("artifactId".equals(elementName)) {
                        haveArtifactId = artifactId.equals(pom.getElementText().trim());
                        path = (String)stack.pop();
                    } else if ("version".equals(elementName)) {
                        pom.mark(0);
                    }
                }
            }
            if (!event.isEndElement()) continue;
            if (matchTargetRegex.matcher(path).matches() && "version".equals(event.asEndElement().getName().getLocalPart())) {
                pom.mark(1);
                try {
                    haveOldVersion = PomHelper.isVersionOverlap(oldVersion, pom.getBetween(0, 1).trim());
                }
                catch (InvalidVersionSpecificationException e) {
                    haveOldVersion = oldVersion.equals(pom.getBetween(0, 1).trim());
                }
            } else if (matchScopeRegex.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark(0) && pom.hasMark(1) && (haveGroupId || !needGroupId) && haveArtifactId && haveOldVersion) {
                    pom.replaceBetween(0, 1, newVersion);
                    madeReplacement = true;
                    pom.clearMark(0);
                    pom.clearMark(1);
                    haveArtifactId = false;
                    haveGroupId = false;
                    haveOldVersion = false;
                }
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    private static Map<MavenProject, Model> getRawModelWithParents(MavenProject project) throws IOException {
        TreeMap<MavenProject, Model> models = new TreeMap<MavenProject, Model>((p1, p2) -> {
            for (MavenProject p = p1; p != null; p = p.getParent()) {
                if (p != p2) continue;
                return p == p1 ? 0 : -1;
            }
            return 1;
        });
        for (MavenProject p = project; p != null; p = p.getParent()) {
            models.put(p, p.getFile() != null ? PomHelper.getRawModel(p) : p.getOriginalModel());
        }
        return models;
    }

    public static PropertyVersionsBuilder[] getPropertyVersionsBuilders(VersionsHelper helper, MavenProject project, boolean includeParent) throws ExpressionEvaluationException, IOException {
        ExpressionEvaluator expressionEvaluator = helper.getExpressionEvaluator(project);
        Map<MavenProject, Model> reactorModels = includeParent ? PomHelper.getRawModelWithParents(project) : Collections.singletonMap(project, PomHelper.getRawModel(project));
        TreeMap<String, PropertyVersionsBuilder> propertiesMap = new TreeMap<String, PropertyVersionsBuilder>();
        TreeSet<String> activeProfiles = new TreeSet<String>();
        for (Profile profile2 : project.getActiveProfiles()) {
            activeProfiles.add(profile2.getId());
        }
        Iterator it = reactorModels.values().stream().flatMap(model -> model.getProfiles().stream()).filter(profile -> activeProfiles.contains(profile.getId())).iterator();
        while (it.hasNext()) {
            Profile profile2;
            profile2 = (Profile)it.next();
            try {
                PomHelper.addProperties(helper, propertiesMap, profile2.getId(), profile2.getProperties());
                if (profile2.getDependencyManagement() != null) {
                    PomHelper.addDependencyAssocations(helper, expressionEvaluator, propertiesMap, profile2.getDependencyManagement().getDependencies(), false);
                }
                PomHelper.addDependencyAssocations(helper, expressionEvaluator, propertiesMap, profile2.getDependencies(), false);
                if (profile2.getBuild() != null) {
                    if (profile2.getBuild().getPluginManagement() != null) {
                        PomHelper.addPluginAssociations(helper, expressionEvaluator, propertiesMap, profile2.getBuild().getPluginManagement().getPlugins());
                    }
                    PomHelper.addPluginAssociations(helper, expressionEvaluator, propertiesMap, profile2.getBuild().getPlugins());
                }
                if (profile2.getReporting() == null) continue;
                PomHelper.addReportPluginAssociations(helper, expressionEvaluator, propertiesMap, profile2.getReporting().getPlugins());
            }
            catch (ExpressionEvaluationException e) {
                throw new RuntimeException(e);
            }
        }
        reactorModels.values().forEach(model -> PomHelper.addProperties(helper, propertiesMap, null, model.getProperties()));
        MavenProject currentPrj = project;
        while (currentPrj != null) {
            Model model2 = reactorModels.get(currentPrj);
            if (model2.getDependencyManagement() != null) {
                PomHelper.addDependencyAssocations(helper, expressionEvaluator, propertiesMap, model2.getDependencyManagement().getDependencies(), false);
            }
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, propertiesMap, model2.getDependencies(), false);
            if (model2.getBuild() != null) {
                if (model2.getBuild().getPluginManagement() != null) {
                    PomHelper.addPluginAssociations(helper, expressionEvaluator, propertiesMap, model2.getBuild().getPluginManagement().getPlugins());
                }
                PomHelper.addPluginAssociations(helper, expressionEvaluator, propertiesMap, model2.getBuild().getPlugins());
            }
            if (model2.getReporting() != null) {
                PomHelper.addReportPluginAssociations(helper, expressionEvaluator, propertiesMap, model2.getReporting().getPlugins());
            }
            for (Profile profile3 : model2.getProfiles()) {
                if (!activeProfiles.contains(profile3.getId())) continue;
                if (profile3.getDependencyManagement() != null) {
                    PomHelper.addDependencyAssocations(helper, expressionEvaluator, propertiesMap, profile3.getDependencyManagement().getDependencies(), false);
                }
                PomHelper.addDependencyAssocations(helper, expressionEvaluator, propertiesMap, profile3.getDependencies(), false);
                if (profile3.getBuild() != null) {
                    if (profile3.getBuild().getPluginManagement() != null) {
                        PomHelper.addPluginAssociations(helper, expressionEvaluator, propertiesMap, profile3.getBuild().getPluginManagement().getPlugins());
                    }
                    PomHelper.addPluginAssociations(helper, expressionEvaluator, propertiesMap, profile3.getBuild().getPlugins());
                }
                if (profile3.getReporting() == null) continue;
                PomHelper.addReportPluginAssociations(helper, expressionEvaluator, propertiesMap, profile3.getReporting().getPlugins());
            }
            currentPrj = includeParent ? currentPrj.getParent() : null;
        }
        PomHelper.purgeProperties(propertiesMap);
        return propertiesMap.values().toArray(new PropertyVersionsBuilder[0]);
    }

    private static void addPluginAssociations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map<String, PropertyVersionsBuilder> result, List<Plugin> plugins) throws ExpressionEvaluationException {
        if (plugins == null) {
            return;
        }
        for (Plugin plugin : plugins) {
            String version = plugin.getVersion();
            if (version != null && version.contains("${") && version.indexOf(125) != -1) {
                version = StringUtils.deleteWhitespace((String)version);
                for (PropertyVersionsBuilder property : result.values()) {
                    String propertyRef = "${" + property.getName() + "}";
                    if (!version.contains(propertyRef)) continue;
                    String groupId = plugin.getGroupId();
                    groupId = groupId == null || groupId.trim().length() == 0 ? APACHE_MAVEN_PLUGINS_GROUPID : (String)expressionEvaluator.evaluate(groupId);
                    String artifactId = plugin.getArtifactId();
                    if (artifactId == null || artifactId.trim().length() == 0) continue;
                    artifactId = (String)expressionEvaluator.evaluate(artifactId);
                    String evaluatedVersion = (String)expressionEvaluator.evaluate(plugin.getVersion());
                    property.addAssociation(helper.createPluginArtifact(groupId, artifactId, evaluatedVersion), true);
                    if (propertyRef.equals(version)) continue;
                    PomHelper.addBounds(property, version, propertyRef);
                }
            }
            PomHelper.addDependencyAssocations(helper, expressionEvaluator, result, plugin.getDependencies(), true);
        }
    }

    private static void addReportPluginAssociations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map<String, PropertyVersionsBuilder> result, List<ReportPlugin> reportPlugins) throws ExpressionEvaluationException {
        if (reportPlugins == null) {
            return;
        }
        for (ReportPlugin plugin : reportPlugins) {
            String version = plugin.getVersion();
            if (version == null || !version.contains("${") || version.indexOf(125) == -1) continue;
            version = StringUtils.deleteWhitespace((String)version);
            for (PropertyVersionsBuilder property : result.values()) {
                String propertyRef = "${" + property.getName() + "}";
                if (!version.contains(propertyRef)) continue;
                String groupId = plugin.getGroupId();
                groupId = groupId == null || groupId.trim().length() == 0 ? APACHE_MAVEN_PLUGINS_GROUPID : (String)expressionEvaluator.evaluate(groupId);
                String artifactId = plugin.getArtifactId();
                if (artifactId == null || artifactId.trim().length() == 0) continue;
                artifactId = (String)expressionEvaluator.evaluate(artifactId);
                String versionEvaluated = (String)expressionEvaluator.evaluate(plugin.getVersion());
                property.addAssociation(helper.createPluginArtifact(groupId, artifactId, versionEvaluated), true);
                if (propertyRef.equals(version)) continue;
                PomHelper.addBounds(property, version, propertyRef);
            }
        }
    }

    private static void addDependencyAssocations(VersionsHelper helper, ExpressionEvaluator expressionEvaluator, Map<String, PropertyVersionsBuilder> result, List<Dependency> dependencies, boolean usePluginRepositories) throws ExpressionEvaluationException {
        if (dependencies == null) {
            return;
        }
        for (Dependency dependency : dependencies) {
            String version = dependency.getVersion();
            if (version == null || !version.contains("${") || version.indexOf(125) == -1) continue;
            version = StringUtils.deleteWhitespace((String)version);
            for (PropertyVersionsBuilder property : result.values()) {
                String groupId;
                String propertyRef = "${" + property.getName() + "}";
                if (!version.contains(propertyRef) || (groupId = dependency.getGroupId()) == null || groupId.trim().length() == 0) continue;
                groupId = (String)expressionEvaluator.evaluate(groupId);
                String artifactId = dependency.getArtifactId();
                if (artifactId == null || artifactId.trim().length() == 0) continue;
                artifactId = (String)expressionEvaluator.evaluate(artifactId);
                String versionEvaluated = (String)expressionEvaluator.evaluate(dependency.getVersion());
                property.addAssociation(helper.createDependencyArtifact(groupId, artifactId, versionEvaluated, dependency.getType(), dependency.getClassifier(), dependency.getScope(), dependency.isOptional()), usePluginRepositories);
                if (propertyRef.equals(version)) continue;
                PomHelper.addBounds(property, version, propertyRef);
            }
        }
    }

    private static void addBounds(PropertyVersionsBuilder builder, String rawVersionRange, String propertyRef) {
        Pattern lowerBound = Pattern.compile("([(\\[])([^,]*)," + RegexUtils.quote(propertyRef) + "([)\\]])");
        Pattern upperBound = Pattern.compile("([(\\[])" + RegexUtils.quote(propertyRef) + ",([^,]*)([)\\]])");
        Matcher m = lowerBound.matcher(rawVersionRange);
        if (m.find()) {
            boolean includeLower = "[".equals(m.group(1));
            String lowerLimit = m.group(2);
            if (StringUtils.isNotEmpty((String)lowerLimit)) {
                builder.addLowerBound(lowerLimit, includeLower);
            }
        }
        if ((m = upperBound.matcher(rawVersionRange)).find()) {
            boolean includeUpper = "[".equals(m.group(3));
            String upperLimit = m.group(2);
            if (StringUtils.isNotEmpty((String)upperLimit)) {
                builder.addUpperBound(upperLimit, includeUpper);
            }
        }
    }

    private static void addProperties(VersionsHelper helper, Map<String, PropertyVersionsBuilder> result, String profileId, Properties properties) {
        if (properties == null) {
            return;
        }
        for (String propertyName : properties.stringPropertyNames()) {
            if (result.containsKey(propertyName)) continue;
            result.put(propertyName, new PropertyVersionsBuilder(profileId, propertyName, helper));
        }
    }

    private static void purgeProperties(Map<String, PropertyVersionsBuilder> result) {
        result.values().removeIf(versions -> versions.getAssociations().length == 0);
    }

    public static Set<String> getAllChildModules(MavenProject project, Log logger) {
        return PomHelper.getAllChildModules(project.getOriginalModel(), logger);
    }

    public static Set<String> getAllChildModules(Model model, Log logger) {
        logger.debug((CharSequence)"Finding child modules...");
        TreeSet<String> childModules = new TreeSet<String>(model.getModules());
        model.getProfiles().forEach(profile -> childModules.addAll(profile.getModules()));
        PomHelper.debugModules(logger, "Child modules:", childModules);
        return childModules;
    }

    public static void debugModules(Log logger, String message, Collection<String> modules) {
        if (logger.isDebugEnabled()) {
            logger.debug((CharSequence)message);
            if (modules.isEmpty()) {
                logger.debug((CharSequence)"None.");
            } else {
                modules.forEach(module -> logger.debug((CharSequence)("  " + module)));
            }
        }
    }

    public static String getVersion(Model model) {
        String targetVersion = model.getVersion();
        if (targetVersion == null && model.getParent() != null) {
            targetVersion = model.getParent().getVersion();
        }
        return targetVersion;
    }

    public static boolean isExplicitVersion(Model model) {
        return model.getVersion() != null;
    }

    public static String getArtifactId(Model model) {
        String sourceArtifactId = model.getArtifactId();
        if (sourceArtifactId == null && model.getParent() != null) {
            sourceArtifactId = model.getParent().getArtifactId();
        }
        return sourceArtifactId;
    }

    public static String getGroupId(Model model) {
        String targetGroupId = model.getGroupId();
        if (targetGroupId == null && model.getParent() != null) {
            targetGroupId = model.getParent().getGroupId();
        }
        return targetGroupId;
    }

    public static MavenProject getLocalRoot(ProjectBuilder projectBuilder, MavenSession mavenSession, Log logger) {
        File parentDir;
        logger.info((CharSequence)"Searching for local aggregator root...");
        MavenProject project = mavenSession.getCurrentProject();
        while ((parentDir = project.getBasedir().getParentFile()) != null && parentDir.isDirectory()) {
            logger.debug((CharSequence)("Checking to see if " + parentDir + " is an aggregator parent"));
            File parentFile = new File(parentDir, "pom.xml");
            if (!parentFile.isFile()) break;
            try {
                ProjectBuildingResult result = projectBuilder.build(parentFile, PomHelper.createProjectBuilderRequest(mavenSession, new Consumer[0]));
                if (!result.getProblems().isEmpty()) {
                    logger.warn((CharSequence)"Problems encountered during the computation of the local aggregation root.");
                    result.getProblems().forEach(p -> logger.warn((CharSequence)("\t" + p.getMessage())));
                }
                if (PomHelper.getAllChildModules(result.getProject(), logger).contains(project.getBasedir().getName())) {
                    logger.debug((CharSequence)(parentDir + " is an aggregator parent"));
                    project = result.getProject();
                    continue;
                }
                logger.debug((CharSequence)(parentDir + " is not an aggregator parent"));
                break;
            }
            catch (ProjectBuildingException e) {
                logger.warn((Throwable)e);
                break;
            }
        }
        logger.debug((CharSequence)("Local aggregation root is " + project.getBasedir()));
        return project;
    }

    @SafeVarargs
    public static ProjectBuildingRequest createProjectBuilderRequest(final MavenSession mavenSession, final Consumer<ProjectBuildingRequest> ... initializers) {
        return new DefaultProjectBuildingRequest(){
            {
                this.setValidationLevel(0);
                this.setResolveDependencies(false);
                this.setLocalRepository(mavenSession.getLocalRepository());
                this.setRemoteRepositories(mavenSession.getCurrentProject().getRemoteArtifactRepositories());
                this.setBuildStartTime(mavenSession.getStartTime());
                this.setUserProperties(mavenSession.getUserProperties());
                this.setSystemProperties(mavenSession.getSystemProperties());
                this.setActiveProfileIds(mavenSession.getRequest().getActiveProfiles());
                this.setInactiveProfileIds(mavenSession.getRequest().getInactiveProfiles());
                this.setRepositorySession(mavenSession.getRepositorySession());
                Arrays.stream(initializers).forEach(i -> i.accept(this));
            }
        };
    }

    public static Map<File, Model> getChildModels(MavenProject project, Log logger) throws IOException {
        LinkedHashMap<File, Model> result = new LinkedHashMap<File, Model>();
        Model model = PomHelper.getRawModel(project);
        result.put(project.getFile(), model);
        result.putAll(PomHelper.getChildModels(model, logger));
        return result;
    }

    private static Map<File, Model> getChildModels(Model model, Log logger) throws IOException {
        LinkedHashMap<File, Model> result = new LinkedHashMap<File, Model>();
        LinkedHashMap childResults = new LinkedHashMap();
        File baseDir = model.getPomFile().getParentFile();
        PomHelper.getAllChildModules(model, logger).parallelStream().map(moduleName -> new File(baseDir, (String)moduleName)).map(file -> file.isFile() ? file : new File((File)file, "pom.xml")).filter(File::exists).forEach(pomFile -> {
            try {
                Model moduleModel = PomHelper.getRawModel(pomFile);
                result.put((File)pomFile, moduleModel);
                childResults.putAll(PomHelper.getChildModels(moduleModel, logger));
            }
            catch (IOException e) {
                logger.error((CharSequence)("Could not parse " + pomFile.getPath()), (Throwable)e);
            }
        });
        result.putAll(childResults);
        return result;
    }

    public static Map<File, Model> getChildModels(Map<File, Model> reactor, String groupId, String artifactId) {
        LinkedHashMap<File, Model> result = new LinkedHashMap<File, Model>();
        for (Map.Entry<File, Model> entry : reactor.entrySet()) {
            File path = entry.getKey();
            Model model = entry.getValue();
            Parent parent = model.getParent();
            if (parent == null || !groupId.equals(parent.getGroupId()) || !artifactId.equals(parent.getArtifactId())) continue;
            result.put(path, model);
        }
        return result;
    }

    public static Model getModel(Map<File, Model> reactor, String groupId, String artifactId) {
        return reactor.values().stream().filter(model -> (groupId == null || groupId.equals(PomHelper.getGroupId(model))) && artifactId.equals(PomHelper.getArtifactId(model))).findAny().orElse(null);
    }

    public static Map.Entry<File, Model> getModelEntry(Map<File, Model> reactor, String groupId, String artifactId) {
        return reactor.entrySet().stream().filter(e -> (groupId == null || groupId.equals(PomHelper.getGroupId((Model)e.getValue()))) && artifactId.equals(PomHelper.getArtifactId((Model)e.getValue()))).findAny().orElse(null);
    }

    public static int getReactorParentCount(Map<File, Model> reactor, Model model) {
        if (model.getParent() == null) {
            return 0;
        }
        Model parentModel = PomHelper.getModel(reactor, model.getParent().getGroupId(), model.getParent().getArtifactId());
        if (parentModel == null) {
            return 0;
        }
        return PomHelper.getReactorParentCount(reactor, parentModel) + 1;
    }

    public static StringBuilder readXmlFile(File outFile) throws IOException {
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)outFile);){
            StringBuilder stringBuilder = new StringBuilder(IOUtil.toString((Reader)reader));
            return stringBuilder;
        }
    }

    public static String getGAV(Model model) {
        return PomHelper.getGroupId(model) + ":" + PomHelper.getArtifactId(model) + ":" + PomHelper.getVersion(model);
    }
}

