/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.ordering.MajorMinorIncrementalFilter;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-latest-snapshots", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class UseLatestSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="allowMajorUpdates", defaultValue="false")
    protected boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="false")
    protected boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates;
    public final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useLatestSnapshots(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useLatestSnapshots(pom, this.getProject().getDependencies());
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                Dependency dependency = new Dependency();
                dependency.setArtifactId(this.getProject().getParent().getArtifactId());
                dependency.setGroupId(this.getProject().getParent().getGroupId());
                dependency.setVersion(this.getProject().getParent().getVersion());
                dependency.setType("pom");
                ArrayList<Dependency> list = new ArrayList<Dependency>();
                list.add(dependency);
                this.useLatestSnapshots(pom, list);
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useLatestSnapshots(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        int segment = this.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates);
        MajorMinorIncrementalFilter majorMinorIncfilter = new MajorMinorIncrementalFilter(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates);
        for (Dependency dep : dependencies) {
            DefaultArtifactVersion lowerBound;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (versionMatcher.matches()) continue;
            this.getLog().debug((CharSequence)("Looking for latest snapshot of " + this.toString(dep)));
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            DefaultArtifactVersion selectedVersion = new DefaultArtifactVersion(version);
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            VersionComparator versionComparator = versions.getVersionComparator();
            if (segment + 1 > versionComparator.getSegmentCount((ArtifactVersion)(lowerBound = new DefaultArtifactVersion(version)))) {
                this.getLog().info((CharSequence)("Ignoring " + this.toString(dep) + " as the version number is too short"));
                continue;
            }
            ArtifactVersion upperBound = segment >= 0 ? versionComparator.incrementSegment((ArtifactVersion)lowerBound, segment) : null;
            this.getLog().info((CharSequence)("Upper bound: " + (upperBound == null ? "none" : upperBound.toString())));
            ArtifactVersion[] newer = versions.getVersions((ArtifactVersion)lowerBound, upperBound, true, false, false);
            this.getLog().debug((CharSequence)("Candidate versions " + Arrays.asList(newer)));
            ArrayList<ArtifactVersion> snapshotsOnly = new ArrayList<ArtifactVersion>();
            for (ArtifactVersion artifactVersion : newer) {
                String newVersion = artifactVersion.toString();
                if (!this.matchSnapshotRegex.matcher(newVersion).matches()) continue;
                snapshotsOnly.add(artifactVersion);
            }
            this.getLog().debug((CharSequence)("Snapshot Only versions " + snapshotsOnly));
            ArtifactVersion[] filteredVersions = majorMinorIncfilter.filter((ArtifactVersion)selectedVersion, snapshotsOnly.toArray(new ArtifactVersion[0]));
            this.getLog().debug((CharSequence)("Filtered versions " + Arrays.asList(filteredVersions)));
            if (filteredVersions.length <= 0) continue;
            String latestVersion = filteredVersions[filteredVersions.length - 1].toString();
            if (this.getProject().getParent() != null && artifact.getId().equals(this.getProject().getParentArtifact().getId()) && this.isProcessingParent() && PomHelper.setProjectParentVersion(pom, latestVersion)) {
                this.getLog().debug((CharSequence)("Made parent update from " + version + " to " + latestVersion));
            }
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, latestVersion, this.getProject().getModel())) continue;
            this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + latestVersion));
        }
    }
}

