/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="display-parent-updates", threadSafe=true)
public class DisplayParentUpdatesMojo
extends AbstractVersionsDisplayMojo {
    public static final int MESSAGE_LENGTH = 68;
    @Parameter(property="parentVersion")
    protected String parentVersion = null;
    @Parameter(property="forceUpdate", defaultValue="false")
    protected boolean forceUpdate = false;
    @Parameter(property="skipResolution", defaultValue="false")
    protected boolean skipResolution = false;
    @Parameter(property="allowDowngrade", defaultValue="false")
    protected boolean allowDowngrade;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates = true;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;

    @Inject
    public DisplayParentUpdatesMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactVersion artifactVersion;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.logInit();
        if (this.getProject().getParent() == null) {
            this.logLine(false, "Project does not have a parent.");
            return;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.logLine(false, "Parent project is part of the reactor.");
            return;
        }
        if (this.skipResolution && StringUtils.isBlank((CharSequence)this.parentVersion)) {
            throw new MojoExecutionException("skipResolution is only valid if parentVersion is set");
        }
        String initialVersion = Optional.ofNullable(this.parentVersion).orElse(this.getProject().getParent().getVersion());
        try {
            artifactVersion = this.skipResolution ? ArtifactVersionService.getArtifactVersion((String)this.parentVersion) : this.resolveTargetVersion(initialVersion);
        }
        catch (InvalidVersionSpecificationException | VersionRetrievalException | InvalidSegmentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (artifactVersion == null || initialVersion.equals(artifactVersion.toString())) {
            this.logLine(false, "The parent project is the latest version:");
            StringBuilder buf = new StringBuilder(68);
            buf.append("  ");
            buf.append(this.getProject().getParent().getGroupId());
            buf.append(':');
            buf.append(this.getProject().getParent().getArtifactId());
            buf.append(' ');
            int padding = 68 - initialVersion.length();
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(initialVersion);
            this.logLine(false, buf.toString());
        } else {
            this.logLine(false, "The parent project has a newer version:");
            StringBuilder buf = new StringBuilder(68);
            buf.append("  ");
            buf.append(this.getProject().getParent().getGroupId());
            buf.append(':');
            buf.append(this.getProject().getParent().getArtifactId());
            buf.append(' ');
            int padding = 68 - initialVersion.length() - artifactVersion.toString().length() - " -> ".length();
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(initialVersion);
            buf.append(" -> ");
            buf.append(artifactVersion);
            this.logLine(false, buf.toString());
        }
    }

    protected ArtifactVersion resolveTargetVersion(String initialVersion) throws MojoExecutionException, VersionRetrievalException, InvalidVersionSpecificationException, InvalidSegmentException {
        Artifact artifact = this.artifactFactory.createArtifact(DependencyBuilder.newBuilder().withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withVersion(initialVersion).withType("pom").build());
        VersionRange targetVersionRange = VersionRange.createFromVersionSpec((String)initialVersion);
        if (targetVersionRange.getRecommendedVersion() != null) {
            targetVersionRange = targetVersionRange.restrict(VersionRange.createFromVersionSpec((String)("[" + targetVersionRange.getRecommendedVersion() + ",)")));
        }
        ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
        Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog());
        for (ArtifactVersion candidate : DisplayParentUpdatesMojo.reverse(versions.getNewerVersions(initialVersion, unchangedSegment, this.allowSnapshots, !StringUtils.isBlank((CharSequence)this.parentVersion) || this.allowDowngrade))) {
            if (!this.allowDowngrade && targetVersionRange != null && !ArtifactVersions.isVersionInRange((ArtifactVersion)candidate, (VersionRange)targetVersionRange)) continue;
            if (this.shouldApplyUpdate(artifact, this.getProject().getParent().getVersion(), candidate, this.forceUpdate)) {
                return candidate;
            }
            this.getLog().debug((CharSequence)"Update not applied. Exiting.");
            return null;
        }
        if (versions.isEmpty(this.allowSnapshots)) {
            this.getLog().info((CharSequence)"No versions found");
        } else {
            this.getLog().info((CharSequence)"The parent project is the latest version");
        }
        return null;
    }

    private static <T> Iterable<T> reverse(T[] array) {
        return Arrays.stream(array).sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }

    @Override
    protected void update(MutableXMLStreamReader pom) {
    }
}

