/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.rule.RuleService;
import org.codehaus.mojo.versions.rule.RulesServiceBuilder;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.eclipse.aether.RepositorySystem;

public abstract class AbstractVersionsUpdaterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="maven.version.rules.serverId", defaultValue="serverId")
    protected String serverId;
    @Parameter(property="maven.version.rules")
    protected String rulesUri;
    @Parameter(property="generateBackupPoms", defaultValue="true")
    protected boolean generateBackupPoms;
    private VersionsHelper helper;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    protected MojoExecution mojoExecution;
    @Parameter(property="changeRecorderFormat", defaultValue="none")
    private String changeRecorderFormat = "none";
    @Parameter(property="changeRecorderOutputFile", defaultValue="${project.build.directory}/versions-changes.xml")
    private File changeRecorderOutputFile;
    private Map<String, ChangeRecorder> changeRecorders;
    @Parameter
    protected RuleSet ruleSet;
    @Parameter(property="maven.version.ignore")
    protected Set<String> ignoredVersions;
    protected final Map<String, Wagon> wagonMap;
    protected final ArtifactFactory artifactFactory;

    @Inject
    protected AbstractVersionsUpdaterMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        this.artifactFactory = artifactFactory;
        this.repositorySystem = repositorySystem;
        this.wagonMap = wagonMap;
        this.changeRecorders = changeRecorders;
    }

    protected abstract boolean getAllowSnapshots();

    public synchronized VersionsHelper getHelper() throws MojoExecutionException {
        if (this.helper == null) {
            RuleService ruleService = new RulesServiceBuilder().withMavenSession(this.session).withWagonMap(this.wagonMap).withServerId(this.serverId).withRulesUri(this.rulesUri).withRuleSet(this.ruleSet).withIgnoredVersions(this.ignoredVersions).withLog(this.getLog()).build();
            PomHelper pomHelper = new PomHelper(this.artifactFactory, (ExpressionEvaluator)new VersionsExpressionEvaluator(this.session, this.mojoExecution));
            this.helper = new DefaultVersionsHelper.Builder().withArtifactFactory(this.artifactFactory).withRepositorySystem(this.repositorySystem).withLog(this.getLog()).withMavenSession(this.session).withPomHelper(pomHelper).withRuleService(ruleService).build();
        }
        return this.helper;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getVersion() {
        return this.getProject() == null ? null : this.getProject().getVersion();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateInput();
        File outFile = this.project.getFile();
        this.process(outFile);
    }

    protected void validateInput() throws MojoExecutionException {
    }

    protected ArtifactVersion findLatestVersion(Artifact artifact, VersionRange versionRange, Boolean allowingSnapshots, boolean usePluginRepositories) throws MojoExecutionException, VersionRetrievalException {
        boolean includeSnapshots = allowingSnapshots != null ? allowingSnapshots.booleanValue() : this.getAllowSnapshots();
        ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, versionRange, usePluginRepositories);
        return artifactVersions.getNewestVersion(versionRange, null, includeSnapshots, false);
    }

    protected void process(File outFile) throws MojoExecutionException, MojoFailureException {
        try {
            MutableXMLStreamReader newPom = new MutableXMLStreamReader(outFile.toPath());
            this.update(newPom);
            if (newPom.isModified()) {
                if (this.generateBackupPoms) {
                    File backupFile = new File(outFile.getParentFile(), outFile.getName() + ".versionsBackup");
                    if (!backupFile.exists()) {
                        this.getLog().debug((CharSequence)("Backing up " + outFile + " to " + backupFile));
                        Files.copy(outFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        this.getLog().debug((CharSequence)("Leaving existing backup " + backupFile + " unmodified"));
                    }
                } else {
                    this.getLog().debug((CharSequence)"Skipping generation of backup file");
                }
                try (BufferedWriter writer = Files.newBufferedWriter(outFile.toPath(), Optional.ofNullable(newPom.getEncoding()).map(Charset::forName).orElse(Charset.defaultCharset()), new OpenOption[0]);){
                    writer.write(newPom.getSource());
                }
            }
            this.saveChangeRecorderResults();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        catch (XMLStreamException | VersionRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected abstract void update(MutableXMLStreamReader var1) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException;

    @Deprecated
    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion) {
        return this.shouldApplyUpdate(artifact, currentVersion, updateVersion, false);
    }

    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion, boolean forceUpdate) {
        this.getLog().debug((CharSequence)("Proposal is to update from " + currentVersion + " to " + updateVersion));
        if (updateVersion == null) {
            this.getLog().warn((CharSequence)"Not updating version: could not resolve any versions");
            return false;
        }
        if (forceUpdate) {
            this.getLog().info((CharSequence)"Force update enabled. LATEST or RELEASE versions will be overwritten with real version");
            return true;
        }
        artifact.setVersion(updateVersion.toString());
        try {
            this.getHelper().resolveArtifact(artifact, false);
        }
        catch (ArtifactResolutionException | MojoExecutionException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not resolve " + artifact), e);
            return false;
        }
        if (currentVersion.equals(updateVersion.toString())) {
            this.getLog().info((CharSequence)("Current version of " + artifact + " is the latest."));
            return false;
        }
        return true;
    }

    protected ArtifactVersion updatePropertyToNewestVersion(MutableXMLStreamReader pom, Property property, PropertyVersions version, String currentVersion, boolean allowDowngrade, Optional<Segment> unchangedSegment) throws XMLStreamException, InvalidVersionSpecificationException, InvalidSegmentException, MojoExecutionException {
        ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.getAllowSnapshots(), this.reactorProjects, allowDowngrade, unchangedSegment);
        if (winner == null || currentVersion.equals(winner.toString())) {
            this.getLog().info((CharSequence)("Property ${" + property.getName() + "}: Leaving unchanged as " + currentVersion));
        } else if (PomHelper.setPropertyVersion((MutableXMLStreamReader)pom, (String)version.getProfileId(), (String)property.getName(), (String)winner.toString())) {
            this.getLog().info((CharSequence)("Updated ${" + property.getName() + "} from " + currentVersion + " to " + winner));
            return winner;
        }
        return null;
    }

    protected ChangeRecorder getChangeRecorder() throws MojoExecutionException {
        ChangeRecorder changeRecorder = this.changeRecorders.get(this.changeRecorderFormat);
        if (changeRecorder == null) {
            throw new MojoExecutionException("Only " + this.changeRecorders.keySet() + " formats are supported for change recordings");
        }
        return changeRecorder;
    }

    protected void saveChangeRecorderResults() throws IOException, MojoExecutionException {
        this.getLog().debug((CharSequence)("writing change record to " + this.changeRecorderOutputFile));
        this.getChangeRecorder().writeReport((Path)Optional.ofNullable(this.changeRecorderOutputFile).map(File::toPath).orElse(null));
    }
}

