/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.rule.RuleService;
import org.codehaus.mojo.versions.rule.RulesServiceBuilder;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;

public abstract class AbstractVersionsReport<T>
extends AbstractMavenReport {
    protected I18N i18n;
    @Parameter(property="versions.skip")
    private boolean skip;
    protected RepositorySystem repositorySystem;
    @Parameter(property="maven.version.rules.serverId", defaultValue="serverId")
    private String serverId;
    @Parameter(property="maven.version.rules")
    private String rulesUri;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;
    private VersionsHelper helper;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter
    protected RuleSet ruleSet;
    @Parameter(property="maven.version.ignore")
    protected Set<String> ignoredVersions;
    protected ReportRendererFactory rendererFactory;
    protected Map<String, Wagon> wagonMap;
    private final ArtifactFactory artifactFactory;

    protected AbstractVersionsReport(I18N i18n, ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        this.i18n = i18n;
        this.artifactFactory = artifactFactory;
        this.repositorySystem = repositorySystem;
        this.wagonMap = wagonMap;
        this.rendererFactory = rendererFactory;
    }

    public VersionsHelper getHelper() throws MavenReportException {
        if (this.helper == null) {
            try {
                RuleService ruleService = new RulesServiceBuilder().withWagonMap(this.wagonMap).withServerId(this.serverId).withRulesUri(this.rulesUri).withRuleSet(this.ruleSet).withIgnoredVersions(this.ignoredVersions).withLog(this.getLog()).withMavenSession(this.session).build();
                PomHelper pomHelper = new PomHelper(this.artifactFactory, (ExpressionEvaluator)new VersionsExpressionEvaluator(this.session, this.mojoExecution));
                this.helper = new DefaultVersionsHelper.Builder().withArtifactFactory(this.artifactFactory).withRepositorySystem(this.repositorySystem).withLog(this.getLog()).withMavenSession(this.session).withPomHelper(pomHelper).withRuleService(ruleService).build();
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.helper;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.skip) {
            try {
                this.doGenerateReport(locale, this.getSink());
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    protected abstract void doGenerateReport(Locale var1, Sink var2) throws MavenReportException, MojoExecutionException;

    public String getDescription(Locale locale) {
        return this.getText(locale, "report.description");
    }

    @Deprecated
    public String getOutputName() {
        return this.getOutputPath();
    }

    public String getName(Locale locale) {
        return this.getText(locale, "report.title");
    }

    public String getText(Locale locale, String key) {
        return this.i18n.getString(this.getOutputPath(), locale, key);
    }

    public Boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    public I18N getI18n() {
        return this.i18n;
    }
}

