/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="display-property-updates", threadSafe=true)
public class DisplayPropertyUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int INFO_PAD_SIZE = 68;
    @Parameter
    private Property[] properties;
    @Parameter(property="includeProperties")
    private String includeProperties = null;
    @Parameter(property="excludeProperties")
    private String excludeProperties = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;
    @Parameter(property="includeParent", defaultValue="false")
    protected boolean includeParent = true;

    @Inject
    public DisplayPropertyUpdatesMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logInit();
        ArrayList<String> current = new ArrayList<String>();
        ArrayList<String> updates = new ArrayList<String>();
        Map propertyVersions = this.getHelper().getVersionPropertiesMap(VersionsHelper.VersionPropertiesMapRequest.builder().withMavenProject(this.getProject()).withPropertyDefinitions(this.properties).withIncludeProperties(this.includeProperties).withExcludeProperties(this.excludeProperties).withIncludeParent(this.includeParent).withAutoLinkItems(this.autoLinkItems).build());
        for (Map.Entry entry : propertyVersions.entrySet()) {
            Optional<Object> unchangedSegment1;
            Property property = (Property)entry.getKey();
            PropertyVersions version = (PropertyVersions)entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            Log log = this.getLog();
            if (log != null && !this.allowIncrementalUpdates) {
                log.info((CharSequence)"Assuming allowMinorUpdates false because allowIncrementalUpdates is false.");
            }
            if (log != null && !this.allowMinorUpdates) {
                log.info((CharSequence)"Assuming allowMajorUpdates false because allowMinorUpdates is false.");
            }
            Optional<Object> optional = this.allowMajorUpdates && this.allowMinorUpdates && this.allowIncrementalUpdates ? Optional.empty() : (this.allowMinorUpdates && this.allowIncrementalUpdates ? Optional.of(Segment.MAJOR) : (unchangedSegment1 = this.allowIncrementalUpdates ? Optional.of(Segment.MINOR) : Optional.of(Segment.INCREMENTAL)));
            if (log != null && log.isDebugEnabled()) {
                log.debug((CharSequence)(unchangedSegment1.map(Segment::minorTo).map(Segment::toString).orElse("ALL") + " version changes allowed"));
            }
            Optional<Object> unchangedSegment = unchangedSegment1;
            try {
                StringBuilder buf;
                ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.allowSnapshots, (Collection)this.reactorProjects, this.getHelper(), false, unchangedSegment);
                if (winner != null && !currentVersion.equals(winner.toString())) {
                    buf = new StringBuilder();
                    buf.append("${");
                    buf.append(property.getName());
                    buf.append("} ");
                    String newVersion = winner.toString();
                    int padding = 68 - currentVersion.length() - newVersion.length() - 4 + this.getOutputLineWidthOffset();
                    while (buf.length() < padding) {
                        buf.append('.');
                    }
                    buf.append(' ');
                    buf.append(currentVersion);
                    buf.append(" -> ");
                    buf.append(newVersion);
                    updates.add(buf.toString());
                    continue;
                }
                buf = new StringBuilder();
                buf.append("${");
                buf.append(property.getName());
                buf.append("} ");
                int padding = 68 - currentVersion.length() + this.getOutputLineWidthOffset();
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                buf.append(currentVersion);
                current.add(buf.toString());
            }
            catch (InvalidVersionSpecificationException | InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s due to: %s", property.getName(), property.getVersion(), e.getMessage()));
            }
        }
        this.logLine(false, "");
        if (!current.isEmpty()) {
            this.logLine(false, "The following version properties are referencing the newest available version:");
            for (String s : new TreeSet(current)) {
                this.logLine(false, "  " + s);
            }
        }
        if (updates.isEmpty() && current.isEmpty()) {
            this.logLine(false, "This project does not have any properties associated with versions.");
        } else if (updates.isEmpty()) {
            this.logLine(false, "All version properties are referencing the newest version available.");
        }
        if (!updates.isEmpty()) {
            this.logLine(false, "The following version property updates are available:");
            for (String update : new TreeSet(updates)) {
                this.logLine(false, "  " + update);
            }
        }
        this.logLine(false, "");
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) {
    }
}

