/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyBuilder;

@Mojo(name="use-releases", threadSafe=true)
public class UseReleasesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="allowRangeMatching", defaultValue="false")
    private boolean allowRangeMatching;
    @Parameter(property="failIfNotReplaced", defaultValue="false")
    private boolean failIfNotReplaced;
    private final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    @Inject
    public UseReleasesMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        super(repositorySystem, projectBuilder, artifactMetadataSource, wagonManager, artifactResolver);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useReleases(pom, this.getProject().getParent());
            }
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useReleases(pom, PomHelper.readImportedPOMsFromDependencyManagementSection(pom));
                this.useReleases(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useReleases(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useReleases(ModifiedPomXMLEventReader pom, MavenProject project) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        String version = project.getVersion();
        Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
        if (versionMatcher.matches()) {
            String releaseVersion = versionMatcher.group(1);
            MavenProject parent = this.getProject().getParent();
            Artifact artifact = this.getHelper().createDependencyArtifact(DependencyBuilder.newBuilder().withGroupId(parent.getGroupId()).withArtifactId(parent.getArtifactId()).withVersion(releaseVersion).withType("pom").build());
            if (!this.isIncluded(artifact)) {
                return;
            }
            this.getLog().debug((CharSequence)("Looking for a release of " + this.toString(project)));
            artifact.setVersion(releaseVersion);
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            if (!this.allowRangeMatching) {
                if (versions.containsVersion(releaseVersion)) {
                    if (PomHelper.setProjectParentVersion(pom, releaseVersion)) {
                        this.getLog().info((CharSequence)("Updated " + this.toString(project) + " to version " + releaseVersion));
                    }
                } else if (this.failIfNotReplaced) {
                    throw new NoSuchElementException("No matching release of " + this.toString(project) + " found for update.");
                }
            } else {
                Object finalVersion = null;
                for (ArtifactVersion proposedVersion : versions.getVersions(false)) {
                    if (!proposedVersion.toString().startsWith(releaseVersion)) continue;
                    this.getLog().debug((CharSequence)("Found matching version for " + this.toString(project) + " to version " + releaseVersion));
                    finalVersion = proposedVersion;
                }
                if (finalVersion != null) {
                    if (PomHelper.setProjectParentVersion(pom, finalVersion.toString())) {
                        this.getLog().info((CharSequence)("Updated " + this.toString(project) + " to version " + finalVersion));
                        this.getChangeRecorder().recordUpdate("useReleases", parent.getGroupId(), parent.getArtifactId(), version, finalVersion.toString());
                    }
                } else {
                    this.getLog().info((CharSequence)("No matching release of " + this.toString(project) + " to update via rangeMatching."));
                    if (this.failIfNotReplaced) {
                        throw new NoSuchElementException("No matching release of " + this.toString(project) + " found for update via rangeMatching.");
                    }
                }
            }
        }
    }

    private void useReleases(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        for (Dependency dep : dependencies) {
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            if (version == null) {
                this.getLog().info((CharSequence)("Ignoring dependency with no version: " + this.toString(dep)));
                continue;
            }
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (!versionMatcher.matches()) continue;
            String releaseVersion = versionMatcher.group(1);
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Looking for a release of " + this.toString(dep)));
            artifact.setVersion(releaseVersion);
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            if (!this.allowRangeMatching) {
                this.noRangeMatching(pom, dep, version, releaseVersion, versions);
                continue;
            }
            this.rangeMatching(pom, dep, version, releaseVersion, versions);
        }
    }

    private void rangeMatching(ModifiedPomXMLEventReader pom, Dependency dep, String version, String releaseVersion, ArtifactVersions versions) throws XMLStreamException, MojoExecutionException {
        Object finalVersion = null;
        for (ArtifactVersion proposedVersion : versions.getVersions(false)) {
            if (!proposedVersion.toString().startsWith(releaseVersion)) continue;
            this.getLog().debug((CharSequence)("Found matching version for " + this.toString(dep) + " to version " + releaseVersion));
            finalVersion = proposedVersion;
        }
        if (finalVersion != null) {
            if (PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, finalVersion.toString(), this.getProject().getModel())) {
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + finalVersion));
                this.getChangeRecorder().recordUpdate("useReleases", dep.getGroupId(), dep.getArtifactId(), version, finalVersion.toString());
            }
        } else {
            this.getLog().info((CharSequence)("No matching release of " + this.toString(dep) + " to update via rangeMatching."));
            if (this.failIfNotReplaced) {
                throw new NoSuchElementException("No matching release of " + this.toString(dep) + " found for update via rangeMatching.");
            }
        }
    }

    private void noRangeMatching(ModifiedPomXMLEventReader pom, Dependency dep, String version, String releaseVersion, ArtifactVersions versions) throws XMLStreamException, MojoExecutionException {
        if (versions.containsVersion(releaseVersion)) {
            if (PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, releaseVersion, this.getProject().getModel())) {
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + releaseVersion));
                this.getChangeRecorder().recordUpdate("useReleases", dep.getGroupId(), dep.getArtifactId(), version, releaseVersion);
            }
        } else if (this.failIfNotReplaced) {
            throw new NoSuchElementException("No matching release of " + this.toString(dep) + " found for update.");
        }
    }
}

