/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Locale;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesModel;
import org.codehaus.mojo.versions.utils.PropertyComparator;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="property-updates-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class PropertyUpdatesReportMojo
extends AbstractVersionsReport<PropertyUpdatesModel> {
    @Parameter
    private Property[] properties;
    @Parameter(property="includeProperties")
    private String includeProperties = null;
    @Parameter(property="excludeProperties")
    private String excludeProperties = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;

    @Inject
    protected PropertyUpdatesReportMojo(I18N i18n, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ReportRendererFactory rendererFactory) {
        super(i18n, repositorySystem, artifactResolver, artifactMetadataSource, wagonManager, rendererFactory);
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.haveBuildProperties();
    }

    private boolean haveBuildProperties() {
        return this.getProject().getProperties() != null && !this.getProject().getProperties().isEmpty();
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeMap<Property, PropertyVersions> updateSet = new TreeMap<Property, PropertyVersions>(PropertyComparator.INSTANCE);
        try {
            updateSet.putAll(this.getHelper().getVersionPropertiesMap(this.getProject(), this.properties, this.includeProperties, this.excludeProperties, this.autoLinkItems));
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        this.rendererFactory.createReportRenderer(this.getOutputName(), this.getSink(), locale, new PropertyUpdatesModel(updateSet)).render();
    }

    public String getOutputName() {
        return "property-updates-report";
    }
}

