/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="display-dependency-updates", threadSafe=true)
public class DisplayDependencyUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int INFO_PAD_SIZE = 72;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement;
    @Parameter(property="processDependencyManagementTransitive", defaultValue="true")
    private boolean processDependencyManagementTransitive;
    @Parameter(property="dependencyManagementIncludes", defaultValue="*")
    private List<String> dependencyManagementIncludes;
    @Parameter(property="dependencyManagementExcludes")
    private List<String> dependencyManagementExcludes;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies;
    @Parameter(property="dependencyIncludes", defaultValue="*")
    private List<String> dependencyIncludes;
    @Parameter(property="dependencyExcludes")
    private List<String> dependencyExcludes;
    @Parameter(property="processPluginDependencies", defaultValue="true")
    private boolean processPluginDependencies;
    @Parameter(property="processPluginDependenciesInPluginManagement", defaultValue="true")
    private boolean processPluginDependenciesInPluginManagement;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;
    @Deprecated
    @Parameter(property="allowAnyUpdates", defaultValue="true")
    private boolean allowAnyUpdates;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="pluginDependencyIncludes", defaultValue="*")
    private List<String> pluginDependencyIncludes;
    @Parameter(property="pluginDependencyExcludes")
    private List<String> pluginDependencyExcludes;
    @Parameter(property="pluginManagementDependencyIncludes", defaultValue="*")
    private List<String> pluginManagementDependencyIncludes;
    @Parameter(property="pluginManagementDependencyExcludes")
    private List<String> pluginManagementDependencyExcludes;

    @Inject
    public DisplayDependencyUpdatesMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        super(repositorySystem, projectBuilder, artifactMetadataSource, wagonManager, artifactResolver);
    }

    private static Set<Dependency> extractPluginDependenciesFromPluginsInPluginManagement(Build build) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        if (build.getPluginManagement() != null) {
            for (Plugin plugin : build.getPluginManagement().getPlugins()) {
                if (plugin.getDependencies() == null || plugin.getDependencies().isEmpty()) continue;
                result.addAll(plugin.getDependencies());
            }
        }
        return result;
    }

    private static Set<Dependency> extractDependenciesFromPlugins(List<Plugin> plugins) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        for (Plugin plugin : plugins) {
            if (plugin.getDependencies() == null || plugin.getDependencies().isEmpty()) continue;
            result.addAll(plugin.getDependencies());
        }
        return result;
    }

    private static Set<Dependency> removeDependencyManagment(Set<Dependency> dependencies, Set<Dependency> dependencyManagement) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        for (Dependency dependency : dependencies) {
            boolean matched = false;
            for (Dependency managedDependency : dependencyManagement) {
                if (!DisplayDependencyUpdatesMojo.dependenciesMatch(dependency, managedDependency)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            result.add(dependency);
        }
        return result;
    }

    protected static boolean dependenciesMatch(Dependency dependency, Dependency managedDependency) {
        if (!managedDependency.getGroupId().equals(dependency.getGroupId())) {
            return false;
        }
        if (!managedDependency.getArtifactId().equals(dependency.getArtifactId())) {
            return false;
        }
        if (managedDependency.getScope() == null || Objects.equals(managedDependency.getScope(), dependency.getScope())) {
            return false;
        }
        if (managedDependency.getClassifier() == null || Objects.equals(managedDependency.getClassifier(), dependency.getClassifier())) {
            return false;
        }
        return dependency.getVersion() == null || managedDependency.getVersion() == null || Objects.equals(managedDependency.getVersion(), dependency.getVersion());
    }

    public boolean isProcessingDependencyManagement() {
        return this.processDependencyManagement;
    }

    public boolean isProcessingDependencies() {
        return this.processDependencies;
    }

    public boolean isProcessingPluginDependencies() {
        return this.processPluginDependencies;
    }

    public boolean isProcessPluginDependenciesInDependencyManagement() {
        return this.processPluginDependenciesInPluginManagement;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logInit();
        this.validateInput();
        Set<Dependency> dependencyManagement = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        DependencyManagement projectDependencyManagement = this.getProjectDependencyManagement(this.getProject());
        if (projectDependencyManagement != null) {
            List dependenciesFromPom = projectDependencyManagement.getDependencies();
            for (Dependency dependency : dependenciesFromPom) {
                this.getLog().debug((CharSequence)("dependency from pom: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getScope()));
                if (dependency.getVersion() == null) {
                    if (this.getProject().hasParent()) {
                        this.getLog().debug((CharSequence)"Reading parent dependencyManagement information");
                        DependencyManagement parentProjectDependencyManagement = this.getProjectDependencyManagement(this.getProject().getParent());
                        if (parentProjectDependencyManagement == null) continue;
                        List parentDeps = parentProjectDependencyManagement.getDependencies();
                        for (Dependency parentDep : parentDeps) {
                            if (!dependency.getGroupId().equals(parentDep.getGroupId()) || !dependency.getArtifactId().equals(parentDep.getArtifactId()) || !dependency.getType().equals(parentDep.getType())) continue;
                            dependencyManagement.add(parentDep);
                        }
                        continue;
                    }
                    String message = "We can't get the version for the dependency " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " cause there does not exist a parent.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
                dependencyManagement.add(dependency);
            }
        }
        Set<Dependency> dependencies = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        dependencies.addAll(this.getProject().getDependencies());
        if (this.isProcessingDependencyManagement()) {
            dependencies = DisplayDependencyUpdatesMojo.removeDependencyManagment(dependencies, dependencyManagement);
        }
        Set<Dependency> pluginDependencies = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        if (this.isProcessingPluginDependencies()) {
            pluginDependencies = DisplayDependencyUpdatesMojo.extractDependenciesFromPlugins(this.getProject().getBuildPlugins());
        }
        Set<Dependency> pluginDependenciesInPluginManagement = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        if (this.isProcessPluginDependenciesInDependencyManagement()) {
            pluginDependenciesInPluginManagement = DisplayDependencyUpdatesMojo.extractPluginDependenciesFromPluginsInPluginManagement(this.getProject().getBuild());
        }
        try {
            if (this.isProcessingDependencyManagement()) {
                dependencyManagement = this.filterDependencyManagementIncludes(dependencyManagement);
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencyManagement, false), "Dependency Management");
            }
            if (this.isProcessingDependencies()) {
                dependencies = this.filterDependencyIncludes(dependencies);
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencies, false), "Dependencies");
            }
            if (this.isProcessPluginDependenciesInDependencyManagement()) {
                pluginDependenciesInPluginManagement = this.filterPluginManagementIncludes(pluginDependenciesInPluginManagement);
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(pluginDependenciesInPluginManagement, false), "pluginManagement of plugins");
            }
            if (this.isProcessingPluginDependencies()) {
                pluginDependencies = this.filterPluginDependencyIncludes(pluginDependencies);
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(pluginDependencies, false), "Plugin Dependencies");
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void validateInput() throws MojoExecutionException {
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyIncludes, 6, "dependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyExcludes, 6, "dependencyExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyManagementIncludes, 6, "dependencyManagementIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyManagementIncludes, 6, "dependencyManagementExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginDependencyIncludes, 3, "pluginDependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginDependencyExcludes, 3, "pluginDependencyExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginManagementDependencyIncludes, 3, "pluginManagementDependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginManagementDependencyExcludes, 3, "pluginManagementDependencyExcludes");
    }

    static void validateGAVList(List<String> gavList, int numSections, String argumentName) throws MojoExecutionException {
        if (gavList != null && gavList.stream().anyMatch(gav -> org.apache.commons.lang3.StringUtils.countMatches((CharSequence)gav, (CharSequence)":") >= numSections)) {
            throw new MojoExecutionException(argumentName + " should not contain more than 6 segments");
        }
    }

    private Set<Dependency> filterDependencyIncludes(Set<Dependency> dependencies) {
        return this.filterDependencies(dependencies, this.dependencyIncludes, this.dependencyExcludes, "Dependencies");
    }

    private Set<Dependency> filterDependencyManagementIncludes(Set<Dependency> dependencyManagement) {
        return this.filterDependencies(dependencyManagement, this.dependencyManagementIncludes, this.dependencyManagementExcludes, "Dependecy Management");
    }

    private Set<Dependency> filterPluginDependencyIncludes(Set<Dependency> dependencies) {
        return this.filterDependencies(dependencies, this.pluginDependencyIncludes, this.pluginDependencyExcludes, "Plugin Dependencies");
    }

    private Set<Dependency> filterPluginManagementIncludes(Set<Dependency> dependencyManagement) {
        return this.filterDependencies(dependencyManagement, this.pluginManagementDependencyIncludes, this.pluginManagementDependencyExcludes, "Plugin Management Dependencies");
    }

    private Set<Dependency> filterDependencies(Set<Dependency> dependencies, List<String> includes, List<String> excludes, String section) {
        DependencyFilter includeDeps = DependencyFilter.parseFrom(includes);
        DependencyFilter excludeDeps = DependencyFilter.parseFrom(excludes);
        Set<Dependency> filtered = includeDeps.retainingIn(dependencies);
        filtered = excludeDeps.removingFrom(filtered);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("parsed includes in %s: %s -> %s", section, includes, includeDeps));
            this.getLog().debug((CharSequence)String.format("parsed excludes in %s: %s -> %s", section, excludes, excludeDeps));
            this.getLog().debug((CharSequence)(String.format("Unfiltered %s: ", section) + this.output(dependencies)));
            this.getLog().debug((CharSequence)(String.format("Filtered %s: ", section) + this.output(filtered)));
        }
        return filtered;
    }

    private String output(Set<Dependency> dependencies) {
        return dependencies.stream().map(d -> String.format("%s:%s:%s", d.getGroupId(), d.getArtifactId(), d.getVersion())).collect(Collectors.joining(", "));
    }

    private DependencyManagement getProjectDependencyManagement(MavenProject project) {
        if (this.processDependencyManagementTransitive) {
            return project.getDependencyManagement();
        }
        return project.getOriginalModel().getDependencyManagement();
    }

    private Optional<Segment> calculateUpdateScope() {
        return this.allowAnyUpdates ? Optional.empty() : Optional.of(SegmentUtils.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates, this.getLog()).map(s -> Segment.of(s.value() - 1)).orElse(Segment.MAJOR));
    }

    private void logUpdates(Map<Dependency, ArtifactVersions> updates, String section) {
        ArrayList withUpdates = new ArrayList();
        ArrayList<String> usingCurrent = new ArrayList<String>();
        for (ArtifactVersions versions : updates.values()) {
            ArrayList<String> t;
            ArtifactVersion latest;
            String current;
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            if (versions.isCurrentVersionDefined()) {
                current = versions.getCurrentVersion().toString();
                latest = versions.getNewestUpdate(this.calculateUpdateScope(), this.allowSnapshots);
            } else {
                ArtifactVersion newestVersion = versions.getNewestVersion(versions.getArtifact().getVersionRange(), this.allowSnapshots);
                current = versions.getArtifact().getVersionRange().toString();
                ArtifactVersion artifactVersion = latest = newestVersion == null ? null : versions.getNewestUpdate(newestVersion, this.calculateUpdateScope(), this.allowSnapshots);
                if (latest != null && ArtifactVersions.isVersionInRange(latest, versions.getArtifact().getVersionRange())) {
                    latest = null;
                }
            }
            String right = " " + (latest == null ? current : current + " -> " + latest);
            ArrayList<String> arrayList = t = latest == null ? usingCurrent : withUpdates;
            if (right.length() + left.length() + 3 > 72 + this.getOutputLineWidthOffset()) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)(72 + this.getOutputLineWidthOffset())));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(72 + this.getOutputLineWidthOffset() - right.length()), (String)".") + right);
        }
        if (this.isVerbose()) {
            if (usingCurrent.isEmpty()) {
                if (!withUpdates.isEmpty()) {
                    this.logLine(false, "No dependencies in " + section + " are using the newest version.");
                    this.logLine(false, "");
                }
            } else {
                this.logLine(false, "The following dependencies in " + section + " are using the newest version:");
                for (String s : usingCurrent) {
                    this.logLine(false, s);
                }
                this.logLine(false, "");
            }
        }
        if (withUpdates.isEmpty()) {
            if (!usingCurrent.isEmpty()) {
                this.logLine(false, "No dependencies in " + section + " have newer versions.");
                this.logLine(false, "");
            }
        } else {
            this.logLine(false, "The following dependencies in " + section + " have newer versions:");
            for (String withUpdate : withUpdates) {
                this.logLine(false, withUpdate);
            }
            this.logLine(false, "");
        }
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }
}

